/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.cover;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class TestComponentManagerContainer {
    private static final Logger log = LoggerFactory.getLogger(TestComponentManagerContainer.class);
    private SpringCompMgr componentManager;

    public TestComponentManagerContainer(String configPaths) throws IOException {
        this(configPaths, null);
    }

    public TestComponentManagerContainer(String configPaths, Properties props) throws IOException {
        String[] configPath;
        if (ComponentManager.m_componentManager != null) {
            log.info("Closing existing Component Manager ");
            log.info("Closing Complete ");
            ComponentManager.m_componentManager = null;
        }
        log.info("Starting Component Manager with [" + configPaths + "]");
        ComponentManager.setLateRefresh(true);
        this.componentManager = (SpringCompMgr)ComponentManager.getInstance();
        ConfigurableApplicationContext ac = this.componentManager.getApplicationContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (props != null) {
            PropertyOverrideConfigurer beanFactoryPostProcessor = new PropertyOverrideConfigurer();
            beanFactoryPostProcessor.setBeanNameSeparator("@");
            beanFactoryPostProcessor.setProperties(props);
            ac.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)beanFactoryPostProcessor);
        }
        ArrayList<Resource> config = new ArrayList<Resource>();
        for (String p : configPath = configPaths.split(";")) {
            File xml = new File(p);
            config.add((Resource)new FileSystemResource(xml.getCanonicalPath()));
        }
        this.loadComponent(ac, config, classLoader);
        ac.refresh();
        try {
            Thread.sleep(500L);
            log.debug("Finished starting the component manager");
        }
        catch (InterruptedException e) {
            log.error("Component manager startup interrupted...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadComponent(ConfigurableApplicationContext ac, List<Resource> config, ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ac.getBeanFactory());
            reader.setBeanClassLoader(loader);
            reader.loadBeanDefinitions(config.toArray(new Resource[0]));
        }
        catch (Throwable t) {
            log.warn("loadComponentPackage: exception loading: " + config + " : " + t, t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public org.sakaiproject.component.api.ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected String generateSiteId() {
        return "site-" + this.getClass().getName() + "-" + Math.floor(Math.random() * 100000.0);
    }

    public static final Object getServiceProxy(Class clazz, InvocationHandler handler) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, handler);
    }

    public static void setSakaiHome(String sakaiHome) {
        System.setProperty("sakai.home", sakaiHome);
    }

    public Object getService(String beanId) {
        try {
            return this.componentManager.get(beanId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

