/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.io.File;
import java.util.Arrays;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SakaiContextLoader
extends ContextLoader {
    private static final Logger log = LoggerFactory.getLogger(SakaiContextLoader.class);
    public static final String SPRING_CONTEXT_SUFFIX = "-context.xml";

    public SakaiContextLoader(WebApplicationContext context) {
        super(context);
    }

    protected void customizeContext(ServletContext sc, ConfigurableWebApplicationContext wac) {
        String servletName;
        String location;
        super.customizeContext(sc, wac);
        if (wac != null && StringUtils.isNotBlank((CharSequence)(location = this.getHomeBeanDefinitionIfExists(servletName = sc.getServletContextName())))) {
            String[] configLocations = wac.getConfigLocations();
            String[] newLocations = Arrays.copyOf(configLocations, configLocations.length + 1);
            newLocations[configLocations.length] = "file:" + location;
            wac.setConfigLocations(newLocations);
            log.info("Servlet {} added an additional bean config location [{}]", (Object)servletName, (Object)location);
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ConfigurableApplicationContext sharedAc = ((SpringCompMgr)ComponentManager.getInstance()).getApplicationContext();
        return sharedAc;
    }

    private String getHomeBeanDefinitionIfExists(String servletName) {
        if (StringUtils.isBlank((CharSequence)servletName)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)servletName)) {
            String name = servletName + SPRING_CONTEXT_SUFFIX;
            String path = ServerConfigurationService.getSakaiHomePath();
            String location = path + name;
            log.debug("Servlet " + servletName + " is checking for a bean definition at sakai.home/" + name);
            if (new File(location).canRead()) {
                log.info("Servlet " + servletName + " located an additional bean definition at sakai.home/" + name);
                return location;
            }
            log.debug("Servlet " + servletName + " did not find a bean definition at sakai.home/" + name);
        }
        return null;
    }

    public SakaiContextLoader() {
    }
}

