/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.impl.SakaiContextLoader;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SakaiContextLoaderListener
extends SakaiContextLoader
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(SakaiContextLoaderListener.class);

    public void contextInitialized(ServletContextEvent event) {
        this.initWebApplicationContext(event.getServletContext());
        ((SpringCompMgr)ComponentManager.getInstance()).addChildAc();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.closeWebApplicationContext(event.getServletContext());
        SakaiContextLoaderListener.cleanupAttributes(event.getServletContext());
        log.debug("Destroying Components in {}", (Object)event.getServletContext().getServletContextName());
        ((SpringCompMgr)ComponentManager.getInstance()).removeChildAc();
    }

    private static void cleanupAttributes(ServletContext sc) {
        Enumeration attrNames = sc.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Object attrValue;
            String attrName = (String)attrNames.nextElement();
            if (!attrName.startsWith("org.springframework.") || !((attrValue = sc.getAttribute(attrName)) instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)attrValue).destroy();
            }
            catch (Throwable ex) {
                log.error("Couldn't invoke destroy method of attribute with name '" + attrName + "'", ex);
            }
        }
    }
}

