/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.cover;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.sakaiproject.component.impl.MockCompMgr;
import org.sakaiproject.component.impl.SpringCompMgr;

public class ComponentManager {
    protected static org.sakaiproject.component.api.ComponentManager m_componentManager = null;
    public static final boolean CACHE_COMPONENTS = true;
    public static String SAKAI_COMPONENTS_ROOT_SYS_PROP = "sakai.components.root";
    private static Lock m_lock = new ReentrantLock(false);
    private static boolean lateRefresh = false;
    public static boolean testingMode = false;

    private ComponentManager() {
    }

    public static boolean isTestingMode() {
        return m_componentManager == null && testingMode || m_componentManager instanceof MockCompMgr;
    }

    public static void shutdown() {
        m_lock.lock();
        try {
            if (m_componentManager != null) {
                m_componentManager.close();
                m_componentManager = null;
            }
        }
        finally {
            m_lock.unlock();
        }
    }

    public static org.sakaiproject.component.api.ComponentManager getInstance() {
        m_lock.lock();
        try {
            if (m_componentManager == null) {
                if (testingMode) {
                    m_componentManager = new MockCompMgr(false);
                } else {
                    m_componentManager = new SpringCompMgr(null);
                    ((SpringCompMgr)m_componentManager).init(lateRefresh);
                }
            }
        }
        finally {
            m_lock.unlock();
        }
        return m_componentManager;
    }

    public static <T> T get(Class<T> iface) {
        return ComponentManager.getInstance().get(iface);
    }

    public static Object get(String ifaceName) {
        return ComponentManager.getInstance().get(ifaceName);
    }

    public static boolean contains(Class iface) {
        return ComponentManager.getInstance().contains(iface);
    }

    public static boolean contains(String ifaceName) {
        return ComponentManager.getInstance().contains(ifaceName);
    }

    public static Set getRegisteredInterfaces() {
        return ComponentManager.getInstance().getRegisteredInterfaces();
    }

    public static void loadComponent(Class iface, Object component) {
        ComponentManager.getInstance().loadComponent(iface, component);
    }

    public static void loadComponent(String ifaceName, Object component) {
        ComponentManager.getInstance().loadComponent(ifaceName, component);
    }

    public static void close() {
        ComponentManager.getInstance().close();
    }

    @Deprecated
    public static Properties getConfig() {
        return ComponentManager.getInstance().getConfig();
    }

    public static void waitTillConfigured() {
        try {
            m_lock.lockInterruptibly();
            m_lock.unlock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean hasBeenClosed() {
        return ComponentManager.getInstance().hasBeenClosed();
    }

    public static void setLateRefresh(boolean b) {
        lateRefresh = b;
    }
}

