/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.util.BeanFactoryPostProcessorCreator;
import org.sakaiproject.util.ReversiblePropertyOverrideConfigurer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public class SakaiProperties
implements BeanFactoryPostProcessorCreator,
InitializingBean {
    private static Log log = LogFactory.getLog(SakaiProperties.class);
    private SakaiPropertiesFactoryBean propertiesFactoryBean = new SakaiPropertiesFactoryBean();
    private ReversiblePropertyOverrideConfigurer propertyOverrideConfigurer = new ReversiblePropertyOverrideConfigurer();
    private PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();

    public SakaiProperties() {
        this.propertiesFactoryBean.setIgnoreResourceNotFound(true);
        this.propertyPlaceholderConfigurer.setIgnoreUnresolvablePlaceholders(true);
        this.propertyPlaceholderConfigurer.setOrder(0);
        this.propertyOverrideConfigurer.setBeanNameAtEnd(true);
        this.propertyOverrideConfigurer.setBeanNameSeparator("@");
        this.propertyOverrideConfigurer.setIgnoreInvalidKeys(true);
    }

    public void afterPropertiesSet() throws Exception {
        this.propertiesFactoryBean.afterPropertiesSet();
        this.propertyPlaceholderConfigurer.setProperties((Properties)this.propertiesFactoryBean.getObject());
        this.propertyOverrideConfigurer.setProperties((Properties)this.propertiesFactoryBean.getObject());
    }

    @Override
    public Collection<BeanFactoryPostProcessor> getBeanFactoryPostProcessors() {
        return Arrays.asList(new BeanFactoryPostProcessor[]{this.propertyOverrideConfigurer, this.propertyPlaceholderConfigurer});
    }

    public Map<String, Properties> getSeparateProperties() {
        LinkedHashMap<String, Properties> m = new LinkedHashMap<String, Properties>();
        for (Map.Entry<String, Properties> entry : this.propertiesFactoryBean.getLoadedProperties().entrySet()) {
            m.put(entry.getKey(), this.dereferenceProperties(entry.getValue()));
        }
        return m;
    }

    public Properties getProperties() {
        Properties rawProperties = this.getRawProperties();
        Properties parsedProperties = this.dereferenceProperties(rawProperties);
        return parsedProperties;
    }

    public Properties getRawProperties() {
        try {
            return (Properties)this.propertiesFactoryBean.getObject();
        }
        catch (IOException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error collecting Sakai properties", (Throwable)e);
            }
            return new Properties();
        }
    }

    private Properties dereferenceProperties(Properties srcProperties) throws RuntimeException {
        if (srcProperties == null) {
            return null;
        }
        if (srcProperties.isEmpty()) {
            return srcProperties;
        }
        try {
            Properties parsedProperties = new Properties();
            PropertyPlaceholderConfigurer resolver = new PropertyPlaceholderConfigurer();
            resolver.setIgnoreUnresolvablePlaceholders(true);
            Method parseStringValue = resolver.getClass().getDeclaredMethod("parseStringValue", String.class, Properties.class, Set.class);
            parseStringValue.setAccessible(true);
            for (Map.Entry<Object, Object> propEntry : srcProperties.entrySet()) {
                String parsedPropValue = (String)parseStringValue.invoke((Object)resolver, (String)propEntry.getValue(), srcProperties, new HashSet());
                parsedProperties.setProperty((String)propEntry.getKey(), parsedPropValue);
            }
            return parsedProperties;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dereference properties", e);
        }
    }

    public void setProperties(Properties properties) {
        this.propertiesFactoryBean.setProperties(properties);
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.propertiesFactoryBean.setPropertiesArray(propertiesArray);
    }

    public void setLocation(Resource location) {
        this.propertiesFactoryBean.setLocation(location);
    }

    public void setLocations(Resource[] locations) {
        this.propertiesFactoryBean.setLocations(locations);
    }

    public void setFileEncoding(String encoding) {
        this.propertiesFactoryBean.setFileEncoding(encoding);
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.propertiesFactoryBean.setIgnoreResourceNotFound(ignoreResourceNotFound);
    }

    public void setLocalOverride(boolean localOverride) {
        this.propertiesFactoryBean.setLocalOverride(localOverride);
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.propertyPlaceholderConfigurer.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
    }

    public void setOrder(int order) {
        this.propertyPlaceholderConfigurer.setOrder(order);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.propertyPlaceholderConfigurer.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.propertyPlaceholderConfigurer.setPlaceholderSuffix(placeholderSuffix);
    }

    public void setSearchSystemEnvironment(boolean searchSystemEnvironment) {
        this.propertyPlaceholderConfigurer.setSearchSystemEnvironment(searchSystemEnvironment);
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.propertyPlaceholderConfigurer.setSystemPropertiesMode(systemPropertiesMode);
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        this.propertyPlaceholderConfigurer.setSystemPropertiesModeName(constantName);
    }

    public void setBeanNameAtEnd(boolean beanNameAtEnd) {
        this.propertyOverrideConfigurer.setBeanNameAtEnd(beanNameAtEnd);
    }

    public void setBeanNameSeparator(String beanNameSeparator) {
        this.propertyOverrideConfigurer.setBeanNameSeparator(beanNameSeparator);
    }

    public void setIgnoreInvalidKeys(boolean ignoreInvalidKeys) {
        this.propertyOverrideConfigurer.setIgnoreInvalidKeys(ignoreInvalidKeys);
    }

    public class SakaiPropertiesFactoryBean
    implements FactoryBean,
    InitializingBean {
        public static final String XML_FILE_EXTENSION = ".xml";
        final Log log = LogFactory.getLog(SakaiPropertiesFactoryBean.class);
        private Map<String, Properties> loadedProperties = new LinkedHashMap<String, Properties>();
        private Properties[] localProperties;
        private Resource[] locations;
        private boolean localOverride = false;
        private boolean ignoreResourceNotFound = false;
        private String fileEncoding;
        private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
        private boolean singleton = true;
        private Object singletonInstance;

        public Map<String, Properties> getLoadedProperties() {
            return this.loadedProperties;
        }

        public final void setSingleton(boolean singleton) {
        }

        public final boolean isSingleton() {
            return this.singleton;
        }

        public final void afterPropertiesSet() throws IOException {
            if (this.singleton) {
                this.singletonInstance = this.createInstance();
            }
        }

        public final Object getObject() throws IOException {
            if (this.singleton) {
                return this.singletonInstance;
            }
            return this.createInstance();
        }

        public Class getObjectType() {
            return Properties.class;
        }

        protected Object createInstance() throws IOException {
            return this.mergeProperties();
        }

        public void setProperties(Properties properties) {
            this.localProperties = new Properties[]{properties};
        }

        public void setPropertiesArray(Properties[] propertiesArray) {
            this.localProperties = propertiesArray;
        }

        public void setLocation(Resource location) {
            this.locations = new Resource[]{location};
        }

        public void setLocations(Resource[] locations) {
            this.locations = locations;
        }

        public void setLocalOverride(boolean localOverride) {
            this.localOverride = localOverride;
        }

        public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
            this.ignoreResourceNotFound = ignoreResourceNotFound;
        }

        public void setFileEncoding(String encoding) {
            this.fileEncoding = encoding;
        }

        public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
            this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
        }

        protected Properties mergeProperties() throws IOException {
            Properties result = new Properties();
            if (this.localOverride) {
                this.loadProperties(result);
            }
            if (this.localProperties != null) {
                for (int i = 0; i < this.localProperties.length; ++i) {
                    this.loadedProperties.put("local" + i, this.localProperties[i]);
                    CollectionUtils.mergePropertiesIntoMap((Properties)this.localProperties[i], (Map)result);
                }
            }
            if (!this.localOverride) {
                this.loadProperties(result);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Loaded a total of " + result.size() + " properties"));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadProperties(Properties props) throws IOException {
            if (this.locations != null) {
                for (int i = 0; i < this.locations.length; ++i) {
                    Resource location = this.locations[i];
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Loading properties file from " + location));
                    }
                    InputStream is = null;
                    try {
                        Properties p = new Properties();
                        is = location.getInputStream();
                        if (location.getFilename().endsWith(XML_FILE_EXTENSION)) {
                            this.propertiesPersister.loadFromXml(p, is);
                        } else if (this.fileEncoding != null) {
                            this.propertiesPersister.load(p, (Reader)new InputStreamReader(is, this.fileEncoding));
                        } else {
                            this.propertiesPersister.load(p, is);
                        }
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("Loaded " + p.size() + " properties from file " + location));
                        }
                        this.loadedProperties.put(location.getFilename(), p);
                        props.putAll((Map<?, ?>)p);
                        continue;
                    }
                    catch (IOException ex) {
                        if (this.ignoreResourceNotFound) {
                            if (!this.log.isWarnEnabled()) continue;
                            this.log.warn((Object)("Could not load properties from " + location + ": " + ex.getMessage()));
                            continue;
                        }
                        throw ex;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
        }
    }
}

