/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import org.sakaiproject.component.api.ServerConfigurationService;

public class BasicConfigHistory
implements ServerConfigurationService.ConfigHistory {
    protected int version = 0;
    protected long timestamp = 0L;
    protected String source = "UNKNOWN";
    protected Object value = null;
    protected boolean secured = false;

    public BasicConfigHistory(int version, String source, Object value) {
        if (version <= 0) {
            throw new IllegalArgumentException("minimum version is 1: version=" + version);
        }
        this.version = version;
        if (source != null && !"".equals(source)) {
            this.source = source;
        }
        this.value = value;
        this.timestamp = System.currentTimeMillis();
    }

    protected BasicConfigHistory(int version, long timestamp, String source, Object value) {
        this(version, source, value);
        this.timestamp = timestamp;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicConfigHistory other = (BasicConfigHistory)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.source + "(v" + this.version + "," + this.timestamp + "):" + (this.secured ? "**SECURITY**" : (String)this.value);
    }
}

