/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;

public class ReversiblePropertyOverrideConfigurer
extends PropertyOverrideConfigurer {
    private boolean beanNameAtEnd = true;
    private String beanNameSeparator;

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value) throws BeansException {
        if (this.beanNameAtEnd) {
            int separatorIndex = key.indexOf(this.beanNameSeparator);
            if (separatorIndex >= 0) {
                String beanProperty = key.substring(0, separatorIndex);
                String beanName = key.substring(separatorIndex + 1);
                key = beanName + this.beanNameSeparator + beanProperty;
            }
            super.processKey(factory, key, value);
        }
    }

    public void setBeanNameSeparator(String beanNameSeparator) {
        this.beanNameSeparator = beanNameSeparator;
        super.setBeanNameSeparator(beanNameSeparator);
    }

    public boolean isBeanNameAtEnd() {
        return this.beanNameAtEnd;
    }

    public void setBeanNameAtEnd(boolean beanNameAtEnd) {
        this.beanNameAtEnd = beanNameAtEnd;
    }
}

