/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.cover;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestComponentManagerContainer {
    private static final Log log = LogFactory.getLog(TestComponentManagerContainer.class);
    private SpringCompMgr componentManager;

    public TestComponentManagerContainer(String configPaths) throws IOException {
        String[] configPath;
        if (ComponentManager.m_componentManager != null) {
            log.info((Object)"Closing existing Component Manager ");
            log.info((Object)"Closing Complete ");
            ComponentManager.m_componentManager = null;
        }
        log.info((Object)("Starting Component Manager with [" + configPaths + "]"));
        ComponentManager.setLateRefresh(true);
        this.componentManager = (SpringCompMgr)ComponentManager.getInstance();
        ConfigurableApplicationContext ac = this.componentManager.getApplicationContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<Resource> config = new ArrayList<Resource>();
        for (String p : configPath = configPaths.split(";")) {
            File xml = new File(p);
            config.add((Resource)new FileSystemResource(xml.getCanonicalPath()));
        }
        this.loadComponent(ac, config, classLoader);
        ac.refresh();
        log.debug((Object)"Finished starting the component manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadComponent(ConfigurableApplicationContext ac, List<Resource> config, ClassLoader loader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ac.getBeanFactory());
            reader.setBeanClassLoader(loader);
            reader.loadBeanDefinitions(config.toArray(new Resource[0]));
        }
        catch (Throwable t) {
            log.warn((Object)("loadComponentPackage: exception loading: " + config + " : " + t), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public org.sakaiproject.component.api.ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected String generateSiteId() {
        return "site-" + this.getClass().getName() + "-" + Math.floor(Math.random() * 100000.0);
    }

    public static final Object getServiceProxy(Class clazz, InvocationHandler handler) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, handler);
    }

    public static void setSakaiHome(String sakaiHome) {
        System.setProperty("sakai.home", sakaiHome);
    }

    public Object getService(String beanId) {
        try {
            return this.componentManager.get(beanId);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

