/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.event;

import com.binance.api.client.domain.event.AccountUpdateEvent;
import com.binance.api.client.domain.event.BalanceUpdateEvent;
import com.binance.api.client.domain.event.OrderTradeUpdateEvent;
import com.binance.api.client.domain.event.UserDataUpdateEvent;
import com.binance.api.client.exception.BinanceApiException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class UserDataUpdateEventDeserializer
extends JsonDeserializer<UserDataUpdateEvent> {
    private ObjectMapper mapper;

    public UserDataUpdateEvent deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        String json = node.toString();
        String eventTypeId = node.get("e").asText();
        Long eventTime = node.get("E").asLong();
        UserDataUpdateEvent.UserDataUpdateEventType userDataUpdateEventType = UserDataUpdateEvent.UserDataUpdateEventType.fromEventTypeId(eventTypeId);
        UserDataUpdateEvent userDataUpdateEvent = new UserDataUpdateEvent();
        userDataUpdateEvent.setEventType(userDataUpdateEventType);
        userDataUpdateEvent.setEventTime(eventTime);
        if (userDataUpdateEventType == UserDataUpdateEvent.UserDataUpdateEventType.ACCOUNT_POSITION_UPDATE) {
            AccountUpdateEvent accountUpdateEvent = this.getUserDataUpdateEventDetail(json, AccountUpdateEvent.class, this.mapper);
            userDataUpdateEvent.setOutboundAccountPositionUpdateEvent(accountUpdateEvent);
        } else if (userDataUpdateEventType == UserDataUpdateEvent.UserDataUpdateEventType.BALANCE_UPDATE) {
            BalanceUpdateEvent balanceUpdateEvent = this.getUserDataUpdateEventDetail(json, BalanceUpdateEvent.class, this.mapper);
            userDataUpdateEvent.setBalanceUpdateEvent(balanceUpdateEvent);
        } else {
            OrderTradeUpdateEvent orderTradeUpdateEvent = this.getUserDataUpdateEventDetail(json, OrderTradeUpdateEvent.class, this.mapper);
            userDataUpdateEvent.setOrderTradeUpdateEvent(orderTradeUpdateEvent);
        }
        return userDataUpdateEvent;
    }

    public <T> T getUserDataUpdateEventDetail(String json, Class<T> clazz, ObjectMapper mapper) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new BinanceApiException(e);
        }
    }
}

