/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.reflector;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

class ReflectorClassWriter
extends ClassWriter {
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type FIELD_TYPE = Type.getType(Field.class);
    private static final Type METHOD_TYPE = Type.getType(java.lang.reflect.Method.class);
    private static final Type CONSTRUCTOR_TYPE = Type.getType(java.lang.reflect.Constructor.class);
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type STRINGBUILDER_TYPE = Type.getType(StringBuilder.class);
    private static final Type THROWABLE_TYPE = Type.getType(Throwable.class);
    private static final Type ASSERTION_ERROR_TYPE = Type.getType(AssertionError.class);
    private static final Type INVOCATION_TARGET_EXCEPTION_TYPE = Type.getType(InvocationTargetException.class);
    private static final Type REFLECTIVE_OPERATION_EXCEPTION_TYPE = Type.getType(ReflectiveOperationException.class);
    private static final Method CLASS$GET_DECLARED_FIELD = ReflectorClassWriter.findMethod(Class.class, "getDeclaredField", new Class[]{String.class});
    private static final Method CLASS$GET_DECLARED_METHOD = ReflectorClassWriter.findMethod(Class.class, "getDeclaredMethod", new Class[]{String.class, Class[].class});
    private static final Method CLASS$GET_DECLARED_CONSTRUCTOR = ReflectorClassWriter.findMethod(Class.class, "getDeclaredConstructor", new Class[]{Class[].class});
    private static final Method ACCESSIBLE_OBJECT$SET_ACCESSIBLE = ReflectorClassWriter.findMethod(AccessibleObject.class, "setAccessible", new Class[]{Boolean.TYPE});
    private static final Method FIELD$GET = ReflectorClassWriter.findMethod(Field.class, "get", new Class[]{Object.class});
    private static final Method FIELD$SET = ReflectorClassWriter.findMethod(Field.class, "set", new Class[]{Object.class, Object.class});
    private static final Method METHOD$INVOKE = ReflectorClassWriter.findMethod(java.lang.reflect.Method.class, "invoke", new Class[]{Object.class, Object[].class});
    private static final Method CONSTRUCTOR$NEWINSTANCE = ReflectorClassWriter.findMethod(java.lang.reflect.Constructor.class, "newInstance", new Class[]{Object[].class});
    private static final Method THROWABLE$GET_CAUSE = ReflectorClassWriter.findMethod(Throwable.class, "getCause", new Class[0]);
    private static final Method OBJECT_INIT = new Method("<init>", Type.VOID_TYPE, new Type[0]);
    private static final Method STRINGBUILDER$APPEND = ReflectorClassWriter.findMethod(StringBuilder.class, "append", new Class[]{String.class});
    private static final Method STRINGBUILDER$TO_STRING = ReflectorClassWriter.findMethod(StringBuilder.class, "toString", new Class[0]);
    private static final Method CLASS$GET_CLASS_LOADER = ReflectorClassWriter.findMethod(Class.class, "getClassLoader", new Class[0]);
    private static final Method STRING$VALUE_OF = ReflectorClassWriter.findMethod(String.class, "valueOf", new Class[]{Object.class});
    private static final Method ASSERTION_ERROR_INIT = new Method("<init>", Type.VOID_TYPE, new Type[]{STRING_TYPE, THROWABLE_TYPE});
    private static final String TARGET_FIELD = "__target__";
    private final Class<?> iClass;
    private final Type iType;
    private final Type reflectorType;
    private final Type targetType;
    private final boolean directModifier;
    private int nextMethodNumber = 0;
    private final Set<String> fieldRefs = new HashSet<String>();

    private static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return ReflectorClassWriter.asmMethod(clazz.getMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    ReflectorClassWriter(Class<?> iClass, Class<?> targetClass, String reflectorName) {
        super(3);
        this.iClass = iClass;
        this.iType = Type.getType(iClass);
        this.reflectorType = this.asType(reflectorName);
        this.targetType = Type.getType(targetClass);
        ForType forType = iClass.getAnnotation(ForType.class);
        this.directModifier = forType != null && forType.direct();
    }

    void write() {
        int accessModifiers = this.iClass.getModifiers() & 1;
        this.visit(49, accessModifiers | 0x20 | 0x10, this.reflectorType.getInternalName(), null, OBJECT_TYPE.getInternalName(), new String[]{this.iType.getInternalName()});
        this.writeTargetField();
        this.writeConstructor();
        for (java.lang.reflect.Method method : this.iClass.getMethods()) {
            if (method.isDefault()) continue;
            Accessor accessor = method.getAnnotation(Accessor.class);
            Constructor constructor = method.getAnnotation(Constructor.class);
            if (accessor != null) {
                new AccessorMethodWriter(method, accessor).write();
                continue;
            }
            if (constructor != null) {
                new ConstructorMethodWriter(method).write();
                continue;
            }
            new ReflectorMethodWriter(method).write();
        }
        this.visitEnd();
    }

    private void writeTargetField() {
        this.visitField(2, TARGET_FIELD, this.targetType.getDescriptor(), null, null);
    }

    private void writeConstructor() {
        Method initMethod = new Method("<init>", Type.VOID_TYPE, new Type[]{this.targetType});
        GeneratorAdapter init = new GeneratorAdapter(1, initMethod, null, null, (ClassVisitor)this);
        init.loadThis();
        init.invokeConstructor(OBJECT_TYPE, OBJECT_INIT);
        init.loadThis();
        init.loadArg(0);
        init.putField(this.reflectorType, TARGET_FIELD, this.targetType);
        init.returnValue();
        init.endMethod();
    }

    private static String[] getInternalNames(Class<?>[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Type.getType(types[i]).getInternalName();
        }
        return names;
    }

    private Type asType(String reflectorName) {
        return Type.getType((String)("L" + reflectorName.replace('.', '/') + ";"));
    }

    private static Method asmMethod(java.lang.reflect.Method method) {
        return Method.getMethod((java.lang.reflect.Method)method);
    }

    private class AccessorMethodWriter
    extends BaseAdapter {
        private final String targetFieldName;
        private final String fieldRefName;
        private final boolean isSetter;

        private AccessorMethodWriter(java.lang.reflect.Method method, Accessor accessor) {
            super(method);
            this.targetFieldName = accessor.value();
            this.fieldRefName = "field$" + this.targetFieldName;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                if (method.getReturnType().equals(Void.TYPE)) {
                    throw new IllegalArgumentException(method + " should have a non-void return type");
                }
                if (method.getParameterCount() != 0) {
                    throw new IllegalArgumentException(method + " should take no parameters");
                }
                this.isSetter = false;
            } else if (methodName.startsWith("set")) {
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new IllegalArgumentException(method + " should have a void return type");
                }
                if (method.getParameterCount() != 1) {
                    throw new IllegalArgumentException(method + " should take a single parameter");
                }
                this.isSetter = true;
            } else {
                throw new IllegalArgumentException(methodName + " doesn't appear to be a setter or a getter");
            }
        }

        void write() {
            if (ReflectorClassWriter.this.fieldRefs.add(this.targetFieldName)) {
                ReflectorClassWriter.this.visitField(74, this.fieldRefName, FIELD_TYPE.getDescriptor(), null, null);
            }
            this.visitCode();
            if (this.isSetter) {
                this.loadFieldRef();
                this.loadTarget();
                this.loadArg(0);
                Class<?> parameterType = this.iMethod.getParameterTypes()[0];
                if (parameterType.isPrimitive()) {
                    this.box(Type.getType(parameterType));
                }
                this.invokeVirtual(FIELD_TYPE, FIELD$SET);
                this.returnValue();
            } else {
                this.loadFieldRef();
                this.loadTarget();
                this.invokeVirtual(FIELD_TYPE, FIELD$GET);
                this.castForReturn(this.iMethod.getReturnType());
                this.returnValue();
            }
            this.endMethod();
        }

        private void loadFieldRef() {
            this.getStatic(ReflectorClassWriter.this.reflectorType, this.fieldRefName, FIELD_TYPE);
            this.dup();
            Label haveMethodRef = this.newLabel();
            this.ifNonNull(haveMethodRef);
            this.pop();
            this.push(ReflectorClassWriter.this.targetType);
            this.push(this.targetFieldName);
            this.invokeVirtual(CLASS_TYPE, CLASS$GET_DECLARED_FIELD);
            this.dup();
            this.push(true);
            this.invokeVirtual(FIELD_TYPE, ACCESSIBLE_OBJECT$SET_ACCESSIBLE);
            this.dup();
            this.putStatic(ReflectorClassWriter.this.reflectorType, this.fieldRefName, FIELD_TYPE);
            this.mark(haveMethodRef);
        }
    }

    private class ConstructorMethodWriter
    extends BaseAdapter {
        private final String constructorRefName;
        private final Type[] targetParamTypes;

        private ConstructorMethodWriter(java.lang.reflect.Method method) {
            super(method);
            int myMethodNumber = ReflectorClassWriter.this.nextMethodNumber++;
            this.constructorRefName = "constructor" + myMethodNumber;
            this.targetParamTypes = this.resolveParamTypes(this.iMethod);
        }

        void write() {
            ReflectorClassWriter.this.visitField(74, this.constructorRefName, CONSTRUCTOR_TYPE.getDescriptor(), null, null);
            this.visitCode();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label handleInvocationTargetException = new Label();
            this.visitTryCatchBlock(tryStart, tryEnd, handleInvocationTargetException, INVOCATION_TARGET_EXCEPTION_TYPE.getInternalName());
            Label handleReflectiveOperationException = new Label();
            this.visitTryCatchBlock(tryStart, tryEnd, handleReflectiveOperationException, REFLECTIVE_OPERATION_EXCEPTION_TYPE.getInternalName());
            this.mark(tryStart);
            this.loadOriginalConstructorRef();
            this.loadArgArray();
            this.invokeVirtual(CONSTRUCTOR_TYPE, CONSTRUCTOR$NEWINSTANCE);
            this.mark(tryEnd);
            this.castForReturn(this.iMethod.getReturnType());
            this.returnValue();
            this.mark(handleInvocationTargetException);
            int exceptionLocalVar = this.newLocal(THROWABLE_TYPE);
            this.storeLocal(exceptionLocalVar);
            this.loadLocal(exceptionLocalVar);
            this.invokeVirtual(THROWABLE_TYPE, THROWABLE$GET_CAUSE);
            this.throwException();
            this.mark(handleReflectiveOperationException);
            exceptionLocalVar = this.newLocal(REFLECTIVE_OPERATION_EXCEPTION_TYPE);
            this.storeLocal(exceptionLocalVar);
            this.newInstance(STRINGBUILDER_TYPE);
            this.dup();
            this.invokeConstructor(STRINGBUILDER_TYPE, OBJECT_INIT);
            this.push("Error invoking reflector method in ClassLoader ");
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$APPEND);
            this.push(ReflectorClassWriter.this.targetType);
            this.invokeVirtual(CLASS_TYPE, CLASS$GET_CLASS_LOADER);
            this.invokeStatic(STRING_TYPE, STRING$VALUE_OF);
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$APPEND);
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$TO_STRING);
            int messageLocalVar = this.newLocal(STRING_TYPE);
            this.storeLocal(messageLocalVar);
            this.newInstance(ASSERTION_ERROR_TYPE);
            this.dup();
            this.loadLocal(messageLocalVar);
            this.loadLocal(exceptionLocalVar);
            this.invokeConstructor(ASSERTION_ERROR_TYPE, ASSERTION_ERROR_INIT);
            this.throwException();
            this.endMethod();
        }

        private void loadOriginalConstructorRef() {
            this.getStatic(ReflectorClassWriter.this.reflectorType, this.constructorRefName, CONSTRUCTOR_TYPE);
            this.dup();
            Label haveConstructorRef = this.newLabel();
            this.ifNonNull(haveConstructorRef);
            this.pop();
            this.push(ReflectorClassWriter.this.targetType);
            Type[] paramTypes = this.targetParamTypes;
            this.push(paramTypes.length);
            this.newArray(CLASS_TYPE);
            for (int i = 0; i < paramTypes.length; ++i) {
                this.dup();
                this.push(i);
                this.push(paramTypes[i]);
                this.arrayStore(CLASS_TYPE);
            }
            this.invokeVirtual(CLASS_TYPE, CLASS$GET_DECLARED_CONSTRUCTOR);
            this.dup();
            this.push(true);
            this.invokeVirtual(CONSTRUCTOR_TYPE, ACCESSIBLE_OBJECT$SET_ACCESSIBLE);
            this.dup();
            this.putStatic(ReflectorClassWriter.this.reflectorType, this.constructorRefName, CONSTRUCTOR_TYPE);
            this.mark(haveConstructorRef);
        }
    }

    private class ReflectorMethodWriter
    extends BaseAdapter {
        private final String methodRefName;
        private final Type[] targetParamTypes;

        private ReflectorMethodWriter(java.lang.reflect.Method method) {
            super(method);
            int myMethodNumber = ReflectorClassWriter.this.nextMethodNumber++;
            this.methodRefName = "method" + myMethodNumber;
            this.targetParamTypes = this.resolveParamTypes(this.iMethod);
        }

        void write() {
            ReflectorClassWriter.this.visitField(74, this.methodRefName, METHOD_TYPE.getDescriptor(), null, null);
            this.visitCode();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label handleInvocationTargetException = new Label();
            this.visitTryCatchBlock(tryStart, tryEnd, handleInvocationTargetException, INVOCATION_TARGET_EXCEPTION_TYPE.getInternalName());
            Label handleReflectiveOperationException = new Label();
            this.visitTryCatchBlock(tryStart, tryEnd, handleReflectiveOperationException, REFLECTIVE_OPERATION_EXCEPTION_TYPE.getInternalName());
            this.mark(tryStart);
            this.loadOriginalMethodRef();
            this.loadTarget();
            this.loadArgArray();
            this.invokeVirtual(METHOD_TYPE, METHOD$INVOKE);
            this.mark(tryEnd);
            this.castForReturn(this.iMethod.getReturnType());
            this.returnValue();
            this.mark(handleInvocationTargetException);
            int exceptionLocalVar = this.newLocal(THROWABLE_TYPE);
            this.storeLocal(exceptionLocalVar);
            this.loadLocal(exceptionLocalVar);
            this.invokeVirtual(THROWABLE_TYPE, THROWABLE$GET_CAUSE);
            this.throwException();
            this.mark(handleReflectiveOperationException);
            exceptionLocalVar = this.newLocal(REFLECTIVE_OPERATION_EXCEPTION_TYPE);
            this.storeLocal(exceptionLocalVar);
            this.newInstance(STRINGBUILDER_TYPE);
            this.dup();
            this.invokeConstructor(STRINGBUILDER_TYPE, OBJECT_INIT);
            this.push("Error invoking reflector method in ClassLoader ");
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$APPEND);
            this.push(ReflectorClassWriter.this.targetType);
            this.invokeVirtual(CLASS_TYPE, CLASS$GET_CLASS_LOADER);
            this.invokeStatic(STRING_TYPE, STRING$VALUE_OF);
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$APPEND);
            this.invokeVirtual(STRINGBUILDER_TYPE, STRINGBUILDER$TO_STRING);
            int messageLocalVar = this.newLocal(STRING_TYPE);
            this.storeLocal(messageLocalVar);
            this.newInstance(ASSERTION_ERROR_TYPE);
            this.dup();
            this.loadLocal(messageLocalVar);
            this.loadLocal(exceptionLocalVar);
            this.invokeConstructor(ASSERTION_ERROR_TYPE, ASSERTION_ERROR_INIT);
            this.throwException();
            this.endMethod();
        }

        private void loadOriginalMethodRef() {
            this.getStatic(ReflectorClassWriter.this.reflectorType, this.methodRefName, METHOD_TYPE);
            this.dup();
            Label haveMethodRef = this.newLabel();
            this.ifNonNull(haveMethodRef);
            this.pop();
            this.push(ReflectorClassWriter.this.targetType);
            this.push(this.getMethodName());
            Type[] paramTypes = this.targetParamTypes;
            this.push(paramTypes.length);
            this.newArray(CLASS_TYPE);
            for (int i = 0; i < paramTypes.length; ++i) {
                this.dup();
                this.push(i);
                this.push(paramTypes[i]);
                this.arrayStore(CLASS_TYPE);
            }
            this.invokeVirtual(CLASS_TYPE, CLASS$GET_DECLARED_METHOD);
            this.dup();
            this.push(true);
            this.invokeVirtual(METHOD_TYPE, ACCESSIBLE_OBJECT$SET_ACCESSIBLE);
            this.dup();
            this.putStatic(ReflectorClassWriter.this.reflectorType, this.methodRefName, METHOD_TYPE);
            this.mark(haveMethodRef);
        }
    }

    private class BaseAdapter
    extends GeneratorAdapter {
        final java.lang.reflect.Method iMethod;

        BaseAdapter(java.lang.reflect.Method method) {
            this(Method.getMethod((java.lang.reflect.Method)method), method);
        }

        private BaseAdapter(Method asmMethod, java.lang.reflect.Method method) {
            this(method, asmMethod, reflectorClassWriter.visitMethod(1, asmMethod.getName(), asmMethod.getDescriptor(), null, ReflectorClassWriter.getInternalNames(method.getExceptionTypes())));
        }

        private BaseAdapter(java.lang.reflect.Method method, Method asmMethod, MethodVisitor methodVisitor) {
            super(393216, methodVisitor, 1, asmMethod.getName(), asmMethod.getDescriptor());
            this.iMethod = method;
        }

        void loadTarget() {
            if (this.isAnnotatedStatic()) {
                this.loadNull();
            } else {
                this.loadThis();
                this.getField(ReflectorClassWriter.this.reflectorType, ReflectorClassWriter.TARGET_FIELD, ReflectorClassWriter.this.targetType);
            }
        }

        void castForReturn(Class<?> returnType) {
            if (returnType.isPrimitive()) {
                this.unbox(Type.getType(returnType));
            } else {
                this.checkCast(Type.getType(returnType));
            }
        }

        String getMethodName() {
            String methodName = this.iMethod.getName();
            if (this.iMethod.isAnnotationPresent(Direct.class) || ReflectorClassWriter.this.directModifier) {
                methodName = "$$robo$$" + ReflectorClassWriter.this.targetType.getClassName().replace('.', '_').replace('$', '_') + "$" + methodName;
            }
            return methodName;
        }

        boolean isAnnotatedStatic() {
            return this.iMethod.isAnnotationPresent(Static.class);
        }

        void loadNull() {
            this.visitInsn(1);
        }

        protected Type[] resolveParamTypes(java.lang.reflect.Method iMethod) {
            Class<?>[] iParamTypes = iMethod.getParameterTypes();
            Annotation[][] paramAnnotations = iMethod.getParameterAnnotations();
            Type[] targetParamTypes = new Type[iParamTypes.length];
            for (int i = 0; i < iParamTypes.length; ++i) {
                Class<?> paramType = this.findWithType(paramAnnotations[i]);
                if (paramType == null) {
                    paramType = iParamTypes[i];
                }
                targetParamTypes[i] = Type.getType(paramType);
            }
            return targetParamTypes;
        }

        @Nullable
        private Class<?> findWithType(Annotation[] paramAnnotation) {
            for (Annotation annotation : paramAnnotation) {
                if (!(annotation instanceof WithType)) continue;
                String withTypeName = ((WithType)annotation).value();
                try {
                    return Class.forName(withTypeName, true, ReflectorClassWriter.this.iClass.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

