/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.Typeface;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.text.method.TransformationMethod;
import android.view.KeyEvent;
import android.widget.TextView;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowView;

@Implements(value=TextView.class)
public class ShadowTextView
extends ShadowView {
    @RealObject
    TextView realTextView;
    private CharSequence text = "";
    private TextView.BufferType bufferType = TextView.BufferType.NORMAL;
    private Integer textColorHexValue;
    private Integer hintColorHexValue;
    private float textSize = 14.0f;
    private boolean autoLinkPhoneNumbers;
    private int autoLinkMask;
    private CharSequence hintText;
    private CharSequence errorText;
    private int compoundDrawablePadding;
    private MovementMethod movementMethod;
    private boolean linksClickable;
    private int gravity;
    private int imeOptions = 0;
    private TextView.OnEditorActionListener onEditorActionListener;
    private int textAppearanceId;
    private TransformationMethod transformationMethod;
    private int inputType;
    private int lines;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;
    private Typeface typeface;
    private InputFilter[] inputFilters;
    private TextPaint textPaint = new TextPaint();
    private List<TextWatcher> watchers = new ArrayList<TextWatcher>();
    private List<Integer> previousKeyCodes = new ArrayList<Integer>();
    private List<KeyEvent> previousKeyEvents = new ArrayList<KeyEvent>();
    private int paintFlags;
    private int compoundDrawablesWithIntrinsicBoundsLeft;
    private int compoundDrawablesWithIntrinsicBoundsTop;
    private int compoundDrawablesWithIntrinsicBoundsRight;
    private int compoundDrawablesWithIntrinsicBoundsBottom;

    @Implementation
    protected void setTextAppearance(Context context, int resid) {
        this.textAppearanceId = resid;
        ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).setTextAppearance(context, resid);
    }

    @Implementation
    protected boolean onKeyDown(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        return ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).onKeyDown(keyCode, event);
    }

    @Implementation
    protected boolean onKeyUp(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        return ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).onKeyUp(keyCode, event);
    }

    public int getPreviousKeyCode(int index) {
        return this.previousKeyCodes.get(index);
    }

    public KeyEvent getPreviousKeyEvent(int index) {
        return this.previousKeyEvents.get(index);
    }

    @Override
    public String innerText() {
        CharSequence text = this.realTextView.getText();
        return text == null || this.realTextView.getVisibility() != 0 ? "" : text.toString();
    }

    public int getTextAppearanceId() {
        return this.textAppearanceId;
    }

    @Implementation
    protected void addTextChangedListener(TextWatcher watcher) {
        this.watchers.add(watcher);
        ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).addTextChangedListener(watcher);
    }

    @Implementation
    protected void removeTextChangedListener(TextWatcher watcher) {
        this.watchers.remove(watcher);
        ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).removeTextChangedListener(watcher);
    }

    public List<TextWatcher> getWatchers() {
        return this.watchers;
    }

    @HiddenApi
    @Implementation
    public Locale getTextServicesLocale() {
        return Locale.getDefault();
    }

    @Override
    protected void dumpAttributes(PrintStream out) {
        super.dumpAttributes(out);
        CharSequence text = this.realTextView.getText();
        if (text != null && text.length() > 0) {
            this.dumpAttribute(out, "text", text.toString());
        }
    }

    @Implementation
    protected int getPaintFlags() {
        return this.paintFlags;
    }

    @Implementation
    protected void setPaintFlags(int paintFlags) {
        this.paintFlags = paintFlags;
    }

    @Implementation
    protected void setOnEditorActionListener(TextView.OnEditorActionListener l) {
        this.onEditorActionListener = l;
        ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).setOnEditorActionListener(l);
    }

    public TextView.OnEditorActionListener getOnEditorActionListener() {
        return this.onEditorActionListener;
    }

    @Implementation
    protected void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        this.compoundDrawablesWithIntrinsicBoundsLeft = left;
        this.compoundDrawablesWithIntrinsicBoundsTop = top;
        this.compoundDrawablesWithIntrinsicBoundsRight = right;
        this.compoundDrawablesWithIntrinsicBoundsBottom = bottom;
        ((TextView)Shadow.directlyOn((Object)this.realTextView, TextView.class)).setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public int getCompoundDrawablesWithIntrinsicBoundsLeft() {
        return this.compoundDrawablesWithIntrinsicBoundsLeft;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsTop() {
        return this.compoundDrawablesWithIntrinsicBoundsTop;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsRight() {
        return this.compoundDrawablesWithIntrinsicBoundsRight;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsBottom() {
        return this.compoundDrawablesWithIntrinsicBoundsBottom;
    }
}

