/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.Log;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.RoundRectangle;
import org.robolectric.shadows.ShadowMatrix;

@Implements(value=Path.class)
public class ShadowPath {
    private static final String TAG = ShadowPath.class.getSimpleName();
    private static final float EPSILON = 1.0E-4f;
    @RealObject
    private Path realObject;
    private List<Point> points = new ArrayList<Point>();
    private Point wasMovedTo;
    private float mLastX = 0.0f;
    private float mLastY = 0.0f;
    private Path2D mPath = new Path2D.Double();
    private boolean mCachedIsEmpty = true;
    private Path.FillType mFillType = Path.FillType.WINDING;
    protected boolean isSimplePath;

    @Implementation
    protected void __constructor__(Path path) {
        ShadowPath shadowPath = (ShadowPath)Shadow.extract((Object)path);
        this.points = new ArrayList<Point>(shadowPath.getPoints());
    }

    Path2D getJavaShape() {
        return this.mPath;
    }

    @Implementation
    protected void moveTo(float x, float y) {
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.moveTo(this.mLastX, this.mLastY);
        Point p = new Point(x, y, Point.Type.MOVE_TO);
        this.points.add(p);
    }

    @Implementation
    protected void lineTo(float x, float y) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = x;
        this.mLastY = y;
        this.mPath.lineTo(this.mLastX, this.mLastY);
        Point point = new Point(x, y, Point.Type.LINE_TO);
        this.points.add(point);
    }

    @Implementation
    protected void quadTo(float x1, float y1, float x2, float y2) {
        this.isSimplePath = false;
        if (!this.hasPoints()) {
            this.moveTo(0.0f, 0.0f);
        }
        this.mLastX = x2;
        this.mLastY = y2;
        this.mPath.quadTo(x1, y1, this.mLastX, this.mLastY);
    }

    @Implementation
    protected void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (!this.hasPoints()) {
            this.mPath.moveTo(0.0, 0.0);
        }
        this.mLastX = x3;
        this.mLastY = y3;
        this.mPath.curveTo(x1, y1, x2, y2, this.mLastX, this.mLastY);
    }

    private boolean hasPoints() {
        return !this.mPath.getPathIterator(null).isDone();
    }

    @Implementation
    protected void reset() {
        this.mPath.reset();
        this.mLastX = 0.0f;
        this.mLastY = 0.0f;
        this.points.clear();
    }

    @Implementation(minSdk=21)
    protected float[] approximate(float acceptableError) {
        PathIterator iterator = this.mPath.getPathIterator(null, acceptableError);
        float[] segment = new float[6];
        float totalLength = 0.0f;
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        Point2D.Float previousPoint = null;
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(segment);
            Point2D.Float currentPoint = new Point2D.Float(segment[0], segment[1]);
            if (previousPoint != null && type != 0) {
                totalLength += (float)currentPoint.distance(previousPoint);
            }
            previousPoint = currentPoint;
            points.add(currentPoint);
            iterator.next();
        }
        int nPoints = points.size();
        float[] result = new float[nPoints * 3];
        previousPoint = null;
        float walkedDistance = 0.0f;
        for (int i = 0; i < nPoints; ++i) {
            Point2D.Float point = (Point2D.Float)points.get(i);
            float distance = previousPoint != null ? (float)previousPoint.distance(point) : 0.0f;
            result[i * 3] = (walkedDistance += distance) / totalLength;
            result[i * 3 + 1] = point.x;
            result[i * 3 + 2] = point.y;
            previousPoint = point;
        }
        return result;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    @Implementation
    protected void rewind() {
        this.reset();
    }

    @Implementation
    protected void set(Path src) {
        this.mPath.reset();
        ShadowPath shadowSrc = (ShadowPath)Shadow.extract((Object)src);
        this.setFillType(shadowSrc.mFillType);
        this.mPath.append(shadowSrc.mPath, false);
    }

    @Implementation(minSdk=19)
    protected boolean op(Path path1, Path path2, Path.Op op) {
        Log.w((String)TAG, (String)"android.graphics.Path#op() not supported yet.");
        return false;
    }

    @Implementation(minSdk=21)
    protected boolean isConvex() {
        Log.w((String)TAG, (String)"android.graphics.Path#isConvex() not supported yet.");
        return true;
    }

    @Implementation
    protected Path.FillType getFillType() {
        return this.mFillType;
    }

    @Implementation
    protected void setFillType(Path.FillType fillType) {
        this.mFillType = fillType;
        this.mPath.setWindingRule(ShadowPath.getWindingRule(fillType));
    }

    private static int getWindingRule(Path.FillType type) {
        switch (type) {
            case WINDING: 
            case INVERSE_WINDING: {
                return 1;
            }
            case EVEN_ODD: 
            case INVERSE_EVEN_ODD: {
                return 0;
            }
        }
        assert (false);
        return 1;
    }

    @Implementation
    protected boolean isInverseFillType() {
        throw new UnsupportedOperationException("isInverseFillType");
    }

    @Implementation
    protected void toggleInverseFillType() {
        throw new UnsupportedOperationException("toggleInverseFillType");
    }

    @Implementation
    protected boolean isEmpty() {
        if (!this.mCachedIsEmpty) {
            return false;
        }
        float[] coords = new float[6];
        this.mCachedIsEmpty = Boolean.TRUE;
        PathIterator it = this.mPath.getPathIterator(null);
        if (!it.isDone()) {
            int type = it.currentSegment(coords);
            this.mCachedIsEmpty = false;
            return false;
        }
        return true;
    }

    @Implementation
    protected boolean isRect(RectF rect) {
        Area area = new Area(this.mPath);
        if (area.isRectangular()) {
            if (rect != null) {
                this.fillBounds(rect);
            }
            return true;
        }
        return false;
    }

    @Implementation
    protected void computeBounds(RectF bounds, boolean exact) {
        this.fillBounds(bounds);
    }

    @Implementation
    protected void incReserve(int extraPtCount) {
        throw new UnsupportedOperationException("incReserve");
    }

    @Implementation
    protected void rMoveTo(float dx, float dy) {
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.moveTo(this.mLastX, this.mLastY);
    }

    @Implementation
    protected void rLineTo(float dx, float dy) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        if (Math.abs(dx) < 1.0E-4f && Math.abs(dy) < 1.0E-4f) {
            return;
        }
        this.mLastX = dx += this.mLastX;
        this.mLastY = dy += this.mLastY;
        this.mPath.lineTo(this.mLastX, this.mLastY);
    }

    @Implementation
    protected void rQuadTo(float dx1, float dy1, float dx2, float dy2) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = dx2 += this.mLastX;
        this.mLastY = dy2 += this.mLastY;
        this.mPath.quadTo(dx1 += this.mLastX, dy1 += this.mLastY, this.mLastX, this.mLastY);
    }

    @Implementation
    protected void rCubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mLastX = x3 += this.mLastX;
        this.mLastY = y3 += this.mLastY;
        this.mPath.curveTo(x1 += this.mLastX, y1 += this.mLastY, x2 += this.mLastX, y2 += this.mLastY, this.mLastX, this.mLastY);
    }

    @Implementation
    protected void arcTo(RectF oval, float startAngle, float sweepAngle) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, false);
    }

    @Implementation
    protected void arcTo(RectF oval, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.arcTo(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, forceMoveTo);
    }

    @Implementation(minSdk=21)
    protected void arcTo(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean forceMoveTo) {
        this.isSimplePath = false;
        Arc2D.Float arc = new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0);
        this.mPath.append(arc, true);
        this.resetLastPointFromPath();
    }

    @Implementation
    protected void close() {
        if (!this.hasPoints()) {
            this.mLastX = 0.0f;
            this.mLastY = 0.0f;
            this.mPath.moveTo(0.0f, 0.0f);
        }
        this.mPath.closePath();
    }

    @Implementation
    protected void addRect(RectF rect, Path.Direction dir) {
        this.addRect(rect.left, rect.top, rect.right, rect.bottom, dir);
    }

    @Implementation
    protected void addRect(float left, float top, float right, float bottom, Path.Direction dir) {
        this.moveTo(left, top);
        switch (dir) {
            case CW: {
                this.lineTo(right, top);
                this.lineTo(right, bottom);
                this.lineTo(left, bottom);
                break;
            }
            case CCW: {
                this.lineTo(left, bottom);
                this.lineTo(right, bottom);
                this.lineTo(right, top);
            }
        }
        this.close();
        this.resetLastPointFromPath();
    }

    @Implementation(minSdk=21)
    protected void addOval(float left, float top, float right, float bottom, Path.Direction dir) {
        this.mPath.append(new Ellipse2D.Float(left, top, right - left, bottom - top), false);
    }

    @Implementation
    protected void addCircle(float x, float y, float radius, Path.Direction dir) {
        this.mPath.append(new Ellipse2D.Float(x - radius, y - radius, radius * 2.0f, radius * 2.0f), false);
    }

    @Implementation(minSdk=21)
    protected void addArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.mPath.append(new Arc2D.Float(left, top, right - left, bottom - top, -startAngle, -sweepAngle, 0), false);
    }

    @Implementation(minSdk=16)
    protected void addRoundRect(RectF rect, float rx, float ry, Path.Direction dir) {
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, dir);
    }

    @Implementation(minSdk=16)
    protected void addRoundRect(RectF rect, float[] radii, Path.Direction dir) {
        if (rect == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rect.left, rect.top, rect.right, rect.bottom, radii, dir);
    }

    @Implementation(minSdk=21)
    protected void addRoundRect(float left, float top, float right, float bottom, float rx, float ry, Path.Direction dir) {
        this.mPath.append(new RoundRectangle2D.Float(left, top, right - left, bottom - top, rx * 2.0f, ry * 2.0f), false);
    }

    @Implementation(minSdk=21)
    protected void addRoundRect(float left, float top, float right, float bottom, float[] radii, Path.Direction dir) {
        if (radii.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        float[] cornerDimensions = new float[radii.length];
        for (int i = 0; i < radii.length; ++i) {
            cornerDimensions[i] = 2.0f * radii[i];
        }
        this.mPath.append(new RoundRectangle(left, top, right - left, bottom - top, cornerDimensions), false);
    }

    @Implementation
    protected void addPath(Path src, float dx, float dy) {
        this.isSimplePath = false;
        ShadowPath.addPath(this.realObject, src, AffineTransform.getTranslateInstance(dx, dy));
    }

    @Implementation
    protected void addPath(Path src) {
        this.isSimplePath = false;
        ShadowPath.addPath(this.realObject, src, null);
    }

    @Implementation
    protected void addPath(Path src, Matrix matrix) {
        if (matrix == null) {
            return;
        }
        ShadowPath shadowSrc = (ShadowPath)Shadow.extract((Object)src);
        if (!shadowSrc.isSimplePath) {
            this.isSimplePath = false;
        }
        ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        ShadowPath.addPath(this.realObject, src, shadowMatrix.getAffineTransform());
    }

    private static void addPath(Path destPath, Path srcPath, AffineTransform transform) {
        if (destPath == null) {
            return;
        }
        if (srcPath == null) {
            return;
        }
        ShadowPath shadowDestPath = (ShadowPath)Shadow.extract((Object)destPath);
        ShadowPath shadowSrcPath = (ShadowPath)Shadow.extract((Object)srcPath);
        if (transform != null) {
            shadowDestPath.mPath.append(shadowSrcPath.mPath.getPathIterator(transform), false);
        } else {
            shadowDestPath.mPath.append(shadowSrcPath.mPath, false);
        }
    }

    @Implementation
    protected void offset(float dx, float dy, Path dst) {
        if (dst != null) {
            dst.set(this.realObject);
        } else {
            dst = this.realObject;
        }
        dst.offset(dx, dy);
    }

    @Implementation
    protected void offset(float dx, float dy) {
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(new AffineTransform(0.0f, 0.0f, dx, 0.0f, 0.0f, dy));
        newPath.append(iterator, false);
        this.mPath = newPath;
    }

    @Implementation
    protected void setLastPoint(float dx, float dy) {
        this.mLastX = dx;
        this.mLastY = dy;
    }

    @Implementation
    protected void transform(Matrix matrix, Path dst) {
        ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
        if (shadowMatrix.hasPerspective()) {
            Log.w((String)TAG, (String)"android.graphics.Path#transform() only supports affine transformations.");
        }
        GeneralPath newPath = new GeneralPath();
        PathIterator iterator = this.mPath.getPathIterator(shadowMatrix.getAffineTransform());
        newPath.append(iterator, false);
        if (dst != null) {
            ShadowPath shadowPath = (ShadowPath)Shadow.extract((Object)dst);
            shadowPath.mPath = newPath;
        } else {
            this.mPath = newPath;
        }
    }

    @Implementation
    protected void transform(Matrix matrix) {
        this.transform(matrix, null);
    }

    public void fillBounds(RectF bounds) {
        Rectangle2D rect = this.mPath.getBounds2D();
        bounds.left = (float)rect.getMinX();
        bounds.right = (float)rect.getMaxX();
        bounds.top = (float)rect.getMinY();
        bounds.bottom = (float)rect.getMaxY();
    }

    private void resetLastPointFromPath() {
        Point2D last = this.mPath.getCurrentPoint();
        this.mLastX = (float)last.getX();
        this.mLastY = (float)last.getY();
    }

    public static class Point {
        private final float x;
        private final float y;
        private final Type type;

        public Point(float x, float y, Type type) {
            this.x = x;
            this.y = y;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point point = (Point)o;
            if (Float.compare(point.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(point.y, this.y) != 0) {
                return false;
            }
            return this.type == point.type;
        }

        public int hashCode() {
            int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Point(" + this.x + "," + this.y + "," + (Object)((Object)this.type) + ")";
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            MOVE_TO,
            LINE_TO;

        }
    }
}

