/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputEvent;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.MotionEvent;
import android.view.RemoteAnimationTarget;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowRelayoutResult;
import android.window.ActivityWindowInfo;
import android.window.BackMotionEvent;
import android.window.ClientWindowFrames;
import android.window.OnBackInvokedCallbackInfo;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowInsetsState;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowSurfaceControl;
import org.robolectric.shadows.ShadowUiAutomation;
import org.robolectric.shadows.ShadowView;
import org.robolectric.shadows.SystemUi;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=WindowManagerGlobal.class, isInAndroidSdk=false)
public class ShadowWindowManagerGlobal {
    private static WindowSessionDelegate windowSessionDelegate = new WindowSessionDelegate();
    private static IWindowSession windowSession;

    @Resetter
    public static void reset() {
        ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setDefaultWindowManager(null);
        windowSessionDelegate = new WindowSessionDelegate();
        windowSession = null;
    }

    public static boolean getInTouchMode() {
        return windowSessionDelegate.getInTouchMode();
    }

    static void setInTouchMode(boolean inTouchMode) {
        windowSessionDelegate.setInTouchMode(inTouchMode);
    }

    static void notifyResize(IWindow window) {
        windowSessionDelegate.sendResize(window);
    }

    @Nullable
    public static ClipData getLastDragClipData() {
        return ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData;
    }

    public static void clearLastDragClipData() {
        ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData = null;
    }

    @Nullable
    public static PredictiveBackGesture startPredictiveBackGesture(int edge) {
        return ShadowWindowManagerGlobal.startPredictiveBackGesture(edge, 0.5f);
    }

    @Nullable
    public static PredictiveBackGesture startPredictiveBackGesture(int edge, float position) {
        Preconditions.checkArgument((position >= 0.0f && position <= 1.0f ? 1 : 0) != 0, (String)"Invalid position: %s.", (Object)Float.valueOf(position));
        Preconditions.checkState((windowSessionDelegate.currentPredictiveBackGesture == null ? 1 : 0) != 0, (Object)"Current predictive back gesture in progress.");
        if (windowSessionDelegate.onBackInvokedCallbackInfo == null || !windowSessionDelegate.onBackInvokedCallbackInfo.isAnimationCallback()) {
            return null;
        }
        try {
            ShadowLooper.idleMainLooper();
            int touchSlop = ViewConfiguration.get((Context)RuntimeEnvironment.getApplication()).getScaledTouchSlop();
            int displayWidth = ShadowDisplay.getDefaultDisplay().getWidth();
            float deltaX = (float)((edge == 0 ? 1 : -1) * touchSlop) / 2.0f;
            float downX = (float)(edge == 0 ? 0 : displayWidth) + deltaX;
            float downY = (float)ShadowDisplay.getDefaultDisplay().getHeight() * position;
            if (windowSessionDelegate.systemGestureExclusionRects != null) {
                for (Rect rect : windowSessionDelegate.systemGestureExclusionRects) {
                    if (!rect.contains(Math.round(downX), Math.round(downY))) continue;
                    return null;
                }
            }
            MotionEvent downEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)downX, (float)downY, (int)0);
            MotionEvent moveEvent = MotionEvent.obtain((MotionEvent)downEvent);
            moveEvent.setAction(2);
            moveEvent.offsetLocation(deltaX, 0.0f);
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)moveEvent);
            cancelEvent.setAction(3);
            ShadowUiAutomation.injectInputEvent((InputEvent)downEvent);
            ShadowUiAutomation.injectInputEvent((InputEvent)moveEvent);
            ShadowUiAutomation.injectInputEvent((InputEvent)cancelEvent);
            windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackStarted(BackMotionEvents.newBackMotionEvent(edge, downX + 2.0f * deltaX, downY, 0.0f));
            ShadowLooper.idleMainLooper();
            PredictiveBackGesture backGesture = new PredictiveBackGesture(edge, displayWidth, downX + 2.0f * deltaX, downY);
            windowSessionDelegate.currentPredictiveBackGesture = backGesture;
            return backGesture;
        }
        catch (RemoteException e) {
            Log.e((String)"ShadowWindowManagerGlobal", (String)"Failed to start back gesture", (Throwable)e);
            return null;
        }
    }

    @Implementation
    protected static synchronized IWindowSession getWindowSession() {
        if (windowSession == null) {
            windowSession = (IWindowSession)Proxy.newProxyInstance(IWindowSession.class.getClassLoader(), new Class[]{IWindowSession.class}, (proxy, method, args) -> {
                String methodName;
                switch (methodName = method.getName()) {
                    case "add": 
                    case "addToDisplay": 
                    case "addToDisplayAsUser": {
                        return windowSessionDelegate.addToDisplay(args);
                    }
                    case "remove": {
                        windowSessionDelegate.remove(args);
                        return null;
                    }
                    case "relayout": {
                        return windowSessionDelegate.relayout(args);
                    }
                    case "getInTouchMode": {
                        return windowSessionDelegate.getInTouchMode();
                    }
                    case "performDrag": {
                        return windowSessionDelegate.performDrag(args);
                    }
                    case "prepareDrag": {
                        return windowSessionDelegate.prepareDrag();
                    }
                    case "setInTouchMode": {
                        windowSessionDelegate.setInTouchMode((Boolean)args[0]);
                        return null;
                    }
                    case "setOnBackInvokedCallbackInfo": {
                        windowSessionDelegate.onBackInvokedCallbackInfo = (OnBackInvokedCallbackInfo)args[1];
                        return null;
                    }
                    case "reportSystemGestureExclusionChanged": {
                        windowSessionDelegate.systemGestureExclusionRects = (List)args[1];
                        return null;
                    }
                    case "insetsModified": 
                    case "updateRequestedVisibilities": 
                    case "updateRequestedVisibleTypes": {
                        windowSessionDelegate.updateInsets(args);
                        return null;
                    }
                }
                return ReflectionHelpers.defaultValueForType((String)method.getReturnType().getName());
            });
        }
        return windowSession;
    }

    @Implementation
    protected static synchronized IWindowSession peekWindowSession() {
        return windowSession;
    }

    @Implementation
    public static @ClassName(value="android.view.IWindowManager") Object getWindowManagerService() throws RemoteException {
        IWindowManager service = ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).getWindowManagerService();
        if (service == null) {
            service = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
            ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setWindowManagerService(service);
        }
        return service;
    }

    private static <T> T findFirst(Class<T> type, Object[] args) {
        return type.cast(Arrays.stream(args).filter(type::isInstance).findFirst().get());
    }

    private static <T> Optional<T> findFirstOpt(Class<T> type, Object[] args) {
        return Optional.ofNullable(type.cast(Arrays.stream(args).filter(type::isInstance).findFirst().orElse(null)));
    }

    private static <T> T[] findAll(Class<T> type, Object[] args) {
        return Arrays.stream(args).filter(type::isInstance).toArray(len -> (Object[])Array.newInstance(type, len));
    }

    private static class WindowSessionDelegate {
        private final LinkedHashMap<IWindow, WindowInfo> windows = new LinkedHashMap();
        static final int ADD_FLAG_IN_TOUCH_MODE = 1;
        static final int ADD_FLAG_APP_VISIBLE = 2;
        static final int RELAYOUT_RES_IN_TOUCH_MODE = 1;
        private boolean inTouchMode = ShadowView.useRealGraphics();
        @Nullable
        protected ClipData lastDragClipData;
        @Nullable
        private OnBackInvokedCallbackInfo onBackInvokedCallbackInfo;
        @Nullable
        private List<Rect> systemGestureExclusionRects;
        @Nullable
        private PredictiveBackGesture currentPredictiveBackGesture;

        private WindowSessionDelegate() {
        }

        protected int addToDisplay(Object[] args) {
            int sdk = RuntimeEnvironment.getApiLevel();
            WindowInfo windowInfo = this.windows.computeIfAbsent((IWindow)args[0], id -> new WindowInfo());
            int displayId = (Integer)args[sdk <= 30 ? 4 : 3];
            if (sdk >= 30) {
                this.applyInsets(displayId, windowInfo.requestedVisibleTypes);
            }
            windowInfo.displayId = displayId;
            if (sdk >= 30 && sdk < 34) {
                this.populateInsetSourceControls(windowInfo, (InsetsSourceControl[])ShadowWindowManagerGlobal.findFirst(InsetsSourceControl[].class, args));
                windowInfo.hasInsetsControl = true;
                this.transferWindowInsetsControlTo(windowInfo);
            }
            Rect[] rects = (Rect[])ShadowWindowManagerGlobal.findAll(Rect.class, args);
            int rectIdx = 0;
            if (sdk <= 30) {
                this.configureWindowFrames(windowInfo, (WindowManager.LayoutParams)args[2], null, sdk >= 28 && rects.length > rectIdx ? rects[rectIdx++] : null, rects[rectIdx++], null, rects[rectIdx], sdk >= 29 ? (InsetsState)ShadowWindowManagerGlobal.findFirst(InsetsState.class, args) : null);
            } else {
                Optional layout = sdk >= 35 ? ShadowWindowManagerGlobal.findFirstOpt(WindowRelayoutResult.class, args) : Optional.empty();
                this.configureWindowFrames(windowInfo, (WindowManager.LayoutParams)args[1], null, null, null, null, null, layout.isPresent() ? ((WindowRelayoutResult)layout.get()).insetsState : (InsetsState)ShadowWindowManagerGlobal.findFirst(InsetsState.class, args));
                if (rects.length > 0) {
                    rects[0].set(0, 0, -1, -1);
                }
            }
            int res = 0;
            if (ShadowView.useRealGraphics() || "true".equals(System.getProperty("robolectric.areWindowsMarkedVisible", "false"))) {
                res |= 2;
            }
            return res |= this.inTouchMode ? 1 : 0;
        }

        protected void remove(Object[] args) {
            IWindow window = (IWindow)args[0];
            this.windows.remove(window);
            this.transferWindowInsetsControlTo(this.windows.values().stream().reduce((a, b) -> b).orElse(null));
        }

        protected int relayout(Object[] args) {
            IWindow window;
            WindowInfo windowInfo;
            WindowRelayoutResult windowLayoutResult;
            int sdk = RuntimeEnvironment.getApiLevel();
            WindowRelayoutResult windowRelayoutResult = windowLayoutResult = sdk >= 35 ? (WindowRelayoutResult)ShadowWindowManagerGlobal.findFirst(WindowRelayoutResult.class, args) : null;
            if (sdk >= 29) {
                SurfaceControl surfaceControl = sdk >= 35 && ReflectionHelpers.hasField(WindowRelayoutResult.class, (String)"surfaceControl") ? (SurfaceControl)ReflectionHelpers.getField((Object)windowLayoutResult, (String)"surfaceControl") : (SurfaceControl)ShadowWindowManagerGlobal.findFirst(SurfaceControl.class, args);
                ((ShadowSurfaceControl)Shadow.extract((Object)surfaceControl)).initializeNativeObject();
            }
            if ((windowInfo = this.windows.get(window = (IWindow)args[0])) != null) {
                if (sdk >= 30 && sdk < 34) {
                    Object[] controls = (InsetsSourceControl[])ShadowWindowManagerGlobal.findFirst(InsetsSourceControl[].class, args);
                    if (windowInfo.hasInsetsControl) {
                        this.populateInsetSourceControls(windowInfo, (InsetsSourceControl[])controls);
                    } else {
                        Arrays.fill(controls, null);
                    }
                }
                Rect[] rects = (Rect[])ShadowWindowManagerGlobal.findAll(Rect.class, args);
                int requestedSizeIdx = sdk < 31 ? 3 : 2;
                this.configureWindowFrames(Objects.requireNonNull(windowInfo), (WindowManager.LayoutParams)args[sdk <= 30 ? 2 : 1], new Point(((Integer)args[requestedSizeIdx]).intValue(), ((Integer)args[requestedSizeIdx + 1]).intValue()), rects.length > 0 ? rects[0] : (windowLayoutResult != null ? windowLayoutResult.frames : (ClientWindowFrames)ShadowWindowManagerGlobal.findFirst(ClientWindowFrames.class, (Object[])args)).frame, sdk <= 30 ? rects[2] : null, sdk <= 30 ? rects[3] : null, sdk <= 30 ? rects[4] : null, sdk >= 29 ? (windowLayoutResult != null ? windowLayoutResult.insetsState : (InsetsState)ShadowWindowManagerGlobal.findFirst(InsetsState.class, args)) : null);
            }
            return this.inTouchMode ? 1 : 0;
        }

        private void configureWindowFrames(WindowInfo windowInfo, @Nullable WindowManager.LayoutParams inAttrs, Point requestedSize, Rect outFrame, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, InsetsState outInsetsState) {
            int width;
            SystemUi systemUi = SystemUi.systemUiForDisplay(windowInfo.displayId);
            DisplayInfo displayInfo = DisplayManagerGlobal.getInstance().getDisplayInfo(windowInfo.displayId);
            WindowManager.LayoutParams attrs = windowInfo.attrs;
            if (inAttrs != null) {
                attrs.copyFrom(inAttrs);
            }
            windowInfo.displayFrame.set(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
            Rect contentFrame = new Rect(windowInfo.displayFrame);
            systemUi.adjustFrameForInsets(attrs, contentFrame);
            boolean useRequestedSize = Boolean.getBoolean("robolectric.windowManager.useRequestedSize");
            int n = useRequestedSize && requestedSize != null && attrs.width != -1 ? requestedSize.x : (width = attrs.width > 0 ? attrs.width : contentFrame.width());
            int height = useRequestedSize && requestedSize != null && attrs.height != -1 ? requestedSize.y : (attrs.height > 0 ? attrs.height : contentFrame.height());
            Gravity.apply((int)attrs.gravity, (int)width, (int)height, (Rect)contentFrame, (int)((int)((float)attrs.x + attrs.horizontalMargin * (float)contentFrame.width())), (int)((int)((float)attrs.y + attrs.verticalMargin * (float)contentFrame.height())), (Rect)windowInfo.frame);
            if (!useRequestedSize) {
                windowInfo.frame.offsetTo(attrs.x, attrs.y);
            } else {
                Gravity.applyDisplay((int)attrs.gravity, (Rect)contentFrame, (Rect)windowInfo.frame);
            }
            SystemUi.systemUiForDisplay(windowInfo.displayId).putInsets(windowInfo);
            windowInfo.put(outFrame, outContentInsets, outVisibleInsets, outStableInsets, outInsetsState);
        }

        public boolean getInTouchMode() {
            return this.inTouchMode;
        }

        public void setInTouchMode(boolean inTouchMode) {
            this.inTouchMode = inTouchMode;
        }

        public IBinder prepareDrag() {
            return new Binder();
        }

        public Object performDrag(Object[] args) {
            for (int i = args.length - 1; i >= 0; --i) {
                if (!(args[i] instanceof ClipData)) continue;
                this.lastDragClipData = (ClipData)args[i];
                return RuntimeEnvironment.getApiLevel() >= 28 ? new Binder() : Boolean.valueOf(true);
            }
            throw new AssertionError((Object)"Missing ClipData param");
        }

        public void updateInsets(Object[] args) {
            int sdk = RuntimeEnvironment.getApiLevel();
            Preconditions.checkState((sdk >= 30 ? 1 : 0) != 0);
            IWindow window = (IWindow)args[0];
            WindowInfo windowInfo = this.windows.computeIfAbsent(window, id -> new WindowInfo());
            if (sdk <= 31) {
                InsetsState state = (InsetsState)args[1];
                InsetsSource statusBar = state.peekSource(0);
                InsetsSource navBar = state.peekSource(1);
                windowInfo.requestedVisibleTypes = (statusBar == null || statusBar.isVisible() ? WindowInsets.Type.statusBars() : 0) | (navBar == null || navBar.isVisible() ? WindowInsets.Type.navigationBars() : 0);
            } else if (sdk <= 33) {
                InsetsVisibilitiesReflector visibilities = (InsetsVisibilitiesReflector)Reflector.reflector(InsetsVisibilitiesReflector.class, (Object)args[1]);
                boolean statusBar = visibilities.getVisibility(0);
                boolean navBar = visibilities.getVisibility(1);
                windowInfo.requestedVisibleTypes = (statusBar ? WindowInsets.Type.statusBars() : 0) | (navBar ? WindowInsets.Type.navigationBars() : 0);
            } else {
                windowInfo.requestedVisibleTypes = (Integer)args[1];
            }
            if (windowInfo.displayId != -1) {
                this.applyInsets(windowInfo.displayId, windowInfo.requestedVisibleTypes);
            }
        }

        void applyInsets(int displayId, int requestedVisibleTypes) {
            boolean navBarVisible;
            boolean statusBarVisible;
            Preconditions.checkState((displayId != -1 ? 1 : 0) != 0);
            SystemUi systemUi = SystemUi.systemUiForDisplay(displayId);
            boolean bl = statusBarVisible = (requestedVisibleTypes & WindowInsets.Type.statusBars()) != 0;
            if (systemUi.getStatusBar().isVisible() != statusBarVisible) {
                systemUi.getStatusBar().setVisible(statusBarVisible);
                this.notifyInsetsChanges(systemUi, systemUi.getStatusBar().getId());
            }
            boolean bl2 = navBarVisible = (requestedVisibleTypes & WindowInsets.Type.navigationBars()) != 0;
            if (systemUi.getNavigationBar().isVisible() != navBarVisible) {
                systemUi.getNavigationBar().setVisible(navBarVisible);
                this.notifyInsetsChanges(systemUi, systemUi.getNavigationBar().getId());
            }
        }

        void notifyInsetsChanges(SystemUi systemUi, @Nullable Integer type) {
            for (Map.Entry<IWindow, WindowInfo> windowEntry : this.windows.entrySet()) {
                if (windowEntry.getValue().displayId != systemUi.getDisplayId()) continue;
                systemUi.putInsets(windowEntry.getValue());
                this.sendInsetsControlChanged(windowEntry.getKey(), type, false);
                this.sendResize(windowEntry.getKey());
            }
        }

        void sendInsetsControlChanged(IWindow window, @Nullable Integer type, boolean hasControlsChanged) {
            int sdk = RuntimeEnvironment.getApiLevel();
            WindowInfo windowInfo = Objects.requireNonNull(this.windows.get(window));
            InsetsState insetsState = new InsetsState(windowInfo.insetsState);
            if (sdk == 30 && type != null) {
                for (int i = 0; i < ((ShadowInsetsState)Shadow.extract((Object)insetsState)).getSourceSize(); ++i) {
                    if (i == type) continue;
                    insetsState.removeSource(i);
                }
            }
            if (sdk == 30 && !hasControlsChanged || sdk >= 31 && sdk <= 32) {
                ClassParameterBuilder params = new ClassParameterBuilder();
                params.add(InsetsState.class, windowInfo.insetsState);
                params.addIf(sdk >= 31, Boolean.TYPE, false);
                params.addIf(sdk >= 31, Boolean.TYPE, false);
                ReflectionHelpers.callInstanceMethod((Object)window, (String)"insetsChanged", params.build());
            } else {
                ClassParameterBuilder params = new ClassParameterBuilder();
                params.add(InsetsState.class, windowInfo.insetsState);
                if (sdk >= 35) {
                    params.add(InsetsSourceControl.Array.class, new InsetsSourceControl.Array());
                } else {
                    params.add(InsetsSourceControl[].class, windowInfo.hasInsetsControl ? this.populateInsetSourceControls(windowInfo, null) : null);
                }
                ReflectionHelpers.callInstanceMethod((Object)window, (String)"insetsControlChanged", params.build());
            }
        }

        void sendResize(IWindow window) {
            int sdk = RuntimeEnvironment.getApiLevel();
            WindowInfo windowInfo = Objects.requireNonNull(this.windows.get(window));
            this.configureWindowFrames(windowInfo, windowInfo.attrs, null, null, null, null, null, null);
            Configuration configuration = RuntimeEnvironment.getApplication().getResources().getConfiguration();
            ClassParameterBuilder args = new ClassParameterBuilder();
            if (sdk > 34 && ReflectionHelpers.hasMethod(IWindow.class, (String)"resized", (Class[])new Class[]{WindowRelayoutResult.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE})) {
                ClassParameterBuilder rlrArgs = new ClassParameterBuilder();
                rlrArgs.add(ClientWindowFrames.class, windowInfo.frames);
                rlrArgs.add(MergedConfiguration.class, new MergedConfiguration(configuration));
                rlrArgs.add(InsetsState.class, windowInfo.insetsState);
                rlrArgs.add(InsetsSourceControl.Array.class, new InsetsSourceControl.Array());
                WindowRelayoutResult layout = (WindowRelayoutResult)ReflectionHelpers.callConstructor(WindowRelayoutResult.class, rlrArgs.build());
                args.add(WindowRelayoutResult.class, layout);
                args.add(Boolean.TYPE, false);
                args.add(Boolean.TYPE, false);
                args.add(Integer.TYPE, windowInfo.displayId);
                args.add(Boolean.TYPE, false);
                args.add(Boolean.TYPE, false);
                ReflectionHelpers.callInstanceMethod((Object)window, (String)"resized", args.build());
                return;
            }
            if (sdk >= 31) {
                args.add(ClientWindowFrames.class, windowInfo.frames);
            } else {
                args.add(Rect.class, windowInfo.frame);
                args.addIf(sdk <= 29, Rect.class, new Rect());
                args.add(Rect.class, windowInfo.contentInsets);
                args.add(Rect.class, windowInfo.visibleInsets);
                args.add(Rect.class, windowInfo.stableInsets);
                args.addIf(sdk >= 23 && sdk <= 29, Rect.class, new Rect());
            }
            args.add(Boolean.TYPE, false);
            if (sdk <= 25) {
                args.add(Configuration.class, configuration);
            } else {
                args.add(MergedConfiguration.class, new MergedConfiguration(configuration));
            }
            args.addIf(sdk >= 24 && sdk <= 30, Rect.class, new Rect());
            if (sdk >= 33) {
                args.add(InsetsState.class, windowInfo.insetsState);
            }
            args.addIf(sdk >= 24, Boolean.TYPE, false);
            args.addIf(sdk >= 24, Boolean.TYPE, false);
            args.addIf(sdk >= 26, Integer.TYPE, windowInfo.displayId);
            if (sdk >= 28 && sdk <= 30) {
                args.add(DisplayCutout.ParcelableWrapper.class, new DisplayCutout.ParcelableWrapper());
            }
            args.addIf(sdk >= 33, Integer.TYPE, 0);
            args.addIf(sdk == 33, Integer.TYPE, 0);
            args.addIf(sdk >= 34, Boolean.TYPE, false);
            if (sdk > 34) {
                args.add(ActivityWindowInfo.class, null);
            }
            ReflectionHelpers.callInstanceMethod((Object)window, (String)"resized", args.build());
        }

        private void transferWindowInsetsControlTo(WindowInfo windowInfo) {
            if (RuntimeEnvironment.getApiLevel() != 30) {
                return;
            }
            for (Map.Entry<IWindow, WindowInfo> entry : this.windows.entrySet()) {
                boolean hasControl = entry.getValue() == windowInfo;
                if (entry.getValue().hasInsetsControl == hasControl) continue;
                entry.getValue().hasInsetsControl = hasControl;
                this.sendInsetsControlChanged(entry.getKey(), null, true);
            }
        }

        @CanIgnoreReturnValue
        private InsetsSourceControl[] populateInsetSourceControls(WindowInfo windowInfo, InsetsSourceControl[] controls) {
            int sdk = RuntimeEnvironment.getApiLevel();
            int lastControl = ((ShadowInsetsState.InsetsStateReflector)Reflector.reflector(ShadowInsetsState.InsetsStateReflector.class)).getImeType();
            if (controls == null) {
                controls = new InsetsSourceControl[lastControl + 1];
            }
            for (int i = 0; i <= lastControl; ++i) {
                ClassParameterBuilder params = new ClassParameterBuilder();
                params.add(Integer.TYPE, i);
                params.add(SurfaceControl.class, null);
                params.add(Point.class, new Point());
                params.addIf(sdk >= 31, Insets.class, Insets.of((int)0, (int)0, (int)0, (int)0));
                controls[i] = (InsetsSourceControl)ReflectionHelpers.callConstructor(InsetsSourceControl.class, params.build());
                ((ShadowInsetsState)Shadow.extract((Object)windowInfo.insetsState)).getOrCreateSource(i);
            }
            return controls;
        }
    }

    @ForType(value=WindowManagerGlobal.class)
    static interface WindowManagerGlobalReflector {
        @Accessor(value="sDefaultWindowManager")
        @Static
        public void setDefaultWindowManager(WindowManagerGlobal var1);

        @Static
        @Accessor(value="sWindowManagerService")
        public IWindowManager getWindowManagerService();

        @Static
        @Accessor(value="sWindowManagerService")
        public void setWindowManagerService(IWindowManager var1);

        @Accessor(value="mViews")
        public List<View> getWindowViews();
    }

    public static final class PredictiveBackGesture
    implements Closeable {
        private final int edge;
        private final int displayWidth;
        private final float startTouchX;
        private final float progressThreshold;
        private float touchX;
        private float touchY;
        private boolean isCancelled;
        private boolean isFinished;

        private PredictiveBackGesture(int edge, int displayWidth, float touchX, float touchY) {
            this.edge = edge;
            this.displayWidth = displayWidth;
            this.progressThreshold = ViewConfiguration.get((Context)RuntimeEnvironment.getApplication()).getScaledTouchSlop();
            this.startTouchX = touchX;
            this.touchX = touchX;
            this.touchY = touchY;
        }

        public void moveBy(float dx, float dy) {
            Preconditions.checkState((!this.isCancelled && !this.isFinished ? 1 : 0) != 0);
            try {
                this.touchX += dx;
                this.touchY += dy;
                windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackProgressed(BackMotionEvents.newBackMotionEvent(this.edge, this.touchX, this.touchY, this.calculateProgress()));
                ShadowLooper.idleMainLooper();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void cancel() {
            Preconditions.checkState((!this.isCancelled && !this.isFinished ? 1 : 0) != 0);
            this.isCancelled = true;
            try {
                windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackCancelled();
                windowSessionDelegate.currentPredictiveBackGesture = null;
                ShadowLooper.idleMainLooper();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            Preconditions.checkState((!this.isFinished ? 1 : 0) != 0);
            this.isFinished = true;
            if (!this.isCancelled) {
                try {
                    windowSessionDelegate.onBackInvokedCallbackInfo.getCallback().onBackInvoked();
                    windowSessionDelegate.currentPredictiveBackGesture = null;
                    ShadowLooper.idleMainLooper();
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private float calculateProgress() {
            int direction = this.edge == 0 ? 1 : -1;
            float draggableWidth = (this.edge == 0 ? (float)this.displayWidth - this.startTouchX : this.startTouchX) - this.progressThreshold;
            return Math.max(((this.touchX - this.startTouchX) * (float)direction - this.progressThreshold) / draggableWidth, 0.0f);
        }
    }

    private static class BackMotionEvents {
        private BackMotionEvents() {
        }

        static BackMotionEvent newBackMotionEvent(int edge, float touchX, float touchY, float progress) {
            if (RuntimeEnvironment.getApiLevel() <= 34) {
                return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEvent(touchX, touchY, progress, 0.0f, 0.0f, edge, null);
            }
            if (RuntimeEnvironment.getApiLevel() <= 35) {
                return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEventV(touchX, touchY, progress, 0.0f, 0.0f, Boolean.FALSE, edge, null);
            }
            if (RuntimeEnvironment.getApiLevel() <= 36) {
                return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEventB(touchX, touchY, SystemClock.uptimeMillis(), progress, Boolean.FALSE, edge, null);
            }
            return ((BackMotionEventReflector)Reflector.reflector(BackMotionEventReflector.class)).newBackMotionEventPostB(touchX, touchY, SystemClock.uptimeMillis(), progress, Boolean.FALSE, edge);
        }

        private static Constructor<?> findPublicConstructor() {
            for (Constructor<?> constructor : BackMotionEvent.class.getDeclaredConstructors()) {
                if (constructor.getParameterCount() <= 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
                return constructor;
            }
            throw new IllegalStateException("Could not find a BackMotionEvent constructor");
        }
    }

    @ForType(className="android.view.InsetsVisibilities")
    static interface InsetsVisibilitiesReflector {
        public boolean getVisibility(int var1);
    }

    @ForType(value=BackMotionEvent.class)
    static interface BackMotionEventReflector {
        @org.robolectric.util.reflector.Constructor
        public BackMotionEvent newBackMotionEvent(float var1, float var2, float var3, float var4, float var5, int var6, RemoteAnimationTarget var7);

        @org.robolectric.util.reflector.Constructor
        public BackMotionEvent newBackMotionEventV(float var1, float var2, float var3, float var4, float var5, boolean var6, int var7, RemoteAnimationTarget var8);

        @org.robolectric.util.reflector.Constructor
        public BackMotionEvent newBackMotionEventB(float var1, float var2, long var3, float var5, boolean var6, int var7, RemoteAnimationTarget var8);

        @org.robolectric.util.reflector.Constructor
        public BackMotionEvent newBackMotionEventPostB(float var1, float var2, long var3, float var5, boolean var6, int var7);
    }

    private static final class ClassParameterBuilder {
        private final List<ReflectionHelpers.ClassParameter<?>> parameters = new ArrayList();

        private ClassParameterBuilder() {
        }

        <T> void add(Class<T> type, T parameter) {
            this.parameters.add(ReflectionHelpers.ClassParameter.from(type, parameter));
        }

        <T> void addIf(boolean shouldAdd, Class<T> type, T parameter) {
            if (shouldAdd) {
                this.add(type, parameter);
            }
        }

        ReflectionHelpers.ClassParameter<?>[] build() {
            return this.parameters.toArray(new ReflectionHelpers.ClassParameter[0]);
        }
    }

    static final class WindowInfo {
        final Rect displayFrame = new Rect();
        final ClientWindowFrames frames;
        final Rect frame;
        final InsetsState insetsState = RuntimeEnvironment.getApiLevel() >= 29 ? new InsetsState() : null;
        final Rect contentInsets = new Rect();
        final Rect visibleInsets = new Rect();
        final Rect stableInsets = new Rect();
        final WindowManager.LayoutParams attrs = new WindowManager.LayoutParams();
        int displayId = -1;
        int requestedVisibleTypes;
        boolean hasInsetsControl;

        WindowInfo() {
            int n = this.requestedVisibleTypes = RuntimeEnvironment.getApiLevel() >= 30 ? WindowInsets.Type.systemBars() : 0;
            if (RuntimeEnvironment.getApiLevel() >= 31) {
                this.frames = new ClientWindowFrames();
                this.frame = this.frames.frame;
            } else {
                this.frames = null;
                this.frame = new Rect();
            }
        }

        void put(Rect outFrame, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, InsetsState outInsetsState) {
            if (outFrame != null) {
                outFrame.set(this.frame);
            }
            if (outContentInsets != null) {
                outContentInsets.set(this.contentInsets);
            }
            if (outVisibleInsets != null) {
                outVisibleInsets.set(this.visibleInsets);
            }
            if (outStableInsets != null) {
                outStableInsets.set(this.stableInsets);
            }
            if (outInsetsState != null) {
                outInsetsState.set(this.insetsState, true);
            }
        }
    }
}

