/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.vcn.VcnConfig;
import android.net.vcn.VcnManager;
import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=VcnManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowVcnManager {
    private static final Map<VcnManager.VcnStatusCallback, VcnStatusCallbackInfo> callbacks = new HashMap<VcnManager.VcnStatusCallback, VcnStatusCallbackInfo>();
    private static final Map<ParcelUuid, VcnConfig> configs = new HashMap<ParcelUuid, VcnConfig>();
    private static int currentVcnStatus = 0;

    @Implementation
    protected void registerVcnStatusCallback(ParcelUuid subGroup, Executor executor, VcnManager.VcnStatusCallback callback) {
        callbacks.put(callback, new VcnStatusCallbackInfo(executor, subGroup));
    }

    @Implementation
    protected void unregisterVcnStatusCallback(VcnManager.VcnStatusCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("VcnStatusCallback == null");
        }
        if (!callbacks.containsKey(callback)) {
            throw new IllegalArgumentException("VcnStatusCallback not registered");
        }
        callbacks.remove(callback);
    }

    @Implementation
    protected void setVcnConfig(ParcelUuid subGroup, VcnConfig config) {
        configs.put(subGroup, config);
    }

    @Implementation
    protected void clearVcnConfig(ParcelUuid subGroup) {
        if (subGroup == null) {
            throw new IllegalArgumentException("subGroup == null");
        }
        configs.remove(subGroup);
    }

    @Implementation
    protected List<ParcelUuid> getConfiguredSubscriptionGroups() {
        return new ArrayList<ParcelUuid>(configs.keySet());
    }

    public Set<VcnManager.VcnStatusCallback> getRegisteredVcnStatusCallbacks() {
        return Collections.unmodifiableSet(callbacks.keySet());
    }

    public void setStatus(int statusCode) {
        currentVcnStatus = statusCode;
        for (VcnManager.VcnStatusCallback callback : callbacks.keySet()) {
            callbacks.get(callback).executor.execute(() -> callback.onStatusChanged(currentVcnStatus));
        }
    }

    public void setGatewayConnectionError(String gatewayConnectionName, int errorCode, Throwable detail) {
        for (VcnManager.VcnStatusCallback callback : callbacks.keySet()) {
            callbacks.get(callback).executor.execute(() -> callback.onGatewayConnectionError(gatewayConnectionName, errorCode, detail));
        }
    }

    public ParcelUuid getRegisteredSubscriptionGroup(VcnManager.VcnStatusCallback callback) {
        return callbacks.get(callback).subGroup;
    }

    @Resetter
    public static void reset() {
        callbacks.clear();
        configs.clear();
        currentVcnStatus = 0;
    }

    private static final class VcnStatusCallbackInfo {
        private final Executor executor;
        private final ParcelUuid subGroup;

        private VcnStatusCallbackInfo(Executor executor, ParcelUuid subGroup) {
            this.executor = executor;
            this.subGroup = subGroup;
        }
    }
}

