/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.Rating;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.Bundle;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaController.TransportControls.class)
public class ShadowTransportControls {
    @RealObject
    protected MediaController.TransportControls realTransportControls;
    private long lastPerformedAction = 0L;
    @Nullable
    private String customAction;
    @Nullable
    private Bundle customActionArgs;
    private long queueItemId;
    @Nullable
    private Rating rating;
    private long seekToPositionMs;
    @Nullable
    private Uri uri;

    @Implementation
    protected void pause() {
        this.lastPerformedAction = 2L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).pause();
    }

    @Implementation
    protected void play() {
        this.lastPerformedAction = 4L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).play();
    }

    @Implementation
    protected void playFromSearch(String query, Bundle extras) {
        this.lastPerformedAction = 2048L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).playFromSearch(query, extras);
    }

    @Implementation(minSdk=23)
    protected void playFromUri(Uri uri, Bundle extras) {
        this.lastPerformedAction = 8192L;
        this.uri = uri;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).playFromUri(uri, extras);
    }

    @Implementation(minSdk=24)
    protected void prepareFromSearch(String query, Bundle extras) {
        this.lastPerformedAction = 65536L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).prepareFromSearch(query, extras);
    }

    @Implementation(minSdk=24)
    protected void prepareFromUri(Uri uri, Bundle extras) {
        this.lastPerformedAction = 131072L;
        this.uri = uri;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).prepareFromUri(uri, extras);
    }

    @Implementation
    protected void seekTo(long pos) {
        this.lastPerformedAction = 256L;
        this.seekToPositionMs = pos;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).seekTo(pos);
    }

    @Implementation
    protected void sendCustomAction(String action, Bundle args) {
        this.customAction = action;
        this.customActionArgs = args;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).sendCustomAction(action, args);
    }

    @Implementation
    protected void setRating(Rating rating) {
        this.lastPerformedAction = 128L;
        this.rating = rating;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).setRating(rating);
    }

    @Implementation
    protected void skipToNext() {
        this.lastPerformedAction = 32L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).skipToNext();
    }

    @Implementation
    protected void skipToPrevious() {
        this.lastPerformedAction = 16L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).skipToPrevious();
    }

    @Implementation
    protected void skipToQueueItem(long id2) {
        this.lastPerformedAction = 4096L;
        this.queueItemId = id2;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).skipToQueueItem(id2);
    }

    @Implementation
    protected void stop() {
        this.lastPerformedAction = 1L;
        ((TransportControlsReflector)Reflector.reflector(TransportControlsReflector.class, (Object)this.realTransportControls)).stop();
    }

    public long getLastPerformedAction() {
        return this.lastPerformedAction;
    }

    @Nullable
    public String getCustomAction() {
        return this.customAction;
    }

    @Nullable
    public Bundle getCustomActionArgs() {
        return this.customActionArgs;
    }

    public long getSeekToPositionMs() {
        return this.seekToPositionMs;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Nullable
    public Rating getRating() {
        return this.rating;
    }

    public long getQueueItemId() {
        return this.queueItemId;
    }

    @ForType(value=MediaController.TransportControls.class)
    private static interface TransportControlsReflector {
        @Direct
        public void pause();

        @Direct
        public void play();

        @Direct
        public void playFromSearch(String var1, Bundle var2);

        @Direct
        public void playFromUri(Uri var1, Bundle var2);

        @Direct
        public void prepareFromSearch(String var1, Bundle var2);

        @Direct
        public void prepareFromUri(Uri var1, Bundle var2);

        @Direct
        public void seekTo(long var1);

        @Direct
        public void sendCustomAction(String var1, Bundle var2);

        @Direct
        public void setRating(Rating var1);

        @Direct
        public void skipToNext();

        @Direct
        public void skipToPrevious();

        @Direct
        public void skipToQueueItem(long var1);

        @Direct
        public void stop();
    }
}

