/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.rollback.RollbackInfo;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(className="android.content.rollback.RollbackManager", minSdk=29, isInAndroidSdk=false)
public final class ShadowRollbackManager {
    private static final List<RollbackInfo> availableRollbacks = new ArrayList<RollbackInfo>();
    private static final List<RollbackInfo> recentlyCommittedRollbacks = new ArrayList<RollbackInfo>();

    public void addAvailableRollbacks(RollbackInfo rollbackInfo) {
        availableRollbacks.add(rollbackInfo);
    }

    public void addRecentlyCommittedRollbacks(RollbackInfo rollbackInfo) {
        recentlyCommittedRollbacks.add(rollbackInfo);
    }

    @Implementation
    protected List<RollbackInfo> getAvailableRollbacks() {
        return availableRollbacks;
    }

    @Implementation
    protected List<RollbackInfo> getRecentlyCommittedRollbacks() {
        return recentlyCommittedRollbacks;
    }

    @Resetter
    public static void reset() {
        availableRollbacks.clear();
        recentlyCommittedRollbacks.clear();
    }
}

