/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.util.LongSparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.shadows.ResourceModeShadowPicker;
import org.robolectric.shadows.ShadowArscResourcesImpl;

public abstract class ShadowResourcesImpl {
    private static List<LongSparseArray<?>> resettableArrays;

    public static void reset() {
        if (resettableArrays == null) {
            resettableArrays = ShadowResourcesImpl.obtainResettableArrays();
        }
        for (LongSparseArray<?> sparseArray : resettableArrays) {
            sparseArray.clear();
        }
    }

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    public static class Picker
    extends ResourceModeShadowPicker<ShadowResourcesImpl> {
        public Picker() {
            super(ShadowArscResourcesImpl.class, ShadowArscResourcesImpl.class);
        }
    }
}

