/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.opengl.Matrix;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=Matrix.class)
public class ShadowOpenGLMatrix {
    @Implementation(maxSdk=33)
    protected static void multiplyMM(float[] result, int resultOffset, float[] lhs, int lhsOffset, float[] rhs, int rhsOffset) {
        if (result == null) {
            throw new IllegalArgumentException("result == null");
        }
        if (lhs == null) {
            throw new IllegalArgumentException("lhs == null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("rhs == null");
        }
        if (resultOffset + 16 > result.length) {
            throw new IllegalArgumentException("resultOffset + 16 > result.length");
        }
        if (lhsOffset + 16 > lhs.length) {
            throw new IllegalArgumentException("lhsOffset + 16 > lhs.length");
        }
        if (rhsOffset + 16 > rhs.length) {
            throw new IllegalArgumentException("rhsOffset + 16 > rhs.length");
        }
        for (int i = 0; i < 4; ++i) {
            float rhs_i0 = rhs[ShadowOpenGLMatrix.I(i, 0, rhsOffset)];
            float ri0 = lhs[ShadowOpenGLMatrix.I(0, 0, lhsOffset)] * rhs_i0;
            float ri1 = lhs[ShadowOpenGLMatrix.I(0, 1, lhsOffset)] * rhs_i0;
            float ri2 = lhs[ShadowOpenGLMatrix.I(0, 2, lhsOffset)] * rhs_i0;
            float ri3 = lhs[ShadowOpenGLMatrix.I(0, 3, lhsOffset)] * rhs_i0;
            for (int j = 1; j < 4; ++j) {
                float rhs_ij = rhs[ShadowOpenGLMatrix.I(i, j, rhsOffset)];
                ri0 += lhs[ShadowOpenGLMatrix.I(j, 0, lhsOffset)] * rhs_ij;
                ri1 += lhs[ShadowOpenGLMatrix.I(j, 1, lhsOffset)] * rhs_ij;
                ri2 += lhs[ShadowOpenGLMatrix.I(j, 2, lhsOffset)] * rhs_ij;
                ri3 += lhs[ShadowOpenGLMatrix.I(j, 3, lhsOffset)] * rhs_ij;
            }
            result[ShadowOpenGLMatrix.I((int)i, (int)0, (int)resultOffset)] = ri0;
            result[ShadowOpenGLMatrix.I((int)i, (int)1, (int)resultOffset)] = ri1;
            result[ShadowOpenGLMatrix.I((int)i, (int)2, (int)resultOffset)] = ri2;
            result[ShadowOpenGLMatrix.I((int)i, (int)3, (int)resultOffset)] = ri3;
        }
    }

    @Implementation(maxSdk=33)
    protected static void multiplyMV(float[] resultVec, int resultVecOffset, float[] lhsMat, int lhsMatOffset, float[] rhsVec, int rhsVecOffset) {
        if (resultVec == null) {
            throw new IllegalArgumentException("resultVec == null");
        }
        if (lhsMat == null) {
            throw new IllegalArgumentException("lhsMat == null");
        }
        if (rhsVec == null) {
            throw new IllegalArgumentException("rhsVec == null");
        }
        if (resultVecOffset + 4 > resultVec.length) {
            throw new IllegalArgumentException("resultVecOffset + 4 > resultVec.length");
        }
        if (lhsMatOffset + 16 > lhsMat.length) {
            throw new IllegalArgumentException("lhsMatOffset + 16 > lhsMat.length");
        }
        if (rhsVecOffset + 4 > rhsVec.length) {
            throw new IllegalArgumentException("rhsVecOffset + 4 > rhsVec.length");
        }
        float x = rhsVec[rhsVecOffset];
        float y = rhsVec[rhsVecOffset + 1];
        float z = rhsVec[rhsVecOffset + 2];
        float w = rhsVec[rhsVecOffset + 3];
        resultVec[resultVecOffset] = lhsMat[ShadowOpenGLMatrix.I(0, 0, lhsMatOffset)] * x + lhsMat[ShadowOpenGLMatrix.I(1, 0, lhsMatOffset)] * y + lhsMat[ShadowOpenGLMatrix.I(2, 0, lhsMatOffset)] * z + lhsMat[ShadowOpenGLMatrix.I(3, 0, lhsMatOffset)] * w;
        resultVec[resultVecOffset + 1] = lhsMat[ShadowOpenGLMatrix.I(0, 1, lhsMatOffset)] * x + lhsMat[ShadowOpenGLMatrix.I(1, 1, lhsMatOffset)] * y + lhsMat[ShadowOpenGLMatrix.I(2, 1, lhsMatOffset)] * z + lhsMat[ShadowOpenGLMatrix.I(3, 1, lhsMatOffset)] * w;
        resultVec[resultVecOffset + 2] = lhsMat[ShadowOpenGLMatrix.I(0, 2, lhsMatOffset)] * x + lhsMat[ShadowOpenGLMatrix.I(1, 2, lhsMatOffset)] * y + lhsMat[ShadowOpenGLMatrix.I(2, 2, lhsMatOffset)] * z + lhsMat[ShadowOpenGLMatrix.I(3, 2, lhsMatOffset)] * w;
        resultVec[resultVecOffset + 3] = lhsMat[ShadowOpenGLMatrix.I(0, 3, lhsMatOffset)] * x + lhsMat[ShadowOpenGLMatrix.I(1, 3, lhsMatOffset)] * y + lhsMat[ShadowOpenGLMatrix.I(2, 3, lhsMatOffset)] * z + lhsMat[ShadowOpenGLMatrix.I(3, 3, lhsMatOffset)] * w;
    }

    private static int I(int i, int j, int offset) {
        return offset + j + 4 * i;
    }
}

