/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.media.ImageReader;
import android.os.Parcel;
import android.view.Surface;
import android.view.animation.AnimationUtils;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.HardwareRendererNatives;
import org.robolectric.nativeruntime.RecordingCanvasNatives;
import org.robolectric.nativeruntime.RenderNodeNatives;
import org.robolectric.nativeruntime.SurfaceNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNativeImageReader;
import org.robolectric.shadows.ShadowSurface;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Surface.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeSurface {
    @RealObject
    private Surface realSurface;
    private ImageReader containerImageReader;

    @Implementation
    protected static long nativeCreateFromSurfaceTexture(SurfaceTexture surfaceTexture) throws Surface.OutOfResourcesException {
        return 0L;
    }

    @Implementation(maxSdk=34)
    protected static long nativeCreateFromSurfaceControl(long surfaceControlNativeObject) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return SurfaceNatives.nativeCreateFromSurfaceControl((long)surfaceControlNativeObject);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static long nativeGetFromSurfaceControl(long surfaceObject, long surfaceControlNativeObject) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return SurfaceNatives.nativeGetFromSurfaceControl((long)surfaceObject, (long)surfaceControlNativeObject);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static long nativeGetFromSurfaceControl(long surfaceControlNativeObject) {
        return ShadowNativeSurface.nativeGetFromSurfaceControl(0L, surfaceControlNativeObject);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static long nativeGetFromBlastBufferQueue(long surfaceObject, long blastBufferQueueNativeObject) {
        return SurfaceNatives.nativeGetFromBlastBufferQueue((long)surfaceObject, (long)blastBufferQueueNativeObject);
    }

    @Implementation(maxSdk=34)
    protected static long nativeLockCanvas(long nativeObject, Canvas canvas, Rect dirty) throws Surface.OutOfResourcesException {
        return SurfaceNatives.nativeLockCanvas((long)nativeObject, (Canvas)canvas, (Rect)dirty);
    }

    @Implementation(maxSdk=34)
    protected static void nativeUnlockCanvasAndPost(long nativeObject, Canvas canvas) {
        SurfaceNatives.nativeUnlockCanvasAndPost((long)nativeObject, (Canvas)canvas);
    }

    @Implementation(maxSdk=34)
    protected static void nativeRelease(long nativeObject) {
        SurfaceNatives.nativeRelease((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeIsValid(long nativeObject) {
        return SurfaceNatives.nativeIsValid((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeIsConsumerRunningBehind(long nativeObject) {
        return SurfaceNatives.nativeIsConsumerRunningBehind((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static long nativeReadFromParcel(long nativeObject, Parcel source) {
        return SurfaceNatives.nativeReadFromParcel((long)nativeObject, (Parcel)source);
    }

    @Implementation(maxSdk=34)
    protected static void nativeWriteToParcel(long nativeObject, Parcel dest) {
        SurfaceNatives.nativeWriteToParcel((long)nativeObject, (Parcel)dest);
    }

    @Implementation(maxSdk=34)
    protected static void nativeAllocateBuffers(long nativeObject) {
        SurfaceNatives.nativeAllocateBuffers((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetWidth(long nativeObject) {
        return SurfaceNatives.nativeGetWidth((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetHeight(long nativeObject) {
        return SurfaceNatives.nativeGetHeight((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static long nativeGetNextFrameNumber(long nativeObject) {
        return SurfaceNatives.nativeGetNextFrameNumber((long)nativeObject);
    }

    @Implementation(maxSdk=34)
    protected static int nativeSetScalingMode(long nativeObject, int scalingMode) {
        return SurfaceNatives.nativeSetScalingMode((long)nativeObject, (int)scalingMode);
    }

    @Implementation(maxSdk=34)
    protected static int nativeForceScopedDisconnect(long nativeObject) {
        return SurfaceNatives.nativeForceScopedDisconnect((long)nativeObject);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nativeAttachAndQueueBufferWithColorSpace(long nativeObject, HardwareBuffer buffer, int colorSpaceId) {
        return SurfaceNatives.nativeAttachAndQueueBufferWithColorSpace((long)nativeObject, (HardwareBuffer)buffer, (int)colorSpaceId);
    }

    @Implementation(minSdk=27, maxSdk=34)
    protected static int nativeSetSharedBufferModeEnabled(long nativeObject, boolean enabled) {
        return SurfaceNatives.nativeSetSharedBufferModeEnabled((long)nativeObject, (boolean)enabled);
    }

    @Implementation(minSdk=27, maxSdk=34)
    protected static int nativeSetAutoRefreshEnabled(long nativeObject, boolean enabled) {
        return SurfaceNatives.nativeSetAutoRefreshEnabled((long)nativeObject, (boolean)enabled);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static int nativeSetFrameRate(long nativeObject, float frameRate, int compatibility, int changeFrameRateStrategy) {
        return SurfaceNatives.nativeSetFrameRate((long)nativeObject, (float)frameRate, (int)compatibility, (int)changeFrameRateStrategy);
    }

    void setContainerImageReader(ImageReader realImageReader) {
        this.containerImageReader = realImageReader;
    }

    @Implementation
    protected void unlockCanvasAndPost(Canvas canvas) {
        ((SurfaceReflector)Reflector.reflector(SurfaceReflector.class, (Object)this.realSurface)).unlockCanvasAndPost(canvas);
        if (this.containerImageReader != null) {
            ShadowNativeImageReader.triggerOnImageAvailableCallbacks(this.containerImageReader);
        }
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static long nHwuiCreate(long contentRootNode, long surface, boolean isWideColorGamut) {
        long rootRenderNodePtr = HardwareRendererNatives.nCreateRootRenderNode();
        RenderNodeNatives.nSetClipToBounds((long)rootRenderNodePtr, (boolean)false);
        long renderer = HardwareRendererNatives.nCreateProxy((boolean)false, (long)rootRenderNodePtr);
        HardwareRendererNatives.nSetLightAlpha((long)renderer, (float)0.0f, (float)0.0f);
        HardwareRendererNatives.nSetLightGeometry((long)renderer, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        long recordingCanvas = RecordingCanvasNatives.nCreateDisplayListCanvas((long)rootRenderNodePtr, (int)0, (int)0);
        RecordingCanvasNatives.nDrawRenderNode((long)recordingCanvas, (long)contentRootNode);
        RecordingCanvasNatives.nFinishRecording((long)recordingCanvas, (long)rootRenderNodePtr);
        HardwareRendererNatives.nSetSurfacePtr((long)renderer, (long)surface);
        return renderer;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static long nHwuiCreate(long rootNode, long surface) {
        return ShadowNativeSurface.nHwuiCreate(rootNode, surface, false);
    }

    @Implementation(minSdk=26, maxSdk=29)
    protected static void nHwuiSetSurface(long renderer, long surface) {
        if (surface != 0L) {
            HardwareRendererNatives.nSetSurfacePtr((long)renderer, (long)surface);
        }
    }

    @Implementation(minSdk=26, maxSdk=29)
    protected static void nHwuiDraw(long renderer) {
        long vsync = TimeUnit.MILLISECONDS.toNanos(AnimationUtils.currentAnimationTimeMillis());
        long[] frameInfo = new long[9];
        frameInfo[0] = 4L;
        frameInfo[1] = vsync;
        frameInfo[2] = vsync;
        frameInfo[3] = Long.MAX_VALUE;
        frameInfo[4] = 0L;
        HardwareRendererNatives.nSyncAndDrawFrame((long)renderer, (long[])frameInfo, (int)9);
    }

    @Implementation(minSdk=26, maxSdk=29)
    protected static void nHwuiDestroy(long renderer) {
        HardwareRendererNatives.nDeleteProxy((long)renderer);
    }

    @ForType(value=Surface.class)
    static interface SurfaceReflector {
        @Direct
        public void unlockCanvasAndPost(Canvas var1);

        @Accessor(value="mNativeObject")
        public long getNativeObject();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowSurface.class, ShadowNativeSurface.class);
        }
    }
}

