/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import java.io.FileDescriptor;
import java.io.InputStream;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.BitmapFactoryNatives;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowBitmapFactory;
import org.robolectric.shadows.ShadowNativeBitmap;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BitmapFactory.class, minSdk=26, shadowPicker=Picker.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeBitmapFactory {
    @Implementation
    protected static Bitmap decodeResource(Resources res, int id, BitmapFactory.Options options) {
        Bitmap bitmap = ((BitmapFactoryReflector)Reflector.reflector(BitmapFactoryReflector.class)).decodeResource(res, id, options);
        if (bitmap == null) {
            return null;
        }
        ShadowNativeBitmap shadowNativeBitmap = (ShadowNativeBitmap)Shadow.extract((Object)bitmap);
        shadowNativeBitmap.setCreatedFromResId(id);
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        ((BitmapFactoryOptionsReflector)Reflector.reflector(BitmapFactoryOptionsReflector.class)).validate(opts);
        Bitmap bitmap = ((BitmapFactoryReflector)Reflector.reflector(BitmapFactoryReflector.class)).decodeStreamInternal(is, outPadding, opts);
        ((BitmapFactoryReflector)Reflector.reflector(BitmapFactoryReflector.class)).setDensityFromOptions(bitmap, opts);
        return bitmap;
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeDecodeStream(InputStream is, byte[] storage, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        return BitmapFactoryNatives.nativeDecodeStream((InputStream)is, (byte[])storage, (Rect)padding, (BitmapFactory.Options)opts, (long)inBitmapHandle, (long)colorSpaceHandle);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nativeDecodeStream(InputStream is, byte[] storage, Rect padding, BitmapFactory.Options opts) {
        return ShadowNativeBitmapFactory.nativeDecodeStream(is, storage, padding, opts, ShadowNativeBitmapFactory.nativeInBitmap(opts), 0L);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeDecodeFileDescriptor(FileDescriptor fd, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        return BitmapFactoryNatives.nativeDecodeFileDescriptor((FileDescriptor)fd, (Rect)padding, (BitmapFactory.Options)opts, (long)inBitmapHandle, (long)colorSpaceHandle);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nativeDecodeFileDescriptor(FileDescriptor fd, Rect padding, BitmapFactory.Options opts) {
        return ShadowNativeBitmapFactory.nativeDecodeFileDescriptor(fd, padding, opts, ShadowNativeBitmapFactory.nativeInBitmap(opts), 0L);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeDecodeAsset(long nativeAsset, Rect padding, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        return BitmapFactoryNatives.nativeDecodeAsset((long)nativeAsset, (Rect)padding, (BitmapFactory.Options)opts, (long)inBitmapHandle, (long)colorSpaceHandle);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nativeDecodeAsset(long nativeAsset, Rect padding, BitmapFactory.Options opts) {
        return ShadowNativeBitmapFactory.nativeDecodeAsset(nativeAsset, padding, opts, ShadowNativeBitmapFactory.nativeInBitmap(opts), 0L);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeDecodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts, long inBitmapHandle, long colorSpaceHandle) {
        return BitmapFactoryNatives.nativeDecodeByteArray((byte[])data, (int)offset, (int)length, (BitmapFactory.Options)opts, (long)inBitmapHandle, (long)colorSpaceHandle);
    }

    @Implementation(maxSdk=28)
    protected static Bitmap nativeDecodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        return ShadowNativeBitmapFactory.nativeDecodeByteArray(data, offset, length, opts, ShadowNativeBitmapFactory.nativeInBitmap(opts), 0L);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeIsSeekable(FileDescriptor fd) {
        return BitmapFactoryNatives.nativeIsSeekable((FileDescriptor)fd);
    }

    static long nativeInBitmap(BitmapFactory.Options opts) {
        if (opts == null || opts.inBitmap == null) {
            return 0L;
        }
        return opts.inBitmap.getNativeInstance();
    }

    static {
        DefaultNativeRuntimeLoader.injectAndLoad();
    }

    @ForType(value=BitmapFactory.class)
    static interface BitmapFactoryReflector {
        public Bitmap decodeStreamInternal(InputStream var1, Rect var2, BitmapFactory.Options var3);

        public void setDensityFromOptions(Bitmap var1, BitmapFactory.Options var2);

        @Direct
        public Bitmap decodeResource(Resources var1, int var2, BitmapFactory.Options var3);
    }

    @ForType(value=BitmapFactory.Options.class)
    static interface BitmapFactoryOptionsReflector {
        public void validate(BitmapFactory.Options var1);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowBitmapFactory.class, ShadowNativeBitmapFactory.class);
        }
    }
}

