/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.os.Bundle;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=BroadcastReceiver.PendingResult.class)
public final class ShadowBroadcastPendingResult {
    @RealObject
    BroadcastReceiver.PendingResult pendingResult;
    private final SettableFuture<BroadcastReceiver.PendingResult> finished = SettableFuture.create();

    static BroadcastReceiver.PendingResult create(int resultCode, String resultData, Bundle resultExtras, boolean ordered) {
        try {
            return new BroadcastReceiver.PendingResult(resultCode, resultData, resultExtras, 0, ordered, false, null, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static BroadcastReceiver.PendingResult createSticky(Intent intent) {
        try {
            return new BroadcastReceiver.PendingResult(0, intent.getDataString(), intent.getExtras(), 0, false, true, null, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    protected void finish() {
        Preconditions.checkState((boolean)this.finished.set((Object)this.pendingResult), (Object)"Broadcast already finished");
    }

    public ListenableFuture<BroadcastReceiver.PendingResult> getFuture() {
        return this.finished;
    }
}

