/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.util.ArraySet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Ordering;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ResourcesMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.res.android.AssetPath;
import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.String8;
import org.robolectric.shadows.ResourceModeShadowPicker;
import org.robolectric.shadows.ShadowArscAssetManager;
import org.robolectric.shadows.ShadowArscAssetManager10;
import org.robolectric.shadows.ShadowArscAssetManager14;
import org.robolectric.shadows.ShadowArscAssetManager9;
import org.robolectric.shadows.ShadowNativeAssetManager;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Static;

public abstract class ShadowAssetManager {
    public static final Ordering<String> ATTRIBUTE_TYPE_PRECIDENCE = Ordering.explicit((Object)"reference", (Object[])new String[]{"color", "boolean", "integer", "fraction", "dimension", "float", "enum", "flag", "flags", "string"});
    private static final Object resourcesModeLock = new Object();
    private static ResourcesMode.Mode cachedResourcesMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourcesMode.Mode resourcesMode() {
        Object object = resourcesModeLock;
        synchronized (object) {
            if (cachedResourcesMode == null) {
                cachedResourcesMode = (ResourcesMode.Mode)ConfigurationRegistry.get(ResourcesMode.Mode.class);
            }
        }
        return cachedResourcesMode;
    }

    abstract Collection<Path> getAllAssetDirs();

    @VisibleForTesting
    abstract long getNativePtr();

    @ForType(value=AssetManager.class)
    static interface AssetManager28Reflector
    extends AssetManagerReflector {
        @Static
        @Accessor(value="sSystemApkAssets")
        public ApkAssets[] getSystemApkAssets();

        @Static
        @Accessor(value="sSystemApkAssets")
        public void setSystemApkAssets(ApkAssets[] var1);

        @Static
        @Accessor(value="sSystemApkAssetsSet")
        public ArraySet<ApkAssets> getSystemApkAssetsSet();

        @Static
        @Accessor(value="sSystemApkAssetsSet")
        public void setSystemApkAssetsSet(ArraySet<ApkAssets> var1);

        public ApkAssets[] getApkAssets();
    }

    @ForType(value=AssetManager.class)
    static interface AssetManagerReflector {
        @Direct
        @Static
        public AssetManager getSystem();

        @Static
        @Accessor(value="sSystem")
        public void setSystem(AssetManager var1);

        @Accessor(value="mObject")
        public long getNativePtr();

        @Static
        @Direct
        public void createSystemAssetsInZygoteLocked();

        @Direct
        public void releaseTheme(long var1);

        @Accessor(value="mObject")
        public long getObject();

        public void ensureValidLocked();

        @Direct
        public InputStream open(String var1, int var2);

        @Direct
        public InputStream openNonAsset(int var1, String var2, int var3);
    }

    public static abstract class ArscBase
    extends ShadowAssetManager {
        private ResTable compileTimeResTable;

        @Deprecated
        public synchronized ResTable getCompileTimeResTable() {
            if (this.compileTimeResTable == null) {
                CppAssetManager compileTimeCppAssetManager = new CppAssetManager();
                for (AssetPath assetPath : this.getAssetPaths()) {
                    if (assetPath.isSystem) {
                        compileTimeCppAssetManager.addDefaultAssets(RuntimeEnvironment.getCompileTimeSystemResourcesPath());
                        continue;
                    }
                    compileTimeCppAssetManager.addAssetPath(new String8(assetPath.file), null, false);
                }
                this.compileTimeResTable = compileTimeCppAssetManager.getResources();
            }
            return this.compileTimeResTable;
        }

        abstract List<AssetPath> getAssetPaths();
    }

    public static class Picker
    extends ResourceModeShadowPicker<ShadowAssetManager> {
        public Picker() {
            super(ShadowArscAssetManager.class, ShadowArscAssetManager9.class, ShadowArscAssetManager10.class, ShadowArscAssetManager14.class, ShadowNativeAssetManager.class);
        }
    }
}

