/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.app.ApplicationPackageManager;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.GetInstallerPackageNameMode;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ApplicationPackageManager.class, isInAndroidSdk=false)
public class ShadowApplicationPackageManager
extends ShadowPackageManager {
    private static final String PLATFORM_PACKAGE_NAME = "android";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String PACKAGE_SCHEME = "package";
    public static final String PERMISSION_CONTROLLER_PACKAGE_NAME = "org.robolectric.permissioncontroller";
    @RealObject
    private ApplicationPackageManager realObject;
    private final List<String> clearedApplicationUserDataPackages = new ArrayList<String>();
    private final HashMap<Integer, String> defaultBrowsers = new HashMap();

    @Implementation
    public List<PackageInfo> getInstalledPackages(int flags) {
        return this.getInstalledPackages((long)flags);
    }

    @Implementation(minSdk=33)
    protected List<PackageInfo> getInstalledPackages(@ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") Object flags) {
        return this.getInstalledPackages(((PackageManager.PackageInfoFlags)flags).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PackageInfo> getInstalledPackages(long flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        Object object = lock;
        synchronized (object) {
            Sets.SetView packageNames = (flags & 0x2000L) == 0L ? packageInfos.keySet() : Sets.union(packageInfos.keySet(), (Set)deletedPackages);
            for (String packageName : packageNames) {
                try {
                    PackageInfo packageInfo = this.getPackageInfo(packageName, flags);
                    result.add(packageInfo);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.i((String)"PackageManager", (String)String.format("Package %s filtered out: %s", packageName, e.getMessage()));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=29)
    protected List<ModuleInfo> getInstalledModules(int flags) {
        Object object = lock;
        synchronized (object) {
            ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>();
            for (String moduleName : moduleInfos.keySet()) {
                try {
                    ModuleInfo moduleInfo = (ModuleInfo)this.getModuleInfo(moduleName, flags);
                    result.add(moduleInfo);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.i((String)"PackageManager", (String)String.format("Module %s filtered out: %s", moduleName, e.getMessage()));
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=29)
    protected @ClassName(value="android.content.pm.ModuleInfo") Object getModuleInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Object object = lock;
        synchronized (object) {
            this.getPackageInfo(packageName, flags);
            Object info = moduleInfos.get(packageName);
            if (info == null) {
                throw new PackageManager.NameNotFoundException("Module: " + packageName + " is not installed.");
            }
            return info;
        }
    }

    @Implementation
    protected ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ActivityInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.activities), resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    private <T extends ComponentInfo> T getComponentInfo(ComponentName component, int flags, Function<PackageInfo, T[]> componentsInPackage, Function<ResolveInfo, T> componentInResolveInfo, Function<T, T> copyConstructor) throws PackageManager.NameNotFoundException {
        String activityName = component.getClassName();
        String packageName = component.getPackageName();
        PackageInfo packageInfo = this.getInternalMutablePackageInfo(packageName);
        ComponentInfo result = null;
        ApplicationInfo appInfo = null;
        if (packageInfo != null) {
            ComponentInfo[] components;
            if (packageInfo.applicationInfo != null) {
                appInfo = packageInfo.applicationInfo;
            }
            if ((components = (ComponentInfo[])componentsInPackage.apply((Object)packageInfo)) != null) {
                for (ComponentInfo activity : components) {
                    if (!activityName.equals(activity.name)) continue;
                    result = (ComponentInfo)copyConstructor.apply((Object)activity);
                    break;
                }
            }
        }
        if (result == null) {
            block1: for (List listOfResolveInfo : resolveInfoForIntent.values()) {
                for (ResolveInfo resolveInfo : listOfResolveInfo) {
                    ComponentInfo info = (ComponentInfo)componentInResolveInfo.apply((Object)resolveInfo);
                    if (!ShadowApplicationPackageManager.isValidComponentInfo(info) || !component.equals((Object)new ComponentName(info.applicationInfo.packageName, info.name))) continue;
                    result = (ComponentInfo)copyConstructor.apply((Object)info);
                    if (appInfo != null) break block1;
                    appInfo = result.applicationInfo;
                    break block1;
                }
            }
        }
        if (result == null) {
            throw new PackageManager.NameNotFoundException("Component not found: " + component);
        }
        if (appInfo == null) {
            appInfo = new ApplicationInfo();
            appInfo.packageName = packageName;
            appInfo.flags = 0x800000;
        } else {
            appInfo = new ApplicationInfo(appInfo);
        }
        result.applicationInfo = appInfo;
        this.applyFlagsToComponentInfo(result, flags);
        return (T)result;
    }

    @Implementation
    protected boolean hasSystemFeature(String name) {
        return systemFeatureList.containsKey(name) ? (Boolean)systemFeatureList.get(name) : false;
    }

    @Implementation
    protected int getComponentEnabledSetting(ComponentName componentName) {
        ShadowPackageManager.ComponentState state = (ShadowPackageManager.ComponentState)componentList.get(componentName);
        return state != null ? state.newState : 0;
    }

    @Implementation
    @Nullable
    protected String getNameForUid(int uid) {
        return (String)namesForUid.get(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Implementation
    @Nullable
    protected String[] getPackagesForUid(int uid) {
        String[] packageNames = (String[])packagesForUid.get(uid);
        if (packageNames != null) {
            return packageNames;
        }
        HashSet<String> results = new HashSet<String>();
        Object object = lock;
        synchronized (object) {
            for (PackageInfo packageInfo : packageInfos.values()) {
                if (packageInfo.applicationInfo == null || packageInfo.applicationInfo.uid != uid) continue;
                results.add(packageInfo.packageName);
            }
        }
        return results.isEmpty() ? null : results.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected int getApplicationEnabledSetting(String packageName) {
        Object object = lock;
        synchronized (object) {
            if (!packageInfos.containsKey(packageName)) {
                throw new IllegalArgumentException("Package doesn't exist: " + packageName);
            }
        }
        return (Integer)applicationEnabledSettingMap.get(packageName);
    }

    @Implementation
    protected ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ProviderInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.providers), resolveInfo -> resolveInfo.providerInfo, ProviderInfo::new);
    }

    @Implementation
    protected void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        componentList.put(componentName, new ShadowPackageManager.ComponentState(newState, flags));
    }

    @Implementation(minSdk=33)
    protected void setComponentEnabledSettings(List<PackageManager.ComponentEnabledSetting> settings) {
        for (PackageManager.ComponentEnabledSetting setting : settings) {
            componentList.put(setting.getComponentName(), new ShadowPackageManager.ComponentState(setting.getEnabledState(), setting.getEnabledFlags()));
        }
    }

    @Implementation(minSdk=29)
    protected void setSyntheticAppDetailsActivityEnabled(String packageName, boolean enabled) {
        ComponentName componentName = new ComponentName(packageName, PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME);
        this.setComponentEnabledSetting(componentName, enabled ? 0 : 2, 1);
    }

    @Implementation(minSdk=29)
    protected boolean getSyntheticAppDetailsActivityEnabled(String packageName) {
        ComponentName componentName = new ComponentName(packageName, PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME);
        int state = this.getComponentEnabledSetting(componentName);
        return state == 1 || state == 0;
    }

    @Implementation
    protected void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        applicationEnabledSettingMap.put(packageName, newState);
    }

    @Implementation
    protected ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        ResolveInfo persistentPreferredResolveInfo = this.resolvePreferredActivity(intent, candidates, persistentPreferredActivities);
        if (persistentPreferredResolveInfo != null) {
            return persistentPreferredResolveInfo;
        }
        ResolveInfo preferredResolveInfo = this.resolvePreferredActivity(intent, candidates, preferredActivities);
        if (preferredResolveInfo != null) {
            return preferredResolveInfo;
        }
        if (!this.shouldShowActivityChooser) {
            return candidates.get(0);
        }
        ResolveInfo c1 = candidates.get(0);
        ResolveInfo c2 = candidates.get(1);
        if (c1.preferredOrder == c2.preferredOrder && ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)c1.activityInfo) && ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)c2.activityInfo)) {
            ResolveInfo result = new ResolveInfo();
            result.activityInfo = new ActivityInfo();
            result.activityInfo.name = "ActivityResolver";
            result.activityInfo.packageName = PLATFORM_PACKAGE_NAME;
            result.activityInfo.applicationInfo = new ApplicationInfo();
            result.activityInfo.applicationInfo.flags = 0x800001;
            result.activityInfo.applicationInfo.packageName = PLATFORM_PACKAGE_NAME;
            return result;
        }
        return c1;
    }

    private ResolveInfo resolvePreferredActivity(Intent intent, List<ResolveInfo> candidates, SortedMap<ComponentName, List<IntentFilter>> preferredActivities) {
        preferredActivities = ShadowApplicationPackageManager.mapForPackage(preferredActivities, intent.getPackage());
        for (ResolveInfo candidate : candidates) {
            ComponentName candidateName;
            List intentFilters;
            ActivityInfo activityInfo = candidate.activityInfo;
            if (!ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)activityInfo) || (intentFilters = (List)preferredActivities.get(candidateName = new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name))) == null) continue;
            for (IntentFilter filter : intentFilters) {
                if ((filter.match(this.getContext().getContentResolver(), intent, false, "robo") & 0xFFF0000) == 0) continue;
                return candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected ProviderInfo resolveContentProvider(String name, int flags) {
        if (name == null) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            for (PackageInfo packageInfo : packageInfos.values()) {
                if (packageInfo.providers == null) continue;
                for (ProviderInfo providerInfo : packageInfo.providers) {
                    for (String authority : Splitter.on((char)';').split((CharSequence)providerInfo.authority)) {
                        if (!name.equals(authority)) continue;
                        return new ProviderInfo(providerInfo);
                    }
                }
            }
        }
        return null;
    }

    @Implementation
    protected ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return null;
    }

    @Override
    @Implementation
    protected PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(packageName, (long)flags);
    }

    @Implementation(minSdk=33)
    protected PackageInfo getPackageInfo(String packageName, @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") Object flags) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(packageName, ((PackageManager.PackageInfoFlags)flags).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageInfo getPackageInfo(String packageName, long flags) throws PackageManager.NameNotFoundException {
        Object object = lock;
        synchronized (object) {
            if ((flags & 0x200000L) != 0L) {
                return this.tryRetrievingFactoryInfo(packageName, flags);
            }
            PackageInfo info = (PackageInfo)packageInfos.get(packageName);
            if (info == null && (flags & 0x2000L) != 0L && deletedPackages.contains(packageName)) {
                info = new PackageInfo();
                info.packageName = packageName;
                info.applicationInfo = new ApplicationInfo();
                info.applicationInfo.packageName = packageName;
            }
            if (info == null) {
                throw new PackageManager.NameNotFoundException(packageName);
            }
            info = ShadowApplicationPackageManager.newPackageInfo(info);
            if (info.applicationInfo == null) {
                return info;
            }
            if (hiddenPackages.contains(packageName) && !ShadowApplicationPackageManager.isFlagSet(flags, 8192L)) {
                throw new PackageManager.NameNotFoundException("Package is hidden, can't find");
            }
            this.applyFlagsToApplicationInfo(info.applicationInfo, flags);
            info.activities = (ActivityInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.activities, flags, 1, ActivityInfo::new);
            info.services = (ServiceInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.services, flags, 4, ServiceInfo::new);
            info.receivers = (ActivityInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.receivers, flags, 2, ActivityInfo::new);
            info.providers = (ProviderInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.providers, flags, 8, ProviderInfo::new);
            return info;
        }
    }

    @Override
    @Implementation(minSdk=31, maxSdk=32)
    protected PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel == 31 || apiLevel == 32) {
            PackageInfo shadowPackageInfo = this.getShadowPackageArchiveInfo(archiveFilePath, flags);
            if (shadowPackageInfo != null) {
                return shadowPackageInfo;
            }
            return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getPackageArchiveInfo(archiveFilePath, flags);
        }
        return super.getPackageArchiveInfo(archiveFilePath, flags);
    }

    private static PackageInfo newPackageInfo(PackageInfo orig) {
        Parcel parcel = Parcel.obtain();
        orig.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return (PackageInfo)PackageInfo.CREATOR.createFromParcel(parcel);
    }

    private <T extends ComponentInfo> T[] applyFlagsToComponentInfoList(T[] components, long flags, int activationFlag, Function<T, T> copyConstructor) {
        if (components == null || (flags & (long)activationFlag) == 0L) {
            return null;
        }
        ArrayList<T> returned = new ArrayList<T>(components.length);
        for (Object component : components) {
            component = (ComponentInfo)copyConstructor.apply(component);
            try {
                this.applyFlagsToComponentInfo((ComponentInfo)component, flags);
                returned.add(component);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (returned.isEmpty()) {
            return null;
        }
        Class<?> componentArrayType = components.getClass();
        ComponentInfo[] result = (ComponentInfo[])Arrays.copyOf(components, returned.size(), componentArrayType);
        return returned.toArray(result);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.services), serviceFilters, (resolveInfo, serviceInfo) -> {
            resolveInfo.serviceInfo = serviceInfo;
        }, resolveInfo -> resolveInfo.serviceInfo, ServiceInfo::new);
    }

    @Implementation(minSdk=33)
    protected List<ResolveInfo> queryIntentServices(Intent intent, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flagsObject) {
        return this.queryIntentServices(intent, (int)((PackageManager.ResolveInfoFlags)flagsObject).getValue());
    }

    private boolean hasSomeComponentInfo(ResolveInfo resolveInfo) {
        return resolveInfo.activityInfo != null || resolveInfo.serviceInfo != null || resolveInfo.providerInfo != null;
    }

    private static boolean isFlagSet(long flags, long matchFlag) {
        return (flags & matchFlag) == matchFlag;
    }

    private static boolean isValidComponentInfo(ComponentInfo componentInfo) {
        return componentInfo != null && componentInfo.applicationInfo != null && componentInfo.applicationInfo.packageName != null && componentInfo.name != null;
    }

    @Implementation
    protected List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentServices(intent, flags);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.activities), activityFilters, (resolveInfo, activityInfo) -> {
            resolveInfo.activityInfo = activityInfo;
        }, resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I extends ComponentInfo> List<ResolveInfo> queryIntentComponents(Intent intent, int flags, Function<PackageInfo, I[]> componentsInPackage, SortedMap<ComponentName, List<IntentFilter>> filters, BiConsumer<ResolveInfo, I> componentSetter, Function<ResolveInfo, I> componentInResolveInfo, Function<I, I> copyConstructor) {
        Object object = lock;
        synchronized (object) {
            if (intent.getComponent() != null) {
                flags &= 0xFFFEFFFF;
            }
            ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
            List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
            if (!resolveInfoList.isEmpty()) {
                result.addAll(resolveInfoList);
            }
            result.addAll((Collection<ResolveInfo>)this.queryComponentsInManifest(intent, componentsInPackage, filters, componentSetter));
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                ComponentInfo componentInfo = (ComponentInfo)componentInResolveInfo.apply((Object)resolveInfo);
                if (this.hasSomeComponentInfo(resolveInfo) && componentInfo == null) {
                    Log.d((String)"PackageManager", (String)"ResolveInfo for different component type");
                    iterator.remove();
                    continue;
                }
                if (componentInfo == null) continue;
                if (!this.applyFlagsToResolveInfo(resolveInfo, flags)) {
                    Log.d((String)"PackageManager", (String)"ResolveInfo doesn't match flags");
                    iterator.remove();
                    continue;
                }
                ApplicationInfo applicationInfo = componentInfo.applicationInfo;
                if (applicationInfo == null) {
                    String packageName = null;
                    if (ShadowApplicationPackageManager.getComponentForIntent(intent) != null) {
                        packageName = ShadowApplicationPackageManager.getComponentForIntent(intent).getPackageName();
                    } else if (intent.getPackage() != null) {
                        packageName = intent.getPackage();
                    } else if (componentInfo.packageName != null) {
                        packageName = componentInfo.packageName;
                    }
                    if (packageName != null) {
                        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
                        if (packageInfo != null && packageInfo.applicationInfo != null) {
                            applicationInfo = new ApplicationInfo(packageInfo.applicationInfo);
                        } else {
                            applicationInfo = new ApplicationInfo();
                            applicationInfo.packageName = packageName;
                            applicationInfo.flags = 0x800000;
                        }
                    }
                } else {
                    applicationInfo = new ApplicationInfo(applicationInfo);
                }
                componentInfo = (ComponentInfo)copyConstructor.apply((Object)componentInfo);
                componentSetter.accept(resolveInfo, componentInfo);
                componentInfo.applicationInfo = applicationInfo;
                try {
                    this.applyFlagsToComponentInfo(componentInfo, flags);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.d((String)"PackageManager", (String)("ComponentInfo doesn't match flags:" + e.getMessage()));
                    iterator.remove();
                }
            }
            Collections.sort(result, new ShadowPackageManager.ResolveInfoComparator());
            return result;
        }
    }

    private boolean applyFlagsToResolveInfo(ResolveInfo resolveInfo, int flags) {
        if ((flags & 0x40) == 0) {
            resolveInfo.filter = null;
        }
        return (flags & 0x10000) == 0 || resolveInfo.isDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I extends ComponentInfo> ImmutableList<ResolveInfo> queryComponentsInManifest(Intent intent, Function<PackageInfo, I[]> componentsInPackage, SortedMap<ComponentName, List<IntentFilter>> filters, BiConsumer<ResolveInfo, I> componentSetter) {
        Object object = lock;
        synchronized (object) {
            if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
                ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
                PackageInfo appPackage = (PackageInfo)packageInfos.get(component.getPackageName());
                if (appPackage == null) {
                    return ImmutableList.of();
                }
                ComponentInfo componentInfo = ShadowApplicationPackageManager.findMatchingComponent((ComponentName)component, (ComponentInfo[])((ComponentInfo[])componentsInPackage.apply((Object)appPackage)));
                if (componentInfo != null) {
                    List componentFilters = (List)filters.get(component);
                    PackageInfo targetPackage = (PackageInfo)packageInfos.get(component.getPackageName());
                    if (!(RuntimeEnvironment.getApiLevel() < 33 || intent.getAction() == null && intent.getCategories() == null && intent.getData() == null || componentFilters == null || component.getPackageName().equals(this.getContext().getPackageName()) || targetPackage.applicationInfo.targetSdkVersion < 33)) {
                        boolean matchFound = false;
                        for (IntentFilter filter : componentFilters) {
                            if (ShadowApplicationPackageManager.matchIntentFilter(intent, filter) <= 0) continue;
                            matchFound = true;
                            break;
                        }
                        if (!matchFound) {
                            Log.w((String)"PackageManager", (String)("Component " + componentInfo + " doesn't have required intent filters for " + intent));
                            return ImmutableList.of();
                        }
                    }
                    ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo(componentInfo);
                    componentSetter.accept(resolveInfo, componentInfo);
                    return ImmutableList.copyOf(new ArrayList<ResolveInfo>(Collections.singletonList(resolveInfo)));
                }
                return ImmutableList.of();
            }
            ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
            SortedMap<ComponentName, List<IntentFilter>> filtersForPackage = ShadowApplicationPackageManager.mapForPackage(filters, intent.getPackage());
            block4: for (Map.Entry componentEntry : filtersForPackage.entrySet()) {
                ComponentName componentName = (ComponentName)componentEntry.getKey();
                for (IntentFilter filter : (List)componentEntry.getValue()) {
                    PackageInfo packageInfo;
                    ComponentInfo[] componentInfoArray;
                    int match = ShadowApplicationPackageManager.matchIntentFilter(intent, filter);
                    if (match <= 0 || (componentInfoArray = (ComponentInfo[])componentsInPackage.apply((Object)(packageInfo = (PackageInfo)packageInfos.get(componentName.getPackageName())))) == null) continue;
                    for (ComponentInfo componentInfo : componentInfoArray) {
                        if (!componentInfo.name.equals(componentName.getClassName())) continue;
                        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo(componentInfo, filter);
                        resolveInfo.match = match;
                        componentSetter.accept(resolveInfo, componentInfo);
                        resolveInfoList.add(resolveInfo);
                        continue block4;
                    }
                }
            }
            return ImmutableList.copyOf(resolveInfoList);
        }
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentActivities(intent, flags);
    }

    @Implementation(minSdk=33)
    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flags, int userId) {
        return this.queryIntentActivities(intent, (int)((PackageManager.ResolveInfoFlags)flags).getValue());
    }

    private static boolean isExplicitIntent(Intent intent) {
        return ShadowApplicationPackageManager.getComponentForIntent(intent) != null;
    }

    private static <T extends ComponentInfo> T findMatchingComponent(ComponentName componentName, T[] components) {
        if (components == null) {
            return null;
        }
        for (T component : components) {
            if (!componentName.equals((Object)new ComponentName(((ComponentInfo)component).packageName, ((ComponentInfo)component).name))) continue;
            return component;
        }
        return null;
    }

    private static ComponentName getComponentForIntent(Intent intent) {
        ComponentName component = intent.getComponent();
        if (component == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            component = intent.getComponent();
        }
        return component;
    }

    private static ResolveInfo buildResolveInfo(ComponentInfo componentInfo) {
        ResolveInfo resolveInfo = new ResolveInfo();
        resolveInfo.resolvePackageName = componentInfo.applicationInfo.packageName;
        resolveInfo.labelRes = componentInfo.labelRes;
        resolveInfo.icon = componentInfo.icon;
        resolveInfo.nonLocalizedLabel = componentInfo.nonLocalizedLabel;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(ComponentInfo componentInfo, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(componentInfo);
        info.isDefault = intentFilter.hasCategory("android.intent.category.DEFAULT");
        info.filter = new IntentFilter(intentFilter);
        info.priority = intentFilter.getPriority();
        return info;
    }

    @Implementation
    protected int checkPermission(String permName, String pkgName) {
        PackageInfo permissionsInfo = this.getInternalMutablePackageInfo(pkgName);
        if (permissionsInfo == null || permissionsInfo.requestedPermissions == null) {
            return -1;
        }
        for (int i = 0; i < permissionsInfo.requestedPermissions.length; ++i) {
            String permission2 = permissionsInfo.requestedPermissions[i];
            if (permission2 == null || !permission2.equals(permName)) continue;
            if (this.isGrantedForBackwardsCompatibility(pkgName, permissionsInfo)) {
                return 0;
            }
            if ((permissionsInfo.requestedPermissionsFlags[i] & 2) != 2) continue;
            return 0;
        }
        return -1;
    }

    private boolean isGrantedForBackwardsCompatibility(String pkgName, PackageInfo permissionsInfo) {
        return permissionsInfo.requestedPermissionsFlags == null || pkgName.equals(RuntimeEnvironment.getApplication().getPackageName());
    }

    @Implementation
    protected ActivityInfo getReceiverInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ActivityInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.receivers), resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    @Implementation(minSdk=33)
    protected ActivityInfo getReceiverInfo(ComponentName component, @ClassName(value="android.content.pm.PackageManager$ComponentInfoFlags") @ClassName(value="android.content.pm.PackageManager$ComponentInfoFlags") Object flags) throws PackageManager.NameNotFoundException {
        return this.getReceiverInfo(component, (int)((PackageManager.ComponentInfoFlags)flags).getValue());
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.receivers), receiverFilters, (resolveInfo, activityInfo) -> {
            resolveInfo.activityInfo = activityInfo;
        }, resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    @Implementation(minSdk=33)
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flags) {
        return this.queryBroadcastReceivers(intent, (int)((PackageManager.ResolveInfoFlags)flags).getValue());
    }

    private static int matchIntentFilter(Intent intent, IntentFilter intentFilter) {
        return intentFilter.match(intent.getAction(), intent.getType(), intent.getScheme(), intent.getData(), intent.getCategories(), "PackageManager");
    }

    @Implementation
    protected ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentServices(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    protected ServiceInfo getServiceInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ServiceInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.services), resolveInfo -> resolveInfo.serviceInfo, ServiceInfo::new);
    }

    @Implementation(minSdk=33)
    protected ServiceInfo getServiceInfo(ComponentName component, @ClassName(value="android.content.pm.PackageManager$ComponentInfoFlags") @ClassName(value="android.content.pm.PackageManager$ComponentInfoFlags") Object flags) throws PackageManager.NameNotFoundException {
        return this.getServiceInfo(component, (int)((PackageManager.ComponentInfoFlags)flags).getValue());
    }

    private void applyFlagsToComponentInfo(ComponentInfo componentInfo, long flags) throws PackageManager.NameNotFoundException {
        int applicationFlags;
        boolean isEnabledForFiltering;
        componentInfo.name = componentInfo.name == null ? "" : componentInfo.name;
        ApplicationInfo applicationInfo = componentInfo.applicationInfo;
        boolean isApplicationEnabled = true;
        if (applicationInfo != null) {
            if (applicationInfo.packageName == null) {
                applicationInfo.packageName = componentInfo.packageName;
            }
            this.applyFlagsToApplicationInfo(componentInfo.applicationInfo, flags);
            componentInfo.packageName = applicationInfo.packageName;
            isApplicationEnabled = applicationInfo.enabled;
        }
        if ((flags & 0x80L) == 0L) {
            componentInfo.metaData = null;
        }
        boolean isComponentEnabled = ShadowApplicationPackageManager.isComponentEnabled(componentInfo);
        if ((flags & 0x20000L) != 0L && Build.VERSION.SDK_INT >= 23) {
            return;
        }
        boolean bl = isEnabledForFiltering = isComponentEnabled && (Build.VERSION.SDK_INT < 24 || isApplicationEnabled);
        if ((flags & 0x200L) == 0L && !isEnabledForFiltering) {
            throw new PackageManager.NameNotFoundException("Disabled component: " + componentInfo);
        }
        if (ShadowApplicationPackageManager.isFlagSet(flags, 0x100000L) && applicationInfo != null && ((applicationFlags = applicationInfo.flags) & 1) != 1) {
            throw new PackageManager.NameNotFoundException("Not system component: " + componentInfo);
        }
        if (!ShadowApplicationPackageManager.isFlagSet(flags, 8192L) && ShadowApplicationPackageManager.isValidComponentInfo(componentInfo) && hiddenPackages.contains(componentInfo.applicationInfo.packageName)) {
            throw new PackageManager.NameNotFoundException("Uninstalled package: " + componentInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected Resources getResourcesForApplication(@Nonnull ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        Object object = lock;
        synchronized (object) {
            if (this.getContext().getPackageName().equals(applicationInfo.packageName)) {
                return this.getContext().getResources();
            }
            if (packageInfos.containsKey(applicationInfo.packageName)) {
                Resources appResources = (Resources)resources.get(applicationInfo.packageName);
                if (appResources == null) {
                    appResources = new Resources(new AssetManager(), null, null);
                    resources.put(applicationInfo.packageName, appResources);
                }
                return appResources;
            }
            Resources resources = null;
            try {
                resources = ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getResourcesForApplication(applicationInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resources == null) {
                throw new PackageManager.NameNotFoundException(applicationInfo.packageName);
            }
            return resources;
        }
    }

    @Implementation
    protected List<ApplicationInfo> getInstalledApplications(int flags) {
        return this.getInstalledApplications((long)flags);
    }

    @Implementation(minSdk=33)
    protected List<ApplicationInfo> getInstalledApplications(@ClassName(value="android.content.pm.PackageManager$ApplicationInfoFlags") @ClassName(value="android.content.pm.PackageManager$ApplicationInfoFlags") Object flags) {
        return this.getInstalledApplications(((PackageManager.ApplicationInfoFlags)flags).getValue());
    }

    private List<ApplicationInfo> getInstalledApplications(long flags) {
        List<PackageInfo> packageInfos = this.getInstalledPackages(flags);
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>(packageInfos.size());
        for (PackageInfo packageInfo : packageInfos) {
            if (packageInfo.applicationInfo == null) continue;
            result.add(packageInfo.applicationInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected String getInstallerPackageName(String packageName) {
        Object object = lock;
        synchronized (object) {
            if (!(ConfigurationRegistry.get(GetInstallerPackageNameMode.Mode.class) != GetInstallerPackageNameMode.Mode.REALISTIC || packageInstallerMap.containsKey(packageName) && packageInfos.containsKey(packageName))) {
                throw new IllegalArgumentException("Package is not installed: " + packageName);
            }
            if (!packageInstallerMap.containsKey(packageName)) {
                Log.w((String)"PackageManager", (String)String.format("Call to getInstallerPackageName returns null for package: '%s'. Please run setInstallerPackageName to set installer package name before making the call.", packageName));
            }
            return (String)packageInstallerMap.get(packageName);
        }
    }

    @Implementation(minSdk=30)
    protected @ClassName(value="android.content.pm.InstallSourceInfo") Object getInstallSourceInfo(String packageName) throws PackageManager.NameNotFoundException {
        if (!packageInstallSourceInfoMap.containsKey(packageName)) {
            throw new PackageManager.NameNotFoundException("Package is not installed: " + packageName);
        }
        return packageInstallSourceInfoMap.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = (PermissionInfo)extraPermissions.get(name);
        if (permissionInfo != null) {
            return ShadowApplicationPackageManager.createCopyPermissionInfo(permissionInfo, flags);
        }
        permissionInfo = (PermissionInfo)AOSP_PLATFORM_PERMISSIONS.get((Object)name);
        if (permissionInfo != null) {
            return ShadowApplicationPackageManager.createCopyPermissionInfo(permissionInfo, flags);
        }
        Object object = lock;
        synchronized (object) {
            for (PackageInfo packageInfo : packageInfos.values()) {
                if (packageInfo.permissions == null) continue;
                for (PermissionInfo permission2 : packageInfo.permissions) {
                    if (!name.equals(permission2.name)) continue;
                    return ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags);
                }
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation(minSdk=23)
    protected boolean shouldShowRequestPermissionRationale(String permission2) {
        return permissionRationaleMap.containsKey(permission2) ? (Boolean)permissionRationaleMap.get(permission2) : false;
    }

    @Implementation
    protected FeatureInfo[] getSystemAvailableFeatures() {
        return systemAvailableFeatures.isEmpty() ? null : systemAvailableFeatures.toArray(new FeatureInfo[0]);
    }

    @Implementation
    protected void verifyPendingInstall(int id2, int verificationCode) {
        if (verificationResults.containsKey(id2)) {
            throw new IllegalStateException("Multiple verifications for id=" + id2);
        }
        verificationResults.put(id2, verificationCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        Object object = lock;
        synchronized (object) {
            verificationTimeoutExtension.put(id2, millisecondsToDelay);
            verificationCodeAtTimeoutExtension.put(id2, verificationCodeAtTimeout);
        }
    }

    @Implementation
    protected void freeStorageAndNotify(String volumeUuid, long freeStorageSize, IPackageDataObserver observer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setInstallerPackageName(String targetPackage, String installerPackageName) {
        Object object = lock;
        synchronized (object) {
            packageInstallerMap.put(targetPackage, installerPackageName);
        }
    }

    @Implementation
    protected List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.providers), providerFilters, (resolveInfo, providerInfo) -> {
            resolveInfo.providerInfo = providerInfo;
        }, resolveInfo -> resolveInfo.providerInfo, ProviderInfo::new);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return Collections.emptyList();
    }

    @HiddenApi
    @Implementation(minSdk=23)
    protected String getPermissionControllerPackageName() {
        return PERMISSION_CONTROLLER_PACKAGE_NAME;
    }

    @Implementation(maxSdk=23)
    protected void getPackageSizeInfo(String pkgName, int uid, @ClassName(value="android.content.pm.IPackageStatsObserver") @ClassName(value="android.content.pm.IPackageStatsObserver") Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get(pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=24)
    protected void getPackageSizeInfoAsUser(String pkgName, int uid, @ClassName(value="android.content.pm.IPackageStatsObserver") @ClassName(value="android.content.pm.IPackageStatsObserver") Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get(pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Override
    @Implementation
    protected void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        super.deletePackage(packageName, observer, flags);
    }

    @Implementation
    protected String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            out[i] = currentToCanonicalNames.getOrDefault(names[i], names[i]);
        }
        return out;
    }

    @Implementation
    protected String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            out[i] = canonicalToCurrentNames.getOrDefault(names[i], names[i]);
        }
        return out;
    }

    @Implementation
    protected boolean isSafeMode() {
        return safeMode;
    }

    @Implementation
    protected Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        Drawable result = (Drawable)applicationIcons.get(packageName);
        if (ShadowApplicationPackageManager.useValidGetApplicationIcon() && result == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return result;
    }

    private static boolean useValidGetApplicationIcon() {
        return Boolean.parseBoolean(System.getProperty("robolectric.useValidGetApplicationIcon", "true"));
    }

    @Implementation
    protected Drawable getApplicationIcon(ApplicationInfo info) throws PackageManager.NameNotFoundException {
        try {
            return this.getApplicationIcon(info.packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            return this.getDefaultActivityIcon();
        }
    }

    @Implementation
    protected Drawable getUserBadgeForDensity(UserHandle userHandle, int i) {
        return null;
    }

    @Implementation
    protected int checkSignatures(String pkg1, String pkg2) {
        try {
            PackageInfo packageInfo1 = this.getPackageInfo(pkg1, 0x8000040);
            PackageInfo packageInfo2 = this.getPackageInfo(pkg2, 0x8000040);
            int signaturesResult = ShadowApplicationPackageManager.compareSignature(packageInfo1.signatures, packageInfo2.signatures);
            if (Build.VERSION.SDK_INT < 28) {
                return signaturesResult;
            }
            Signature[] firstSignatures = packageInfo1.signingInfo == null || packageInfo1.signingInfo.getApkContentsSigners() == null || packageInfo1.signingInfo.getApkContentsSigners().length == 0 ? packageInfo1.signatures : packageInfo1.signingInfo.getApkContentsSigners();
            Signature[] secondSignatures = packageInfo2.signingInfo == null || packageInfo2.signingInfo.getApkContentsSigners() == null || packageInfo2.signingInfo.getApkContentsSigners().length == 0 ? packageInfo2.signatures : packageInfo2.signingInfo.getApkContentsSigners();
            return ShadowApplicationPackageManager.compareSignature(firstSignatures, secondSignatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -4;
        }
    }

    @Implementation
    protected int checkSignatures(int uid1, int uid2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        HashMap<String, PermissionInfo> combinedPermissions = new HashMap<String, PermissionInfo>();
        Object object = lock;
        synchronized (object) {
            for (PackageInfo packageInfo : packageInfos.values()) {
                if (packageInfo.permissions == null) continue;
                for (PermissionInfo permissionInfo : packageInfo.permissions) {
                    combinedPermissions.put(permissionInfo.name, permissionInfo);
                }
            }
        }
        combinedPermissions.putAll((Map<String, PermissionInfo>)AOSP_PLATFORM_PERMISSIONS);
        combinedPermissions.putAll(extraPermissions);
        ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>();
        for (PermissionInfo permissionInfo : combinedPermissions.values()) {
            if (!Objects.equals(permissionInfo.group, group)) continue;
            result.add(ShadowApplicationPackageManager.createCopyPermissionInfo(permissionInfo, flags));
        }
        if (result.isEmpty()) {
            throw new PackageManager.NameNotFoundException(group);
        }
        return result;
    }

    private static PermissionInfo createCopyPermissionInfo(PermissionInfo src, int flags) {
        PermissionInfo matchedPermission = new PermissionInfo(src);
        if ((flags & 0x80) != 128) {
            matchedPermission.metaData = null;
        }
        return matchedPermission;
    }

    private Intent getLaunchIntentForPackage(String packageName, String launcherCategory) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.isEmpty()) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory(launcherCategory);
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Implementation
    protected Intent getLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackage(packageName, "android.intent.category.LAUNCHER");
    }

    @Implementation
    protected Intent getLeanbackLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackage(packageName, "android.intent.category.LEANBACK_LAUNCHER");
    }

    @Implementation(minSdk=24)
    protected @ClassName(value="android.content.pm.PackageInfo") Object getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(packageName, flags);
    }

    @Implementation(minSdk=33)
    protected @ClassName(value="android.content.pm.PackageInfo") Object getPackageInfoAsUser(String packageName, @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") Object flagsObject, int userId) throws PackageManager.NameNotFoundException {
        return this.getPackageInfo(packageName, ((PackageManager.PackageInfoFlags)flagsObject).getValue());
    }

    @Implementation
    protected int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return new int[0];
    }

    @Implementation(minSdk=24)
    protected int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Integer uid = (Integer)uidForPackage.get(packageName);
        if (uid == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return uid;
    }

    @Implementation(minSdk=33)
    protected int getPackageUid(String packageName, @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") @ClassName(value="android.content.pm.PackageManager$PackageInfoFlags") Object flags) throws PackageManager.NameNotFoundException {
        return this.getPackageUid(packageName, (int)((PackageManager.PackageInfoFlags)flags).getValue());
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        if (permissionGroups.containsKey(name)) {
            return ShadowApplicationPackageManager.createCopyPermissionGroupInfo((PermissionGroupInfo)permissionGroups.get(name), flags);
        }
        if (AOSP_PLATFORM_PERMISSION_GROUPS.containsKey((Object)name)) {
            return ShadowApplicationPackageManager.createCopyPermissionGroupInfo((PermissionGroupInfo)AOSP_PLATFORM_PERMISSION_GROUPS.get((Object)name), flags);
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation
    protected List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        HashMap<String, PermissionGroupInfo> result = new HashMap<String, PermissionGroupInfo>();
        for (PermissionGroupInfo permissionGroupInfo : AOSP_PLATFORM_PERMISSION_GROUPS.values()) {
            result.put(permissionGroupInfo.name, ShadowApplicationPackageManager.createCopyPermissionGroupInfo(permissionGroupInfo, flags));
        }
        for (PermissionGroupInfo permissionGroupInfo : permissionGroups.values()) {
            result.put(permissionGroupInfo.name, ShadowApplicationPackageManager.createCopyPermissionGroupInfo(permissionGroupInfo, flags));
        }
        return new ArrayList<PermissionGroupInfo>(result.values());
    }

    private static PermissionGroupInfo createCopyPermissionGroupInfo(PermissionGroupInfo src, int flags) {
        PermissionGroupInfo copy = new PermissionGroupInfo(src);
        if ((flags & 0x80) != 128) {
            copy.metaData = null;
        }
        return copy;
    }

    @Implementation
    protected ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = this.getPackageInfo(packageName, flags);
        if (packageInfo.applicationInfo == null) {
            throw new PackageManager.NameNotFoundException("Package found but without application info");
        }
        return packageInfo.applicationInfo;
    }

    @Implementation(minSdk=33)
    protected ApplicationInfo getApplicationInfo(String packageName, @ClassName(value="android.content.pm.PackageManager$ApplicationInfoFlags") @ClassName(value="android.content.pm.PackageManager$ApplicationInfoFlags") Object flagsObject) throws PackageManager.NameNotFoundException {
        Preconditions.checkArgument((boolean)(flagsObject instanceof PackageManager.ApplicationInfoFlags));
        PackageManager.ApplicationInfoFlags flags = (PackageManager.ApplicationInfoFlags)flagsObject;
        return this.getApplicationInfo(packageName, (int)flags.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFlagsToApplicationInfo(@Nullable ApplicationInfo appInfo, long flags) throws PackageManager.NameNotFoundException {
        if (appInfo == null) {
            return;
        }
        String packageName = appInfo.packageName;
        Integer stateOverride = (Integer)applicationEnabledSettingMap.get(packageName);
        if (stateOverride == null) {
            stateOverride = 0;
        }
        appInfo.enabled = appInfo.enabled && stateOverride == 0 || stateOverride == 1;
        Object object = lock;
        synchronized (object) {
            if (deletedPackages.contains(packageName)) {
                appInfo.flags &= 0xFF7FFFFF;
            }
        }
        if ((flags & 0x20000L) != 0L && Build.VERSION.SDK_INT >= 23) {
            return;
        }
        if ((flags & 0x2000L) == 0L && (appInfo.flags & 0x800000) == 0) {
            throw new PackageManager.NameNotFoundException("Package not installed: " + packageName);
        }
        if ((flags & 0x2000L) == 0L && hiddenPackages.contains(packageName)) {
            throw new PackageManager.NameNotFoundException("Package hidden: " + packageName);
        }
    }

    @Implementation
    protected String[] getSystemSharedLibraryNames() {
        return systemSharedLibraryNames.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    @Nonnull
    protected String getServicesSystemSharedLibraryPackageName() {
        return null;
    }

    @Implementation(minSdk=24)
    @Nonnull
    protected String getSharedSystemSharedLibraryPackageName() {
        return "";
    }

    @Implementation(minSdk=24)
    protected boolean hasSystemFeature(String name, int version) {
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return false;
    }

    @Implementation
    protected boolean addPermission(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected boolean addPermissionAsync(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected void removePermission(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    protected void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        Integer uid;
        Iterator iterator = lock;
        synchronized (iterator) {
            if (!packageInfos.containsKey(packageName)) {
                throw new SecurityException("Package not found: " + packageName);
            }
            PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
            this.checkPermissionGrantStateInitialized(packageInfo);
            int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
            if (permissionIndex < 0) {
                throw new SecurityException("Permission " + permissionName + " not requested by package " + packageName);
            }
            int n = permissionIndex;
            packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] | 2;
            uid = (Integer)uidForPackage.get(packageName);
        }
        if (RuntimeEnvironment.getApiLevel() >= 23 && uid != null) {
            for (Object listener : permissionListeners) {
                ((PackageManager.OnPermissionsChangedListener)listener).onPermissionsChanged(uid.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=23)
    protected void revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
        Integer uid;
        Iterator iterator = lock;
        synchronized (iterator) {
            if (!packageInfos.containsKey(packageName)) {
                throw new SecurityException("Package not found: " + packageName);
            }
            PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
            this.checkPermissionGrantStateInitialized(packageInfo);
            int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
            if (permissionIndex < 0) {
                throw new SecurityException("Permission " + permissionName + " not requested by package " + packageName);
            }
            int n = permissionIndex;
            packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] & 0xFFFFFFFD;
            uid = (Integer)uidForPackage.get(packageName);
        }
        if (RuntimeEnvironment.getApiLevel() >= 23 && uid != null) {
            for (Object listener : permissionListeners) {
                ((PackageManager.OnPermissionsChangedListener)listener).onPermissionsChanged(uid.intValue());
            }
        }
    }

    private void checkPermissionGrantStateInitialized(PackageInfo packageInfo) {
        if (packageInfo.requestedPermissionsFlags == null) {
            throw new SecurityException("Permission grant state (PackageInfo.requestedPermissionFlags) is null. This operation requires this variable to be initialized.");
        }
    }

    private int getPermissionIndex(PackageInfo packageInfo, String permissionName) {
        if (packageInfo.requestedPermissions != null) {
            for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
                if (!permissionName.equals(packageInfo.requestedPermissions[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Implementation(minSdk=23)
    protected int getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        if (permissionFlags.containsKey(packageName)) {
            return ((Map)permissionFlags.get(packageName)).getOrDefault(permissionName, 0);
        }
        return 0;
    }

    @Implementation(minSdk=23)
    protected void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
        if (!permissionFlags.containsKey(packageName)) {
            permissionFlags.put(packageName, new HashMap());
        }
        int existingFlags = ((Map)permissionFlags.get(packageName)).getOrDefault(permissionName, 0);
        int flagsToKeep = ~flagMask & existingFlags;
        int flagsToChange = flagMask & flagValues;
        int newFlags = flagsToKeep | flagsToChange;
        ((Map)permissionFlags.get(packageName)).put(permissionName, newFlags);
    }

    @Implementation
    protected int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        Object object = lock;
        synchronized (object) {
            ArrayList<PackageInfo> packageInfosWithPermissions = new ArrayList<PackageInfo>();
            block3: for (PackageInfo packageInfo : packageInfos.values()) {
                for (String permission2 : permissions) {
                    int permissionIndex = this.getPermissionIndex(packageInfo, permission2);
                    if (permissionIndex < 0) continue;
                    packageInfosWithPermissions.add(packageInfo);
                    continue block3;
                }
            }
            return packageInfosWithPermissions;
        }
    }

    @Implementation(minSdk=31)
    protected void getGroupOfPlatformPermission(String permissionName, Executor executor, Consumer<String> callback) {
        if (!AOSP_PLATFORM_PERMISSIONS.containsKey((Object)permissionName) && !permissionName.startsWith("android.permission.")) {
            executor.execute(() -> callback.accept(null));
            return;
        }
        String permissionGroup = null;
        try {
            PermissionInfo permissionInfo = this.getPermissionInfo(permissionName, 0);
            permissionGroup = permissionInfo.group;
        }
        catch (PackageManager.NameNotFoundException permissionInfo) {
            // empty catch block
        }
        String finalPermissionGroup = permissionGroup;
        executor.execute(() -> callback.accept(finalPermissionGroup));
    }

    @Implementation(minSdk=31)
    protected void getPlatformPermissionsForGroup(String permissionGroupName, Executor executor, Consumer<List<String>> callback) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (!AOSP_PLATFORM_PERMISSION_GROUPS.containsKey((Object)permissionGroupName) && !permissionGroupName.startsWith("android.permission-group.")) {
            executor.execute(() -> callback.accept(permissions));
            return;
        }
        HashSet permissionNames = new HashSet();
        permissionNames.addAll(AOSP_PLATFORM_PERMISSIONS.keySet());
        permissionNames.addAll(extraPermissions.keySet());
        for (String permissionName : permissionNames) {
            if (!AOSP_PLATFORM_PERMISSIONS.containsKey((Object)permissionName) && !permissionName.startsWith("android.permission.")) continue;
            try {
                PermissionInfo permissionInfo = this.getPermissionInfo(permissionName, 0);
                if (!permissionGroupName.equals(permissionInfo.group)) continue;
                permissions.add(permissionInfo.name);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        executor.execute(() -> callback.accept(permissions));
    }

    @Implementation
    protected ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return this.resolveActivity(intent, flags);
    }

    @Implementation(minSdk=33)
    protected ResolveInfo resolveActivityAsUser(Intent intent, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flags, int userId) {
        return this.resolveActivity(intent, (int)((PackageManager.ResolveInfoFlags)flags).getValue());
    }

    @Implementation(minSdk=36)
    protected ResolveInfo resolveActivityAsUser(Intent intent, String resolvedType, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flags, int userId) {
        return this.resolveActivityAsUser(intent, flags, userId);
    }

    @Implementation(minSdk=33)
    protected ResolveInfo resolveServiceAsUser(Intent intent, @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") @ClassName(value="android.content.pm.PackageManager$ResolveInfoFlags") Object flags, int userId) {
        return this.resolveService(intent, (int)((PackageManager.ResolveInfoFlags)flags).getValue());
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return null;
    }

    @Implementation(minSdk=24)
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return null;
    }

    @Implementation
    protected InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        return null;
    }

    @Nullable
    @Implementation
    protected Drawable getDrawable(String packageName, int resId, @Nullable ApplicationInfo appInfo) {
        Drawable result = (Drawable)drawables.get(new Pair((Object)packageName, (Object)resId));
        if (result != null) {
            return result;
        }
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getDrawable(packageName, resId, appInfo);
    }

    @Nullable
    @Implementation
    protected CharSequence getText(String packageName, int resId, ApplicationInfo appInfo) {
        if (stringResources.containsKey(packageName) && ((Map)stringResources.get(packageName)).containsKey(resId)) {
            return (CharSequence)((Map)stringResources.get(packageName)).get(resId);
        }
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getText(packageName, resId, appInfo);
    }

    @Implementation
    protected Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        Drawable result = (Drawable)drawableList.get(activityName);
        if (result != null) {
            return result;
        }
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getActivityIcon(activityName);
    }

    @Implementation
    protected Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Implementation
    protected Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(activityName.getPackageName());
    }

    @Implementation
    protected Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        Object object = lock;
        synchronized (object) {
            if (this.getContext().getPackageName().equals(appPackageName)) {
                return this.getContext().getResources();
            }
            if (packageInfos.containsKey(appPackageName)) {
                Resources appResources = (Resources)resources.get(appPackageName);
                if (appResources == null) {
                    appResources = new Resources(new AssetManager(), null, null);
                    resources.put(appPackageName, appResources);
                }
                return appResources;
            }
            throw new PackageManager.NameNotFoundException(appPackageName);
        }
    }

    @Implementation
    protected Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=23)
    protected void addOnPermissionsChangeListener(@ClassName(value="android.content.pm.PackageManager$OnPermissionsChangedListener") @ClassName(value="android.content.pm.PackageManager$OnPermissionsChangedListener") Object listener) {
        permissionListeners.add(listener);
    }

    @Implementation(minSdk=23)
    protected void removeOnPermissionsChangeListener(@ClassName(value="android.content.pm.PackageManager$OnPermissionsChangedListener") @ClassName(value="android.content.pm.PackageManager$OnPermissionsChangedListener") Object listener) {
        permissionListeners.remove(listener);
    }

    @Implementation(maxSdk=27)
    protected void installPackage(Uri packageURI, @ClassName(value="android.content.pm.IPackageInstallObserver") @ClassName(value="android.content.pm.IPackageInstallObserver") Object observer, int flags, String installerPackageName) {
    }

    @Implementation
    protected int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
    }

    @Implementation(minSdk=24)
    protected int getIntentVerificationStatusAsUser(String packageName, int userId) {
        return 0;
    }

    @Implementation(minSdk=24)
    protected boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        return false;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilter> getAllIntentFilters(String packageName) {
        return null;
    }

    @Implementation(minSdk=24)
    protected String getDefaultBrowserPackageNameAsUser(int userId) {
        return this.defaultBrowsers.get(userId);
    }

    @Implementation(minSdk=24)
    protected boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        this.defaultBrowsers.put(userId, packageName);
        return true;
    }

    @Implementation(minSdk=23)
    protected int getMoveStatus(int moveId) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void registerMoveCallback(@ClassName(value="android.content.pm.PackageManager$MoveCallback") @ClassName(value="android.content.pm.PackageManager$MoveCallback") Object callback, Handler handler) {
    }

    @Implementation(minSdk=23)
    protected void unregisterMoveCallback(@ClassName(value="android.content.pm.PackageManager$MoveCallback") @ClassName(value="android.content.pm.PackageManager$MoveCallback") Object callback) {
    }

    @Implementation(minSdk=23)
    protected int movePackage(String packageName, @ClassName(value="android.os.storage.VolumeInfo") @ClassName(value="android.os.storage.VolumeInfo") Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected @ClassName(value="android.os.storage.VolumeInfo") Object getPackageCurrentVolume(@ClassName(value="android.content.pm.ApplicationInfo") @ClassName(value="android.content.pm.ApplicationInfo") Object app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected int movePrimaryStorage(@ClassName(value="android.os.storage.VolumeInfo") @ClassName(value="android.os.storage.VolumeInfo") Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    @Nullable
    protected @ClassName(value="android.os.storage.VolumeInfo") Object getPrimaryStorageCurrentVolume() {
        return null;
    }

    @Implementation(minSdk=23)
    @Nonnull
    protected List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return null;
    }

    @Implementation(minSdk=24)
    protected void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
    }

    @Implementation
    protected void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        this.clearedApplicationUserDataPackages.add(packageName);
    }

    @Implementation
    protected void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=24)
    protected void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=23)
    protected void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
    }

    @Implementation(minSdk=24, maxSdk=27)
    protected String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean isPackageSuspendedForUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    protected void addPackageToPreferred(String packageName) {
    }

    @Implementation
    protected void removePackageFromPreferred(String packageName) {
    }

    @Implementation
    protected List<PackageInfo> getPreferredPackages(int flags) {
        return null;
    }

    @Implementation
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        ShadowApplicationPackageManager.addPreferredActivityInternal(filter, activity, preferredActivities);
    }

    @Implementation
    protected void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.addPreferredActivity(filter, match, set, activity);
    }

    @Implementation
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        return ShadowApplicationPackageManager.getPreferredActivitiesInternal(outFilters, outActivities, packageName, preferredActivities);
    }

    @Implementation
    protected void clearPackagePreferredActivities(String packageName) {
        ShadowApplicationPackageManager.clearPackagePreferredActivitiesInternal(packageName, preferredActivities);
    }

    @Implementation
    protected ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        return null;
    }

    @Implementation(minSdk=24)
    protected void flushPackageRestrictionsAsUser(int userId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        Object object = lock;
        synchronized (object) {
            if (!packageInfos.containsKey(packageName)) {
                return false;
            }
            if (hidden) {
                hiddenPackages.add(packageName);
            } else {
                hiddenPackages.remove(packageName);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        Object object = lock;
        synchronized (object) {
            if (!packageInfos.containsKey(packageName)) {
                return true;
            }
            return hiddenPackages.contains(packageName);
        }
    }

    @Implementation
    protected VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return null;
    }

    @Implementation
    protected boolean isUpgrade() {
        return false;
    }

    @Implementation
    protected boolean isPackageAvailable(String packageName) {
        return false;
    }

    @Implementation
    protected void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
    }

    @Implementation
    protected void clearCrossProfileIntentFilters(int sourceUserId) {
    }

    @Implementation
    protected Drawable loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        Drawable result = (Drawable)unbadgedApplicationIcons.get(itemInfo.packageName);
        if (result != null) {
            return result;
        }
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).loadUnbadgedItemIcon(itemInfo, appInfo);
    }

    @Implementation
    protected Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        return icon;
    }

    @Implementation(minSdk=26)
    protected boolean canRequestPackageInstalls() {
        return canRequestPackageInstalls;
    }

    @Implementation(minSdk=26)
    protected @ClassName(value="android.content.pm.ChangedPackages") Object getChangedPackages(int sequenceNumber) {
        if (sequenceNumber < 0 || sequenceNumberChangedPackagesMap.get((Object)sequenceNumber).isEmpty()) {
            return null;
        }
        return new ChangedPackages(sequenceNumber + 1, new ArrayList(sequenceNumberChangedPackagesMap.get((Object)sequenceNumber)));
    }

    @Implementation(minSdk=28)
    public String getSystemTextClassifierPackageName() {
        return "";
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        return this.setPackagesSuspended(packageNames, suspended, appExtras, launcherExtras, dialogMessage, null);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, @ClassName(value="android.content.pm.SuspendDialogInfo") @ClassName(value="android.content.pm.SuspendDialogInfo") Object dialogInfo) {
        return this.setPackagesSuspended(packageNames, suspended, appExtras, launcherExtras, null, dialogInfo);
    }

    @Implementation(minSdk=30)
    protected boolean isAutoRevokeWhitelisted() {
        return whitelisted;
    }

    @Implementation(minSdk=29)
    protected boolean isDeviceUpgrading() {
        return ShadowPackageManager.deviceUpgrading;
    }

    private String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage, Object dialogInfo) {
        if (this.hasProfileOwnerOrDeviceOwnerOnCurrentUser() && (Build.VERSION.SDK_INT < 29 || !this.isCurrentApplicationProfileOwnerOrDeviceOwner())) {
            throw new UnsupportedOperationException();
        }
        ArrayList<String> unupdatedPackages = new ArrayList<String>();
        for (String packageName : packageNames) {
            if (!this.canSuspendPackage(packageName)) {
                unupdatedPackages.add(packageName);
                continue;
            }
            ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
            if (setting == null) {
                unupdatedPackages.add(packageName);
                continue;
            }
            setting.setSuspended(suspended, dialogMessage, dialogInfo, appExtras, launcherExtras);
        }
        return unupdatedPackages.toArray(new String[0]);
    }

    private boolean isCurrentApplicationProfileOwnerOrDeviceOwner() {
        String currentApplication = this.getContext().getPackageName();
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.getContext().getSystemService("device_policy");
        return devicePolicyManager.isProfileOwnerApp(currentApplication) || devicePolicyManager.isDeviceOwnerApp(currentApplication);
    }

    private boolean hasProfileOwnerOrDeviceOwnerOnCurrentUser() {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.getContext().getSystemService("device_policy");
        return devicePolicyManager.getProfileOwner() != null || UserHandle.of((int)UserHandle.myUserId()).isSystem() && devicePolicyManager.getDeviceOwner() != null;
    }

    private boolean canSuspendPackage(String packageName) {
        return !packageName.equals(this.getContext().getPackageName()) && !this.isPackageDeviceAdmin(packageName) && !this.isPackageActiveLauncher(packageName) && !this.isPackageRequiredInstaller(packageName) && !this.isPackageRequiredUninstaller(packageName) && !this.isPackageRequiredVerifier(packageName) && !this.isPackageDefaultDialer(packageName) && !packageName.equals(PLATFORM_PACKAGE_NAME);
    }

    private boolean isPackageDeviceAdmin(String packageName) {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.getContext().getSystemService("device_policy");
        return packageName.equals(devicePolicyManager.getDeviceOwner());
    }

    private boolean isPackageActiveLauncher(String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo info = this.resolveActivity(intent, 65536);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredInstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile((File)new File("foo.apk")), PACKAGE_MIME_TYPE);
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredUninstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(Uri.fromParts((String)PACKAGE_SCHEME, (String)"foo.bar", null));
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredVerifier(String packageName) {
        Intent intent = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> infos = this.queryBroadcastReceivers(intent, 0x1C0000);
        if (infos != null) {
            for (ResolveInfo info : infos) {
                if (!packageName.equals(info.activityInfo.packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPackageDefaultDialer(String packageName) {
        TelecomManager telecomManager = (TelecomManager)this.getContext().getSystemService("telecom");
        return packageName.equals(telecomManager.getDefaultDialerPackage());
    }

    @HiddenApi
    @Implementation(minSdk=29)
    @RequiresPermission(value="android.permission.SUSPEND_APPS")
    protected String[] getUnsuspendablePackages(String[] packageNames) {
        Objects.requireNonNull(packageNames, "packageNames cannot be null");
        if (this.getContext().checkSelfPermission("android.permission.SUSPEND_APPS") != 0) {
            throw new SecurityException("Current process does not have android.permission.SUSPEND_APPS");
        }
        ArrayList<String> unsuspendablePackages = new ArrayList<String>();
        for (String packageName : packageNames) {
            if (this.canSuspendPackage(packageName)) continue;
            unsuspendablePackages.add(packageName);
        }
        return unsuspendablePackages.toArray(new String[0]);
    }

    @HiddenApi
    @Implementation(minSdk=28)
    protected boolean isPackageSuspended(String packageName) throws PackageManager.NameNotFoundException {
        ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
        if (setting == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return setting.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=26)
    protected boolean isInstantApp(String packageName) {
        Object object = lock;
        synchronized (object) {
            PackageInfo pi = (PackageInfo)packageInfos.get(packageName);
            if (pi == null) {
                return false;
            }
            ApplicationInfo ai = pi.applicationInfo;
            if (ai == null) {
                return false;
            }
            return ai.isInstantApp();
        }
    }

    @HiddenApi
    @Implementation(minSdk=29)
    protected String[] setDistractingPackageRestrictions(String[] packages, int restrictionFlags) {
        for (String pkg : packages) {
            distractingPackageRestrictions.put(pkg, restrictionFlags);
        }
        return new String[0];
    }

    private Context getContext() {
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getContext();
    }

    @Implementation(minSdk=31)
    protected @ClassName(value="android.content.pm.PackageManager$Property") Object getProperty(String propertyName, String packageName) throws PackageManager.NameNotFoundException {
        throw new PackageManager.NameNotFoundException("unsupported");
    }

    @Implementation(minSdk=31)
    protected @ClassName(value="android.content.pm.PackageManager$Property") Object getProperty(String propertyName, ComponentName name) throws PackageManager.NameNotFoundException {
        throw new PackageManager.NameNotFoundException("unsupported");
    }

    public List<String> getClearedApplicationUserDataPackages() {
        return Collections.unmodifiableList(this.clearedApplicationUserDataPackages);
    }

    @ForType(value=ApplicationPackageManager.class)
    private static interface ReflectorApplicationPackageManager {
        @Direct
        public Resources getResourcesForApplication(@Nonnull ApplicationInfo var1);

        @Direct
        public Drawable getDrawable(String var1, int var2, @Nullable ApplicationInfo var3);

        @Direct
        public CharSequence getText(String var1, int var2, ApplicationInfo var3);

        @Direct
        public Drawable getActivityIcon(ComponentName var1);

        @Direct
        public Drawable loadUnbadgedItemIcon(PackageItemInfo var1, ApplicationInfo var2);

        @Direct
        public PackageInfo getPackageArchiveInfo(String var1, int var2);

        @Accessor(value="mContext")
        public Context getContext();
    }
}

