/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

public class ClassNameResolver {
    public static <T> Class<T> resolve(String packageName, String className) throws ClassNotFoundException {
        Class<T> aClass = ClassNameResolver.looksFullyQualified(className) ? ClassNameResolver.safeClassForName(className) : (className.startsWith(".") ? ClassNameResolver.safeClassForName(packageName + className) : ClassNameResolver.safeClassForName(packageName + "." + className));
        if (aClass == null) {
            throw new ClassNotFoundException("Could not find a class for package: " + packageName + " and class name: " + className);
        }
        return aClass;
    }

    private static boolean looksFullyQualified(String className) {
        return className.contains(".") && !className.startsWith(".");
    }

    private static <T> Class<T> safeClassForName(String classNamePath) {
        try {
            return Class.forName(classNamePath);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

