/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.FrameMetrics;
import android.view.Window;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Window.class)
public class ShadowWindow {
    @RealObject
    private Window realWindow;
    protected CharSequence title = "";
    protected Drawable backgroundDrawable;
    private int flags;
    private int privateFlags;
    private int softInputMode;
    private final Set<Window.OnFrameMetricsAvailableListener> onFrameMetricsAvailableListeners = new HashSet<Window.OnFrameMetricsAvailableListener>();

    public static Window create(Context context) throws ClassNotFoundException {
        String className = RuntimeEnvironment.getApiLevel() >= 23 ? "com.android.internal.policy.PhoneWindow" : "com.android.internal.policy.impl.PhoneWindow";
        Class<?> phoneWindowClass = Window.class.getClassLoader().loadClass(className);
        return (Window)ReflectionHelpers.callConstructor(phoneWindowClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation
    protected void setFlags(int flags, int mask) {
        this.flags = this.flags & ~mask | flags & mask;
        ((WindowReflector)Reflector.reflector(WindowReflector.class, (Object)this.realWindow)).setFlags(flags, mask);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected void addSystemFlags(int flags) {
        this.privateFlags |= flags;
        ((WindowReflector)Reflector.reflector(WindowReflector.class, (Object)this.realWindow)).addSystemFlags(flags);
    }

    @Implementation(maxSdk=30)
    @HiddenApi
    protected void addPrivateFlags(int flags) {
        this.privateFlags |= flags;
        ((WindowReflector)Reflector.reflector(WindowReflector.class, (Object)this.realWindow)).addPrivateFlags(flags);
    }

    @Implementation
    protected void setSoftInputMode(int softInputMode) {
        this.softInputMode = softInputMode;
        ((WindowReflector)Reflector.reflector(WindowReflector.class, (Object)this.realWindow)).setSoftInputMode(softInputMode);
    }

    public boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public boolean getPrivateFlag(int flag) {
        return (this.privateFlags & flag) == flag;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public int getSoftInputMode() {
        return this.softInputMode;
    }

    public Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    @Implementation(minSdk=24)
    protected void addOnFrameMetricsAvailableListener(Window.OnFrameMetricsAvailableListener listener, Handler handler) {
        this.onFrameMetricsAvailableListeners.add(listener);
    }

    @Implementation(minSdk=24)
    protected void removeOnFrameMetricsAvailableListener(Window.OnFrameMetricsAvailableListener listener) {
        if (!this.onFrameMetricsAvailableListeners.remove(listener)) {
            throw new IllegalArgumentException("attempt to remove OnFrameMetricsAvailableListener that was never added");
        }
    }

    public void reportOnFrameMetricsAvailable(FrameMetrics frameMetrics) {
        this.reportOnFrameMetricsAvailable(frameMetrics, 0);
    }

    public void reportOnFrameMetricsAvailable(FrameMetrics frameMetrics, int dropCountSinceLastInvocation) {
        for (Window.OnFrameMetricsAvailableListener listener : this.onFrameMetricsAvailableListeners) {
            listener.onFrameMetricsAvailable(this.realWindow, frameMetrics, dropCountSinceLastInvocation);
        }
    }

    @ForType(value=Window.class)
    static interface WindowReflector {
        @Direct
        public void setFlags(int var1, int var2);

        @Direct
        public void addSystemFlags(int var1);

        @Direct
        public void addPrivateFlags(int var1);

        @Direct
        public void setSoftInputMode(int var1);
    }
}

