/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.aware.AttachCallback;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.PublishDiscoverySession;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.SubscribeDiscoverySession;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareSession;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=WifiAwareManager.class, minSdk=26)
public class ShadowWifiAwareManager {
    private static boolean available = true;
    private static WifiAwareSession session;
    private static boolean sessionDetached;
    private static PublishDiscoverySession discoverySessionToPublish;
    private static SubscribeDiscoverySession discoverySessionToSubscribe;

    @Implementation
    protected boolean isAvailable() {
        return available;
    }

    @Implementation
    protected void attach(AttachCallback callback, Handler handler) {
        if (available && sessionDetached) {
            sessionDetached = false;
            handler.post(() -> callback.onAttached(session));
        } else {
            if (available && !sessionDetached) {
                return;
            }
            handler.post(() -> ((AttachCallback)callback).onAttachFailed());
        }
    }

    @Implementation
    protected void publish(int clientId, Looper looper, PublishConfig publishConfig, DiscoverySessionCallback callback) {
        if (available) {
            Handler handler = new Handler(looper);
            handler.post(() -> callback.onPublishStarted(discoverySessionToPublish));
        }
    }

    @Implementation
    protected void subscribe(int clientId, Looper looper, SubscribeConfig subscribeConfig, DiscoverySessionCallback callback) {
        if (available) {
            Handler handler = new Handler(looper);
            handler.post(() -> callback.onSubscribeStarted(discoverySessionToSubscribe));
        }
    }

    @Implementation(minSdk=31)
    protected boolean isDeviceAttached() {
        return !sessionDetached;
    }

    public static PublishDiscoverySession newPublishDiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        return new PublishDiscoverySession(manager, clientId, sessionId);
    }

    public static SubscribeDiscoverySession newSubscribeDiscoverySession(WifiAwareManager manager, int clientId, int sessionId) {
        return new SubscribeDiscoverySession(manager, clientId, sessionId);
    }

    public static WifiAwareSession newWifiAwareSession(WifiAwareManager manager, Binder binder, int clientId) {
        return new WifiAwareSession(manager, binder, clientId);
    }

    public void setAvailable(boolean available) {
        ShadowWifiAwareManager.available = available;
    }

    public void setWifiAwareSession(WifiAwareSession session) {
        ShadowWifiAwareManager.session = session;
    }

    public void setSessionDetached(boolean sessionDetached) {
        ShadowWifiAwareManager.sessionDetached = sessionDetached;
    }

    public void setDiscoverySessionToPublish(PublishDiscoverySession publishDiscoverySession) {
        discoverySessionToPublish = publishDiscoverySession;
    }

    public void setDiscoverySessionToSubscribe(SubscribeDiscoverySession subscribeDiscoverySession) {
        discoverySessionToSubscribe = subscribeDiscoverySession;
    }

    @Resetter
    public static void reset() {
        available = true;
        session = null;
        sessionDetached = true;
        discoverySessionToPublish = null;
        discoverySessionToSubscribe = null;
    }

    static {
        sessionDetached = true;
    }
}

