/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.widget.TextView;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=TextView.class)
public class ShadowTextView
extends ShadowView {
    @RealObject
    TextView realTextView;
    private TextView.OnEditorActionListener onEditorActionListener;
    private int textAppearanceId;
    protected int selectionStart = -1;
    protected int selectionEnd = -1;
    private final List<TextWatcher> watchers = new ArrayList<TextWatcher>();
    private final List<Integer> previousKeyCodes = new ArrayList<Integer>();
    private final List<KeyEvent> previousKeyEvents = new ArrayList<KeyEvent>();
    private int compoundDrawablesWithIntrinsicBoundsLeft;
    private int compoundDrawablesWithIntrinsicBoundsTop;
    private int compoundDrawablesWithIntrinsicBoundsRight;
    private int compoundDrawablesWithIntrinsicBoundsBottom;

    @Implementation
    protected void setTextAppearance(Context context, int resid) {
        this.textAppearanceId = resid;
        ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).setTextAppearance(context, resid);
    }

    @Implementation
    protected boolean onKeyDown(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        return ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).onKeyDown(keyCode, event);
    }

    @Implementation
    protected boolean onKeyUp(int keyCode, KeyEvent event) {
        this.previousKeyCodes.add(keyCode);
        this.previousKeyEvents.add(event);
        return ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).onKeyUp(keyCode, event);
    }

    public int getPreviousKeyCode(int index) {
        return this.previousKeyCodes.get(index);
    }

    public KeyEvent getPreviousKeyEvent(int index) {
        return this.previousKeyEvents.get(index);
    }

    @Override
    public String innerText() {
        CharSequence text = this.realTextView.getText();
        return text == null || this.realTextView.getVisibility() != 0 ? "" : text.toString();
    }

    public int getTextAppearanceId() {
        return this.textAppearanceId;
    }

    @Implementation
    protected void addTextChangedListener(TextWatcher watcher) {
        this.watchers.add(watcher);
        ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).addTextChangedListener(watcher);
    }

    @Implementation
    protected void removeTextChangedListener(TextWatcher watcher) {
        this.watchers.remove(watcher);
        ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).removeTextChangedListener(watcher);
    }

    public List<TextWatcher> getWatchers() {
        return this.watchers;
    }

    @HiddenApi
    @Implementation
    public Locale getTextServicesLocale() {
        return Locale.getDefault();
    }

    @Override
    protected void dumpAttributes(PrintStream out) {
        super.dumpAttributes(out);
        CharSequence text = this.realTextView.getText();
        if (text != null && text.length() > 0) {
            this.dumpAttribute(out, "text", text.toString());
        }
    }

    @Implementation
    protected void setOnEditorActionListener(TextView.OnEditorActionListener l) {
        this.onEditorActionListener = l;
        ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).setOnEditorActionListener(l);
    }

    public TextView.OnEditorActionListener getOnEditorActionListener() {
        return this.onEditorActionListener;
    }

    @Implementation
    protected void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        this.compoundDrawablesWithIntrinsicBoundsLeft = left;
        this.compoundDrawablesWithIntrinsicBoundsTop = top;
        this.compoundDrawablesWithIntrinsicBoundsRight = right;
        this.compoundDrawablesWithIntrinsicBoundsBottom = bottom;
        ((TextViewReflector)Reflector.reflector(TextViewReflector.class, (Object)this.realTextView)).setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
    }

    public int getCompoundDrawablesWithIntrinsicBoundsLeft() {
        return this.compoundDrawablesWithIntrinsicBoundsLeft;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsTop() {
        return this.compoundDrawablesWithIntrinsicBoundsTop;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsRight() {
        return this.compoundDrawablesWithIntrinsicBoundsRight;
    }

    public int getCompoundDrawablesWithIntrinsicBoundsBottom() {
        return this.compoundDrawablesWithIntrinsicBoundsBottom;
    }

    @ForType(value=TextView.class)
    static interface TextViewReflector {
        @Direct
        public void setTextAppearance(Context var1, int var2);

        @Direct
        public boolean onKeyDown(int var1, KeyEvent var2);

        @Direct
        public boolean onKeyUp(int var1, KeyEvent var2);

        @Direct
        public void addTextChangedListener(TextWatcher var1);

        @Direct
        public void removeTextChangedListener(TextWatcher var1);

        @Direct
        public void setOnEditorActionListener(TextView.OnEditorActionListener var1);

        @Direct
        public void setCompoundDrawablesWithIntrinsicBounds(int var1, int var2, int var3, int var4);
    }
}

