/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.app.ActivityThread;
import android.app.AppComponentFactory;
import android.app.LoadedApk;
import android.app.Service;
import android.content.Intent;
import android.database.DataSetObserver;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import android.widget.RemoteViewsService;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ServiceController;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=RemoteViewsAdapter.class, isInAndroidSdk=false)
public class ShadowRemoteViewsAdapter {
    private static final String TAG = "ShadowRemoteViewsAdapter";
    @RealObject
    private RemoteViewsAdapter realRemoteViewsAdapter;
    private BaseAdapter adapter;
    private boolean hasAttemptedToInitAdapter = false;

    @Implementation
    protected boolean isDataReady() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return true;
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).isDataReady();
    }

    @Implementation
    protected int getCount() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getCount();
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getCount();
    }

    @Implementation
    protected Object getItem(int position) {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getItem(position);
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getItem(position);
    }

    @Implementation
    protected long getItemId(int position) {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getItemId(position);
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getItemId(position);
    }

    @Implementation
    protected boolean hasStableIds() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.hasStableIds();
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).hasStableIds();
    }

    @Implementation
    protected int getItemViewType(int position) {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getItemViewType(position);
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getItemViewType(position);
    }

    @Implementation
    protected View getView(int position, View convertView, ViewGroup parent) {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getView(position, convertView, parent);
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getView(position, convertView, parent);
    }

    @Implementation
    protected int getViewTypeCount() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.getViewTypeCount();
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).getViewTypeCount();
    }

    @Implementation
    protected boolean isEmpty() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            return adapter.isEmpty();
        }
        return ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).isEmpty();
    }

    @Implementation
    protected void notifyDataSetChanged() {
        BaseAdapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.notifyDataSetChanged();
        } else {
            ((RemoteViewsAdapterReflector)Reflector.reflector(RemoteViewsAdapterReflector.class, (Object)this.realRemoteViewsAdapter)).notifyDataSetChanged();
        }
    }

    @Nullable
    private BaseAdapter getAdapter() {
        if (this.adapter == null) {
            if (this.hasAttemptedToInitAdapter) {
                return null;
            }
            this.adapter = ShadowRemoteViewsAdapter.createAdapterFromIntent(this.realRemoteViewsAdapter.getRemoteViewsServiceIntent());
            this.hasAttemptedToInitAdapter = true;
        }
        return this.adapter;
    }

    @Nullable
    private static BaseAdapter createAdapterFromIntent(Intent intent) {
        Class<?> clazz = ShadowRemoteViewsAdapter.maybeExtractClass(intent);
        if (clazz == null) {
            return null;
        }
        try {
            RemoteViewsService remoteViewsService = ShadowRemoteViewsAdapter.createRemoteViewsService(intent, clazz);
            RemoteViewsService.RemoteViewsFactory remoteViewsFactory = remoteViewsService.onGetViewFactory(intent);
            remoteViewsFactory.onCreate();
            return ShadowRemoteViewsAdapter.convertToAdapter(remoteViewsFactory);
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Could not instantiate RemoteViewsService for class " + clazz), (Throwable)e);
            return null;
        }
    }

    private static RemoteViewsService createRemoteViewsService(Intent intent, Class<?> clazz) {
        return (RemoteViewsService)((ServiceController)ShadowRemoteViewsAdapter.buildService(clazz, intent).create()).bind().get();
    }

    private static Class<?> maybeExtractClass(Intent intent) {
        Class<?> clazz;
        try {
            clazz = Class.forName(intent.getComponent().getClassName());
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"Invalid class name provided for the intent.", (Throwable)e);
            return null;
        }
        return clazz;
    }

    private static BaseAdapter convertToAdapter(final RemoteViewsService.RemoteViewsFactory remoteViewsFactory) {
        return new BaseAdapter(){

            public void registerDataSetObserver(DataSetObserver observer) {
            }

            public void unregisterDataSetObserver(DataSetObserver observer) {
            }

            public int getCount() {
                return remoteViewsFactory.getCount();
            }

            public Object getItem(int position) {
                return remoteViewsFactory.getViewAt(position);
            }

            public long getItemId(int position) {
                return remoteViewsFactory.getItemId(position);
            }

            public boolean hasStableIds() {
                return remoteViewsFactory.hasStableIds();
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                RemoteViews remoteViews = remoteViewsFactory.getViewAt(position);
                View view = remoteViews.apply(parent.getContext(), parent);
                remoteViews.reapply(parent.getContext(), view);
                return view;
            }

            public int getViewTypeCount() {
                return remoteViewsFactory.getViewTypeCount();
            }

            public boolean isEmpty() {
                return remoteViewsFactory.getCount() == 0;
            }
        };
    }

    private static <T extends Service> ServiceController<T> buildService(Class<T> serviceClass, Intent intent) {
        return ServiceController.of(ShadowRemoteViewsAdapter.instantiateService(serviceClass, intent), intent);
    }

    private static <T extends Service> T instantiateService(Class<T> serviceClass, Intent intent) {
        LoadedApk loadedApk;
        AppComponentFactory factory;
        if (RuntimeEnvironment.getApiLevel() >= 28 && (factory = ShadowRemoteViewsAdapter.getAppComponentFactory(loadedApk = ShadowRemoteViewsAdapter.getLoadedApk())) != null) {
            try {
                Service instance = factory.instantiateService(loadedApk.getClassLoader(), serviceClass.getName(), intent);
                if (instance != null && serviceClass.isAssignableFrom(instance.getClass())) {
                    return (T)instance;
                }
            }
            catch (ReflectiveOperationException e) {
                Log.e((String)TAG, (String)"Failed to instantiate Service using AppComponentFactory", (Throwable)e);
            }
        }
        return (T)((Service)ReflectionHelpers.callConstructor(serviceClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
    }

    @Nullable
    @RequiresApi(api=28)
    private static AppComponentFactory getAppComponentFactory(LoadedApk loadedApk) {
        if (RuntimeEnvironment.getApiLevel() < 28) {
            return null;
        }
        if (loadedApk == null || loadedApk.getApplicationInfo().appComponentFactory == null) {
            return null;
        }
        return loadedApk.getAppFactory();
    }

    private static LoadedApk getLoadedApk() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return activityThread.getPackageInfo(activityThread.getApplication().getApplicationInfo(), null, 1);
    }

    @ForType(value=RemoteViewsAdapter.class)
    static interface RemoteViewsAdapterReflector {
        @Direct
        public boolean isDataReady();

        @Direct
        public int getCount();

        @Direct
        public Object getItem(int var1);

        @Direct
        public long getItemId(int var1);

        @Direct
        public boolean hasStableIds();

        @Direct
        public int getItemViewType(int var1);

        @Direct
        public View getView(int var1, View var2, ViewGroup var3);

        @Direct
        public int getViewTypeCount();

        @Direct
        public boolean isEmpty();

        @Direct
        public void notifyDataSetChanged();
    }
}

