/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManagerGlobal;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.HardwareRenderingScreenshot;
import org.robolectric.shadows.ShadowView;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.shadows.ShadowWindowManagerGlobal;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=PixelCopy.class, minSdk=26)
public class ShadowPixelCopy {
    @Implementation
    protected static void request(SurfaceView source, @Nonnull Bitmap dest, @Nonnull PixelCopy.OnPixelCopyFinishedListener listener, @Nonnull Handler listenerThread) {
        ShadowPixelCopy.takeScreenshot((View)source, dest, null);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation
    protected static void request(@Nonnull SurfaceView source, @Nullable Rect srcRect, @Nonnull Bitmap dest, @Nonnull PixelCopy.OnPixelCopyFinishedListener listener, @Nonnull Handler listenerThread) {
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        ShadowPixelCopy.takeScreenshot((View)source, dest, srcRect);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation
    protected static void request(@Nonnull Window source, @Nonnull Bitmap dest, @Nonnull PixelCopy.OnPixelCopyFinishedListener listener, @Nonnull Handler listenerThread) {
        ShadowPixelCopy.request(source, null, dest, listener, listenerThread);
    }

    @Implementation
    protected static void request(@Nonnull Window source, @Nullable Rect srcRect, @Nonnull Bitmap dest, @Nonnull PixelCopy.OnPixelCopyFinishedListener listener, @Nonnull Handler listenerThread) {
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        ShadowPixelCopy.takeScreenshot(source.getDecorView(), dest, srcRect);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation
    protected static void request(@Nonnull Surface source, @Nullable Rect srcRect, @Nonnull Bitmap dest, @Nonnull PixelCopy.OnPixelCopyFinishedListener listener, @Nonnull Handler listenerThread) {
        if (srcRect != null && srcRect.isEmpty()) {
            throw new IllegalArgumentException("sourceRect is empty");
        }
        View view = ShadowPixelCopy.findViewForSurface(Objects.requireNonNull(source));
        Rect adjustedSrcRect = null;
        if (srcRect != null) {
            adjustedSrcRect = new Rect(srcRect);
            int[] locationInSurface = ShadowView.getLocationInSurfaceCompat(view);
            adjustedSrcRect.offset(-locationInSurface[0], -locationInSurface[1]);
        }
        ShadowPixelCopy.takeScreenshot(view, dest, adjustedSrcRect);
        ShadowPixelCopy.alertFinished(listener, listenerThread, 0);
    }

    @Implementation(minSdk=34)
    protected static void request(@ClassName(value="android.view.PixelCopy$Request") @ClassName(value="android.view.PixelCopy$Request") Object requestObject, Executor callbackExecutor, final Consumer<?> listener) {
        final PixelCopy.Request request = (PixelCopy.Request)requestObject;
        RequestReflector requestReflector = (RequestReflector)Reflector.reflector(RequestReflector.class, (Object)request);
        PixelCopy.OnPixelCopyFinishedListener legacyListener = new PixelCopy.OnPixelCopyFinishedListener(){

            public void onPixelCopyFinished(int copyResult) {
                listener.accept(((ResultReflector)Reflector.reflector(ResultReflector.class)).newResult(copyResult, request.getDestinationBitmap()));
            }
        };
        Rect adjustedSrcRect = ((PixelCopyReflector)Reflector.reflector(PixelCopyReflector.class)).adjustSourceRectForInsets(requestReflector.getSourceInsets(), request.getSourceRect());
        PixelCopy.request((Surface)requestReflector.getSource(), (Rect)adjustedSrcRect, (Bitmap)request.getDestinationBitmap(), (PixelCopy.OnPixelCopyFinishedListener)legacyListener, (Handler)new Handler(Looper.getMainLooper()));
    }

    private static View findViewForSurface(Surface source) {
        for (View windowView : ((ShadowWindowManagerGlobal.WindowManagerGlobalReflector)Reflector.reflector(ShadowWindowManagerGlobal.WindowManagerGlobalReflector.class, (Object)WindowManagerGlobal.getInstance())).getWindowViews()) {
            ShadowViewRootImpl shadowViewRoot = (ShadowViewRootImpl)Shadow.extract((Object)windowView.getViewRootImpl());
            if (!source.equals(shadowViewRoot.getSurface())) continue;
            return windowView;
        }
        throw new IllegalArgumentException("Could not find view for surface. Is it attached to a window?");
    }

    private static void takeScreenshot(View view, Bitmap screenshot, @Nullable Rect srcRect) {
        ShadowPixelCopy.validateBitmap(screenshot);
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (HardwareRenderingScreenshot.canTakeScreenshot(view)) {
            PerfStatsCollector.getInstance().measure("ShadowPixelCopy-Hardware", () -> HardwareRenderingScreenshot.takeScreenshot(view, bitmap));
        } else {
            PerfStatsCollector.getInstance().measure("ShadowPixelCopy-Software", () -> {
                Canvas screenshotCanvas = new Canvas(bitmap);
                view.draw(screenshotCanvas);
            });
        }
        Rect dst = new Rect(0, 0, screenshot.getWidth(), screenshot.getHeight());
        Canvas resizingCanvas = new Canvas(screenshot);
        Paint paint = new Paint();
        resizingCanvas.drawBitmap(bitmap, srcRect, dst, paint);
    }

    private static void alertFinished(PixelCopy.OnPixelCopyFinishedListener listener, Handler listenerThread, int result) {
        if (listenerThread.getLooper() == Looper.getMainLooper()) {
            listener.onPixelCopyFinished(result);
            return;
        }
        listenerThread.post(() -> listener.onPixelCopyFinished(result));
    }

    private static Bitmap validateBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap cannot be null");
        }
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        if (!bitmap.isMutable()) {
            throw new IllegalArgumentException("Bitmap is immutable");
        }
        return bitmap;
    }

    @ForType(value=PixelCopy.Request.class)
    private static interface RequestReflector {
        @Constructor
        public PixelCopy.Request newRequest(Surface var1, Rect var2);

        @Accessor(value="mSource")
        public Surface getSource();

        @Accessor(value="mSourceInsets")
        public Rect getSourceInsets();
    }

    @ForType(value=PixelCopy.class)
    private static interface PixelCopyReflector {
        @Static
        public Rect adjustSourceRectForInsets(Rect var1, Rect var2);
    }

    @ForType(value=PixelCopy.Result.class)
    private static interface ResultReflector {
        @Constructor
        public PixelCopy.Result newResult(int var1, Bitmap var2);
    }

    @ForType(value=PixelCopy.Request.Builder.class)
    private static interface BuilderReflector {
        @Constructor
        public PixelCopy.Request.Builder newBuilder(PixelCopy.Request var1);
    }

    @Implements(value=PixelCopy.Request.Builder.class, minSdk=34, isInAndroidSdk=false)
    public static class ShadowPixelCopyRequestBuilder {
        @Implementation
        protected static PixelCopy.Request.Builder ofWindow(View source) {
            if (source == null || !source.isAttachedToWindow()) {
                throw new IllegalArgumentException("View must not be null & must be attached to window");
            }
            Rect insets = new Rect();
            Surface surface = null;
            ViewRootImpl root = source.getViewRootImpl();
            if (root != null) {
                surface = root.mSurface;
                insets.set(root.mWindowAttributes.surfaceInsets);
            }
            PixelCopy.Request request = ((RequestReflector)Reflector.reflector(RequestReflector.class)).newRequest(surface, insets);
            return ((BuilderReflector)Reflector.reflector(BuilderReflector.class)).newBuilder(request);
        }
    }
}

