/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.NetworkCapabilities;
import android.net.NetworkSpecifier;
import android.net.TransportInfo;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=NetworkCapabilities.class)
public class ShadowNetworkCapabilities {
    @RealObject
    protected NetworkCapabilities realNetworkCapabilities;
    public static final int NET_CAPABILITY_NOT_BANDWIDTH_CONSTRAINED = 37;

    public static NetworkCapabilities newInstance() {
        return (NetworkCapabilities)Shadow.newInstanceOf(NetworkCapabilities.class);
    }

    @HiddenApi
    @Implementation
    public NetworkCapabilities addTransportType(int transportType) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).addTransportType(transportType);
    }

    @HiddenApi
    @Implementation
    public NetworkCapabilities removeTransportType(int transportType) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).removeTransportType(transportType);
    }

    @HiddenApi
    @Implementation
    public NetworkCapabilities addCapability(int capability) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).addCapability(capability);
    }

    @HiddenApi
    @Implementation
    public NetworkCapabilities removeCapability(int capability) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).removeCapability(capability);
    }

    @Implementation(minSdk=26)
    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setNetworkSpecifier(networkSpecifier);
    }

    @Implementation(minSdk=24, maxSdk=25)
    public NetworkCapabilities setNetworkSpecifier(String networkSpecifier) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setNetworkSpecifier(networkSpecifier);
    }

    @HiddenApi
    @Implementation(minSdk=29)
    public NetworkCapabilities setTransportInfo(TransportInfo transportInfo) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setTransportInfo(transportInfo);
    }

    @HiddenApi
    @Implementation(maxSdk=27, methodName="setLinkDownstreamBandwidthKbps")
    protected void setLinkDownstreamBandwidthKbpsPrePie(int kbps) {
        ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setLinkDownstreamBandwidthKbps(kbps);
    }

    @HiddenApi
    @Implementation(minSdk=28)
    public NetworkCapabilities setLinkDownstreamBandwidthKbps(int kbps) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setLinkDownstreamBandwidthKbps(kbps);
    }

    @HiddenApi
    @Implementation(maxSdk=27, methodName="setLinkUpstreamBandwidthKbps")
    protected void setLinkUpstreamBandwidthKbpsPrePie(int kbps) {
        ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setLinkUpstreamBandwidthKbps(kbps);
    }

    @HiddenApi
    @Implementation(minSdk=28)
    public NetworkCapabilities setLinkUpstreamBandwidthKbps(int kbps) {
        return ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setLinkUpstreamBandwidthKbps(kbps);
    }

    public void clearCapabilities() {
        if (RuntimeEnvironment.getApiLevel() < 23) {
            ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setMNetworkCapabilities(0L);
            if (RuntimeEnvironment.getApiLevel() >= 31) {
                ((NetworkCapabilitiesReflector)Reflector.reflector(NetworkCapabilitiesReflector.class, (Object)this.realNetworkCapabilities)).setMForbiddenNetworkCapabilities(0L);
            }
        } else {
            this.realNetworkCapabilities.clearAll();
        }
    }

    @ForType(value=NetworkCapabilities.class)
    static interface NetworkCapabilitiesReflector {
        @Accessor(value="mNetworkCapabilities")
        public void setMNetworkCapabilities(long var1);

        @Accessor(value="mForbiddenNetworkCapabilities")
        public void setMForbiddenNetworkCapabilities(long var1);

        @Direct
        public NetworkCapabilities addTransportType(int var1);

        @Direct
        public NetworkCapabilities removeTransportType(int var1);

        @Direct
        public NetworkCapabilities addCapability(int var1);

        @Direct
        public NetworkCapabilities removeCapability(int var1);

        @Direct
        public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier var1);

        @Direct
        public NetworkCapabilities setNetworkSpecifier(String var1);

        @Direct
        public NetworkCapabilities setTransportInfo(TransportInfo var1);

        @Direct
        public NetworkCapabilities setLinkDownstreamBandwidthKbps(int var1);

        @Direct
        public NetworkCapabilities setLinkUpstreamBandwidthKbps(int var1);
    }
}

