/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.Network;
import java.io.FileDescriptor;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Network.class)
public class ShadowNetwork {
    @RealObject
    private Network realObject;
    private final Set<Socket> boundSockets = new HashSet<Socket>();
    private final Set<DatagramSocket> boundDatagramSockets = new HashSet<DatagramSocket>();
    private final Set<FileDescriptor> boundFileDescriptors = new HashSet<FileDescriptor>();
    @Nullable
    private SocketFactory socketFactoryOverride;

    public static Network newInstance(int netId) {
        return (Network)Shadow.newInstance(Network.class, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{netId});
    }

    public boolean isSocketBound(Socket socket) {
        return this.boundSockets.contains(socket);
    }

    public boolean isSocketBound(DatagramSocket socket) {
        return this.boundDatagramSockets.contains(socket);
    }

    public boolean isSocketBound(FileDescriptor fd) {
        return this.boundFileDescriptors.contains(fd);
    }

    public int boundSocketCount() {
        return this.boundSockets.size() + this.boundDatagramSockets.size() + this.boundFileDescriptors.size();
    }

    @Implementation
    protected void bindSocket(DatagramSocket socket) {
        this.boundDatagramSockets.add(socket);
    }

    @Implementation
    protected void bindSocket(Socket socket) {
        this.boundSockets.add(socket);
    }

    @Implementation(minSdk=23)
    protected void bindSocket(FileDescriptor fd) {
        this.boundFileDescriptors.add(fd);
    }

    @Implementation(minSdk=30)
    public int getNetId() {
        return (Integer)ReflectionHelpers.getField((Object)this.realObject, (String)"netId");
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactoryOverride = socketFactory;
    }

    @Implementation
    protected SocketFactory getSocketFactory() {
        if (this.socketFactoryOverride != null) {
            return this.socketFactoryOverride;
        }
        return ((NetworkReflector)Reflector.reflector(NetworkReflector.class, (Object)this.realObject)).getSocketFactory();
    }

    @ForType(value=Network.class)
    private static interface NetworkReflector {
        @Direct
        public SocketFactory getSocketFactory();
    }
}

