/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.Log;
import android.webkit.MimeTypeMap;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Deprecated
@Implements(value=MimeTypeMap.class)
public class ShadowMimeTypeMap {
    private static final String LOG_TAG = "ShadowMimeTypeMap";
    private final Map<String, String> extensionToMimeTypeMap = new HashMap<String, String>();
    private final Map<String, String> mimeTypeToExtensionMap = new HashMap<String, String>();
    private static volatile MimeTypeMap singleton = null;
    private static final Object singletonLock = new Object();
    @ReflectorObject
    private MimeTypeMapReflector mimeTypeMapReflector;
    private volatile boolean hasClearedMappings = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static MimeTypeMap getSingleton() {
        if (RuntimeEnvironment.getApiLevel() <= 30) {
            if (singleton == null) {
                Object object = singletonLock;
                synchronized (object) {
                    if (singleton == null) {
                        singleton = (MimeTypeMap)Shadow.newInstanceOf(MimeTypeMap.class);
                    }
                }
                ShadowMimeTypeMap shadowMimeTypeMap = (ShadowMimeTypeMap)Shadow.extract((Object)singleton);
                shadowMimeTypeMap.addExtensionMimeTypeMapping("3gp", "video/3gpp");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("3gpp", "video/3gpp");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("mp4", "video/mp4");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("jpg", "image/jpeg");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("jpeg", "image/jpeg");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("gif", "image/gif");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("png", "image/png");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("m4a", "audio/mpeg");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("mp3", "audio/mpeg");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("zip", "application/zip");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("txt", "text/plain");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("pdf", "application/pdf");
                shadowMimeTypeMap.addExtensionMimeTypeMapping("apk", "application/vnd.android.package-archive");
            }
            return singleton;
        }
        return ((MimeTypeMapReflector)Reflector.reflector(MimeTypeMapReflector.class)).getSingleton();
    }

    @Implementation
    protected String getMimeTypeFromExtension(String extension) {
        if (RuntimeEnvironment.getApiLevel() <= 30 || this.hasClearedMappings) {
            return this.extensionToMimeTypeMap.get(extension);
        }
        return this.mimeTypeMapReflector.getMimeTypeFromExtension(extension);
    }

    @Implementation
    protected String getExtensionFromMimeType(String mimeType) {
        if (RuntimeEnvironment.getApiLevel() <= 30 || this.hasClearedMappings) {
            return this.mimeTypeToExtensionMap.get(mimeType);
        }
        return this.mimeTypeMapReflector.getExtensionFromMimeType(mimeType);
    }

    public void addExtensionMimeTypeMapping(String extension, String mimeType) {
        if (RuntimeEnvironment.getApiLevel() <= 30 || this.hasClearedMappings) {
            this.extensionToMimeTypeMap.put(extension, mimeType);
            this.mimeTypeToExtensionMap.put(mimeType, extension);
        } else {
            Log.w((String)LOG_TAG, (String)String.format("Ignoring addExtensionMimeTypeMapping, API %d has full MimeTypeMap support", RuntimeEnvironment.getApiLevel()));
        }
    }

    public void clearMappings() {
        this.hasClearedMappings = true;
        this.extensionToMimeTypeMap.clear();
        this.mimeTypeToExtensionMap.clear();
    }

    @Implementation
    protected boolean hasExtension(String extension) {
        if (RuntimeEnvironment.getApiLevel() <= 30 || this.hasClearedMappings) {
            return this.extensionToMimeTypeMap.containsKey(extension);
        }
        return this.mimeTypeMapReflector.hasExtension(extension);
    }

    @Implementation
    protected boolean hasMimeType(String mimeType) {
        if (RuntimeEnvironment.getApiLevel() <= 30 || this.hasClearedMappings) {
            return this.mimeTypeToExtensionMap.containsKey(mimeType);
        }
        return this.mimeTypeMapReflector.hasMimeType(mimeType);
    }

    @ForType(value=MimeTypeMap.class)
    private static interface MimeTypeMapReflector {
        @Static
        @Direct
        public MimeTypeMap getSingleton();

        @Direct
        public String getMimeTypeFromExtension(String var1);

        @Direct
        public String getExtensionFromMimeType(String var1);

        @Direct
        public boolean hasExtension(String var1);

        @Direct
        public boolean hasMimeType(String var1);
    }
}

