/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.app.LocaleManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.LocaleList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=LocaleManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowLocaleManager {
    private static final Map<String, LocaleList> appLocales = new HashMap<String, LocaleList>();
    private static final Set<String> packagesInstalledByCaller = new HashSet<String>();
    private static boolean enforceInstallerCheck;

    @Resetter
    public static void reset() {
        appLocales.clear();
        packagesInstalledByCaller.clear();
        enforceInstallerCheck = false;
    }

    @Implementation
    @RequiresApi(api=24)
    protected LocaleList getApplicationLocales(String packageName) {
        if (enforceInstallerCheck && !packagesInstalledByCaller.contains(packageName)) {
            throw new SecurityException("Caller does not have permission to query locales for package " + packageName);
        }
        return appLocales.getOrDefault(packageName, LocaleList.getEmptyLocaleList());
    }

    @Implementation(maxSdk=33)
    protected void setApplicationLocales(String packageName, LocaleList locales) {
        appLocales.put(packageName, locales);
    }

    @Implementation(minSdk=34)
    protected void setApplicationLocales(String packageName, LocaleList locales, boolean fromDelegate) {
        this.setApplicationLocales(packageName, locales);
    }

    @Implementation
    @RequiresApi(api=24)
    protected LocaleList getSystemLocales() {
        Configuration configuration = Resources.getSystem().getConfiguration();
        if (configuration != null) {
            return configuration.getLocales();
        }
        return LocaleList.getEmptyLocaleList();
    }

    public void enforceInstallerCheck(boolean value) {
        enforceInstallerCheck = value;
    }

    public void setCallerAsInstallerForPackage(String packageName) {
        packagesInstalledByCaller.add(packageName);
    }
}

