/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Bundle;
import android.telecom.Connection;
import java.util.Optional;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Connection.class, minSdk=25)
public class ShadowConnection {
    @RealObject
    private Connection connection;
    private String mostRecentEvent;
    private boolean destroyed = false;

    @Implementation
    protected void sendConnectionEvent(String event, Bundle extras) {
        this.mostRecentEvent = event;
    }

    @Implementation
    protected void destroy() {
        this.destroyed = true;
        ((ConnectionReflector)Reflector.reflector(ConnectionReflector.class, (Object)this.connection)).destroy();
    }

    public Optional<String> getLastConnectionEvent() {
        return Optional.ofNullable(this.mostRecentEvent);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @ForType(value=Connection.class)
    static interface ConnectionReflector {
        @Direct
        public void destroy();
    }
}

