/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.telecom.CallRedirectionService;
import android.telecom.PhoneAccountHandle;
import com.android.internal.telecom.ICallRedirectionAdapter;
import com.android.internal.telecom.ICallRedirectionService;
import java.util.Optional;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=CallRedirectionService.class, minSdk=29)
public class ShadowCallRedirectionService {
    @RealObject
    CallRedirectionService callRedirectionService;
    @ReflectorObject
    protected CallRedirectionServiceReflector callRedirectionServiceReflector;
    private static Optional<RedirectionResult> lastRedirectionResult = Optional.empty();

    public void placeCall(Uri uri, PhoneAccountHandle phoneAccountHandle, boolean allowInteractiveResponse) {
        ICallRedirectionService.Stub binder = (ICallRedirectionService.Stub)this.callRedirectionService.onBind(new Intent());
        try {
            binder.placeCall((ICallRedirectionAdapter)ReflectionHelpers.createNullProxy(ICallRedirectionAdapter.class), uri, phoneAccountHandle, allowInteractiveResponse);
        }
        catch (RemoteException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Optional<RedirectionResult> getRedirectionResult() {
        return lastRedirectionResult;
    }

    private void setRedirectionResult(RedirectionResult redirectionResult) {
        lastRedirectionResult = Optional.of(redirectionResult);
    }

    @Resetter
    public static void reset() {
        lastRedirectionResult = Optional.empty();
    }

    @Implementation
    protected void redirectCall(Uri handle, PhoneAccountHandle initialPhoneAccount, boolean isInteractiveResponseAllowed) {
        this.setRedirectionResult(new RedirectionResult(new RedirectionResult.RedirectCallArgs(handle, initialPhoneAccount, isInteractiveResponseAllowed)));
        this.callRedirectionServiceReflector.redirectCall(handle, initialPhoneAccount, isInteractiveResponseAllowed);
    }

    @Implementation
    protected void placeCallUnmodified() {
        this.setRedirectionResult(new RedirectionResult(RedirectionResult.RedirectionResultType.PLACE_CALL_UNMODIFIED));
        this.callRedirectionServiceReflector.placeCallUnmodified();
    }

    @Implementation
    protected void cancelCall() {
        this.setRedirectionResult(new RedirectionResult(RedirectionResult.RedirectionResultType.CANCEL_CALL));
        this.callRedirectionServiceReflector.cancelCall();
    }

    public static class RedirectionResult {
        private final RedirectionResultType redirectionResultType;
        private final Optional<RedirectCallArgs> redirectCallArgsOptional;

        private RedirectionResult(RedirectionResultType redirectionResultType) {
            this.redirectionResultType = redirectionResultType;
            this.redirectCallArgsOptional = Optional.empty();
        }

        private RedirectionResult(RedirectCallArgs redirectCallArgs) {
            this.redirectionResultType = RedirectionResultType.REDIRECT_CALL;
            this.redirectCallArgsOptional = Optional.of(redirectCallArgs);
        }

        public RedirectionResultType getRedirectionResultType() {
            return this.redirectionResultType;
        }

        public Optional<RedirectCallArgs> getRedirectCallArgs() {
            return this.redirectCallArgsOptional;
        }

        public static enum RedirectionResultType {
            PLACE_CALL_UNMODIFIED,
            CANCEL_CALL,
            REDIRECT_CALL;

        }

        public static class RedirectCallArgs {
            private final Uri handle;
            private final PhoneAccountHandle targetPhoneAccount;
            private final boolean confirmFirst;

            private RedirectCallArgs(Uri handle, PhoneAccountHandle targetPhoneAccount, boolean confirmFirst) {
                this.handle = handle;
                this.targetPhoneAccount = targetPhoneAccount;
                this.confirmFirst = confirmFirst;
            }

            public Uri getHandle() {
                return this.handle;
            }

            public PhoneAccountHandle getTargetPhoneAccount() {
                return this.targetPhoneAccount;
            }

            public boolean getConfirmFirst() {
                return this.confirmFirst;
            }
        }
    }

    @ForType(value=CallRedirectionService.class)
    private static interface CallRedirectionServiceReflector {
        @Direct
        public void redirectCall(Uri var1, PhoneAccountHandle var2, boolean var3);

        @Direct
        public void placeCallUnmodified();

        @Direct
        public void cancelCall();
    }
}

