/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.Intent;
import android.os.Parcelable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothHeadset.class)
@NotThreadSafe
public class ShadowBluetoothHeadset {
    private final Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();
    private boolean allowsSendVendorSpecificResultCode = true;
    private BluetoothDevice activeBluetoothDevice;
    private boolean isVoiceRecognitionSupported = true;

    @Implementation
    protected List<BluetoothDevice> getConnectedDevices() {
        return this.bluetoothDevices.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 2).map(Map.Entry::getKey).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addConnectedDevice(BluetoothDevice device) {
        this.addDevice(device, 2);
    }

    public void addDevice(BluetoothDevice bluetoothDevice, int connectionState) {
        this.bluetoothDevices.put(bluetoothDevice, connectionState);
    }

    public void removeDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevices.remove(bluetoothDevice);
    }

    @Implementation
    protected int getConnectionState(BluetoothDevice device) {
        return this.bluetoothDevices.getOrDefault(device, 0);
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        ImmutableSet statesSet = ImmutableSet.copyOf((Collection)Ints.asList((int[])states));
        ArrayList<BluetoothDevice> matchingDevices = new ArrayList<BluetoothDevice>();
        for (Map.Entry<BluetoothDevice, Integer> entry : this.bluetoothDevices.entrySet()) {
            if (!statesSet.contains((Object)entry.getValue())) continue;
            matchingDevices.add(entry.getKey());
        }
        return ImmutableList.copyOf(matchingDevices);
    }

    @Implementation
    protected boolean connect(BluetoothDevice device) {
        if (this.getConnectedDevices().contains(device)) {
            return false;
        }
        this.addConnectedDevice(device);
        return true;
    }

    @Implementation
    protected boolean disconnect(BluetoothDevice device) {
        if (!this.getConnectedDevices().contains(device)) {
            return false;
        }
        this.removeDevice(device);
        return true;
    }

    @Implementation
    protected boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        if (bluetoothDevice == null || !this.getConnectedDevices().contains(bluetoothDevice)) {
            return false;
        }
        if (this.activeBluetoothDevice != null) {
            this.stopVoiceRecognition(this.activeBluetoothDevice);
            return false;
        }
        ShadowBluetoothHeadset.sendAudioStateChangedBroadcast(11, bluetoothDevice);
        ShadowBluetoothHeadset.sendAudioStateChangedBroadcast(12, bluetoothDevice);
        this.activeBluetoothDevice = bluetoothDevice;
        return true;
    }

    @Implementation
    protected boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        boolean isDeviceActive = this.isDeviceActive(bluetoothDevice);
        this.activeBluetoothDevice = null;
        if (isDeviceActive) {
            ShadowBluetoothHeadset.sendAudioStateChangedBroadcast(10, bluetoothDevice);
        }
        return isDeviceActive;
    }

    @Implementation
    protected boolean isAudioConnected(BluetoothDevice bluetoothDevice) {
        return this.isDeviceActive(bluetoothDevice);
    }

    @Implementation
    protected boolean sendVendorSpecificResultCode(BluetoothDevice device, String command, String arg) {
        if (command == null) {
            throw new IllegalArgumentException("Command cannot be null");
        }
        return this.allowsSendVendorSpecificResultCode && this.getConnectedDevices().contains(device);
    }

    @Nullable
    @Implementation(minSdk=28)
    protected BluetoothDevice getActiveDevice() {
        return this.activeBluetoothDevice;
    }

    @Implementation(minSdk=28)
    protected boolean setActiveDevice(@Nullable BluetoothDevice bluetoothDevice) {
        this.activeBluetoothDevice = bluetoothDevice;
        Intent intent = new Intent("android.bluetooth.headset.profile.action.ACTIVE_DEVICE_CHANGED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)this.activeBluetoothDevice);
        RuntimeEnvironment.getApplication().sendBroadcast(intent);
        return true;
    }

    public void setVoiceRecognitionSupported(boolean supported) {
        this.isVoiceRecognitionSupported = supported;
    }

    @Implementation(minSdk=31)
    protected boolean isVoiceRecognitionSupported(BluetoothDevice device) {
        return this.isVoiceRecognitionSupported;
    }

    public void setAllowsSendVendorSpecificResultCode(boolean allowsSendVendorSpecificResultCode) {
        this.allowsSendVendorSpecificResultCode = allowsSendVendorSpecificResultCode;
    }

    private boolean isDeviceActive(BluetoothDevice bluetoothDevice) {
        return Objects.equals(this.activeBluetoothDevice, bluetoothDevice);
    }

    private static void sendAudioStateChangedBroadcast(int bluetoothProfileExtraState, BluetoothDevice bluetoothDevice) {
        Intent connectedIntent = new Intent("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED").putExtra("android.bluetooth.profile.extra.STATE", bluetoothProfileExtraState).putExtra("android.bluetooth.device.extra.DEVICE", (Parcelable)bluetoothDevice);
        RuntimeEnvironment.getApplication().sendBroadcast(connectedIntent);
    }
}

