/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowLegacyBitmap;
import org.robolectric.shadows.ShadowNativeBitmap;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Bitmap.class, shadowPicker=Picker.class)
public abstract class ShadowBitmap {
    @RealObject
    protected Bitmap realBitmap;

    public static String visualize(Bitmap bitmap) {
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        return shadowBitmap.getDescription();
    }

    public abstract Bitmap getCreatedFromBitmap();

    public abstract int getCreatedFromResId();

    public abstract String getCreatedFromPath();

    public abstract InputStream getCreatedFromStream();

    public abstract byte[] getCreatedFromBytes();

    public abstract int getCreatedFromX();

    public abstract int getCreatedFromY();

    public abstract int getCreatedFromWidth();

    public abstract int getCreatedFromHeight();

    public abstract int[] getCreatedFromColors();

    public abstract Matrix getCreatedFromMatrix();

    public abstract boolean getCreatedFromFilter();

    public abstract void setMutable(boolean var1);

    public abstract void appendDescription(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    @Implementation(minSdk=34)
    protected void setGainmap(@ClassName(value="android.graphics.Gainmap") @ClassName(value="android.graphics.Gainmap") Object gainmap) {
        Preconditions.checkState((!this.realBitmap.isRecycled() ? 1 : 0) != 0, (Object)"Bitmap is recycled");
        ((BitmapReflector)Reflector.reflector(BitmapReflector.class, (Object)this.realBitmap)).setGainmap(gainmap);
    }

    @Implementation(minSdk=34)
    protected boolean hasGainmap() {
        Preconditions.checkState((!this.realBitmap.isRecycled() ? 1 : 0) != 0, (Object)"Bitmap is recycled");
        return ((BitmapReflector)Reflector.reflector(BitmapReflector.class, (Object)this.realBitmap)).getGainmap() != null;
    }

    @ForType(value=Bitmap.class)
    protected static interface BitmapReflector {
        public void checkRecycled(String var1);

        @Accessor(value="mNativePtr")
        public long getNativePtr();

        @Accessor(value="mGainmap")
        public void setGainmap(Object var1);

        @Direct
        public Object getGainmap();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowLegacyBitmap.class, ShadowNativeBitmap.class);
        }
    }
}

