/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.wearable.WearableSensingManager;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.SharedMemory;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=WearableSensingManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowWearableSensingManager {
    @WearableSensingManager.StatusCode
    private Integer provideDataStreamResult = 1;
    @WearableSensingManager.StatusCode
    private Integer provideDataResult = 1;
    private final ArrayList<PersistableBundle> dataBundleList = new ArrayList();
    private final ArrayList<SharedMemory> sharedMemoryList = new ArrayList();
    private ParcelFileDescriptor lastParcelFileDescriptor;

    @Implementation
    protected void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, Executor executor, Consumer<Integer> statusConsumer) {
        this.lastParcelFileDescriptor = parcelFileDescriptor;
        executor.execute(() -> statusConsumer.accept(this.provideDataStreamResult));
    }

    @Implementation
    protected void provideData(PersistableBundle data, SharedMemory sharedMemory, Executor executor, @WearableSensingManager.StatusCode Consumer<Integer> statusConsumer) {
        this.dataBundleList.add(data);
        this.sharedMemoryList.add(sharedMemory);
        executor.execute(() -> statusConsumer.accept(this.provideDataResult));
    }

    public void setProvideDataStreamResult(@WearableSensingManager.StatusCode Integer provideDataStreamResult) {
        this.provideDataStreamResult = provideDataStreamResult;
    }

    public void setProvideDataResult(@WearableSensingManager.StatusCode Integer provideDataResult) {
        this.provideDataResult = provideDataResult;
    }

    public ParcelFileDescriptor getLastParcelFileDescriptor() {
        return this.lastParcelFileDescriptor;
    }

    public PersistableBundle getLastDataBundle() {
        return this.dataBundleList.isEmpty() ? null : (PersistableBundle)Iterables.getLast(this.dataBundleList);
    }

    public List<PersistableBundle> getAllDataBundles() {
        return new ArrayList<PersistableBundle>(this.dataBundleList);
    }

    public SharedMemory getLastSharedMemory() {
        return this.sharedMemoryList.isEmpty() ? null : (SharedMemory)Iterables.getLast(this.sharedMemoryList);
    }

    public List<SharedMemory> getAllSharedMemories() {
        return new ArrayList<SharedMemory>(this.sharedMemoryList);
    }
}

