/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.uwb.AdapterState;
import android.uwb.RangingSession;
import android.uwb.StateChangeReason;
import android.uwb.UwbManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowRangingSession;

@Implements(value=UwbManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowUwbManager {
    private UwbManager.AdapterStateCallback callback;
    private int adapterState = 1;
    private int stateChangedReason = 2;
    private PersistableBundle specificationInfo = new PersistableBundle();
    private List<PersistableBundle> chipInfos = new ArrayList<PersistableBundle>();
    private ShadowRangingSession.Adapter adapter = new ShadowRangingSession.Adapter(){

        @Override
        public void onOpen(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
        }

        @Override
        public void onStart(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
        }

        @Override
        public void onReconfigure(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
        }

        @Override
        public void onStop(RangingSession session, RangingSession.Callback callback) {
        }

        @Override
        public void onClose(RangingSession session, RangingSession.Callback callback) {
        }
    };

    @Implementation
    protected void registerAdapterStateCallback(Executor executor, UwbManager.AdapterStateCallback callback) {
        this.callback = callback;
        callback.onStateChanged(this.adapterState, this.stateChangedReason);
    }

    public void simulateAdapterStateChange(@AdapterState int state, @StateChangeReason int reason) {
        if (this.callback == null) {
            throw new IllegalArgumentException("AdapterStateCallback should not be null");
        }
        this.adapterState = state;
        this.stateChangedReason = reason;
        this.callback.onStateChanged(state, reason);
    }

    @Implementation
    protected PersistableBundle getSpecificationInfo() {
        return this.specificationInfo;
    }

    @Implementation
    protected CancellationSignal openRangingSession(PersistableBundle params, Executor executor, RangingSession.Callback callback) {
        if (!this.isUwbEnabled()) {
            throw new IllegalStateException("Uwb is not enabled");
        }
        RangingSession session = ShadowRangingSession.newInstance(executor, callback, this.adapter);
        CancellationSignal cancellationSignal = new CancellationSignal();
        cancellationSignal.setOnCancelListener(() -> ((RangingSession)session).close());
        ((ShadowRangingSession)Shadow.extract((Object)session)).open(params);
        return cancellationSignal;
    }

    public void setUwbAdapter(ShadowRangingSession.Adapter adapter) {
        this.adapter = adapter;
    }

    public void setSpecificationInfo(PersistableBundle specificationInfo) {
        this.specificationInfo = new PersistableBundle(specificationInfo);
    }

    @Implementation(minSdk=33)
    protected CancellationSignal openRangingSession(PersistableBundle params, Executor executor, RangingSession.Callback callback, String chipId) {
        return this.openRangingSession(params, executor, callback);
    }

    @Implementation(minSdk=33)
    protected boolean isUwbEnabled() {
        return this.adapterState != 0;
    }

    @Implementation
    protected void setUwbEnabled(boolean enabled) {
        boolean stateChanged = false;
        if (enabled && this.adapterState == 0) {
            this.adapterState = 1;
            stateChanged = true;
        } else if (!enabled && this.adapterState != 0) {
            this.adapterState = 0;
            stateChanged = true;
        }
        if (this.callback != null && stateChanged) {
            this.callback.onStateChanged(this.adapterState, 2);
        }
    }

    @Implementation(minSdk=33)
    protected List<PersistableBundle> getChipInfos() {
        return ImmutableList.copyOf(this.chipInfos);
    }

    public void setChipInfos(List<PersistableBundle> chipInfos) {
        this.chipInfos = new ArrayList<PersistableBundle>(chipInfos);
    }
}

