/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import java.lang.ref.WeakReference;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.ImageReaderNatives;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowImageReader;
import org.robolectric.shadows.ShadowNativeSurface;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ImageReader.class, minSdk=28, looseSignatures=true, isInAndroidSdk=false, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeImageReader {
    @RealObject
    ImageReader realImageReader;
    @ReflectorObject
    private ImageReaderReflector imageReaderReflector;
    private final ImageReaderNatives natives = new ImageReaderNatives();

    @Implementation(minSdk=35)
    protected static void __staticInitializer__() {
    }

    @Implementation(maxSdk=32)
    protected synchronized void nativeInit(Object weakSelf, int w, int h, int fmt, int maxImgs, long consumerUsage) {
        this.natives.nativeInit(weakSelf, w, h, fmt, maxImgs, consumerUsage);
        this.imageReaderReflector.setMemberNativeContext(this.natives.mNativeContext);
    }

    @Implementation(minSdk=33, maxSdk=34)
    protected synchronized void nativeInit(Object weakSelf, int w, int h, int maxImgs, long consumerUsage, int hardwareBufferFormat, int dataSpace) {
        int fmt = hardwareBufferFormat;
        this.natives.nativeInit(weakSelf, w, h, fmt, maxImgs, consumerUsage);
        this.imageReaderReflector.setMemberNativeContext(this.natives.mNativeContext);
    }

    @Implementation(maxSdk=34)
    protected void nativeClose() {
        this.natives.nativeClose();
    }

    @Implementation(maxSdk=34)
    protected void nativeReleaseImage(Image i) {
        this.natives.nativeReleaseImage(i);
    }

    @Implementation(maxSdk=34)
    protected Surface nativeGetSurface() {
        return this.natives.nativeGetSurface();
    }

    @Implementation(maxSdk=32)
    protected int nativeDetachImage(Image i) {
        return this.natives.nativeDetachImage(i);
    }

    @Implementation(maxSdk=34)
    protected void nativeDiscardFreeBuffers() {
        this.natives.nativeDiscardFreeBuffers();
    }

    @Implementation
    protected Surface getSurface() {
        Surface surface = ((ImageReaderReflector)Reflector.reflector(ImageReaderReflector.class, (Object)this.realImageReader)).getSurface();
        ShadowNativeSurface shadowNativeSurface = (ShadowNativeSurface)Shadow.extract((Object)surface);
        shadowNativeSurface.setContainerImageReader(this.realImageReader);
        return surface;
    }

    @Implementation(maxSdk=32)
    protected int nativeImageSetup(Image i) {
        return this.natives.nativeImageSetup(i);
    }

    @Implementation(minSdk=33, maxSdk=33)
    protected int nativeImageSetup(Image i, boolean legacyValidateImageFormat) {
        return this.natives.nativeImageSetup(i);
    }

    @Implementation(minSdk=34, maxSdk=34)
    protected Object nativeImageSetup(Object i) {
        return this.natives.nativeImageSetup((Image)i);
    }

    @Implementation(maxSdk=34)
    protected static void nativeClassInit() {
        DefaultNativeRuntimeLoader.injectAndLoad();
        ImageReaderNatives.nativeClassInit();
    }

    static void triggerOnImageAvailableCallbacks(ImageReader imageReader) {
        ((ImageReaderReflector)Reflector.reflector(ImageReaderReflector.class)).postEventFromNative(new WeakReference<ImageReader>(imageReader));
    }

    @ForType(value=ImageReader.class)
    static interface ImageReaderReflector {
        @Accessor(value="mNativeContext")
        public void setMemberNativeContext(long var1);

        @Direct
        public Surface getSurface();

        @Static
        public void postEventFromNative(Object var1);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowImageReader.class, ShadowNativeImageReader.class);
        }

        @Override
        protected int getMinApiLevel() {
            return 28;
        }
    }
}

