/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.app.JobSchedulerImpl;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.app.job.JobWorkItem;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=JobScheduler.class)
public abstract class ShadowJobScheduler {
    @Implementation
    protected abstract int schedule(JobInfo var1);

    @Implementation(minSdk=24)
    @SystemApi
    @HiddenApi
    protected abstract int scheduleAsPackage(JobInfo var1, String var2, int var3, String var4);

    @Implementation
    protected abstract void cancel(int var1);

    @Implementation
    protected abstract void cancelAll();

    @Implementation
    protected abstract List<JobInfo> getAllPendingJobs();

    @Implementation(minSdk=24)
    @HiddenApi
    public abstract JobInfo getPendingJob(int var1);

    @Implementation(minSdk=26)
    protected abstract int enqueue(JobInfo var1, JobWorkItem var2);

    public abstract void failOnJob(int var1);

    public abstract void failExpeditedJob(boolean var1);

    @Implements(value=JobSchedulerImpl.class, isInAndroidSdk=false)
    public static class ShadowJobSchedulerImpl
    extends ShadowJobScheduler {
        private final Map<Integer, JobInfo> scheduledJobs = Collections.synchronizedMap(new LinkedHashMap());
        private final Set<Integer> jobsToFail = Collections.synchronizedSet(new HashSet());
        private boolean failExpeditedJobEnabled;

        @Override
        @Implementation
        public int schedule(JobInfo job) {
            if (this.jobsToFail.contains(job.getId())) {
                return 0;
            }
            if (Build.VERSION.SDK_INT >= 31 && this.failExpeditedJobEnabled && job.isExpedited()) {
                return 0;
            }
            this.scheduledJobs.put(job.getId(), job);
            return 1;
        }

        @Override
        @Implementation(minSdk=24)
        @SystemApi
        @HiddenApi
        protected int scheduleAsPackage(JobInfo job, String packageName, int userId, String tag) {
            return this.schedule(job);
        }

        @Override
        @Implementation
        public void cancel(int jobId) {
            this.scheduledJobs.remove(jobId);
        }

        @Override
        @Implementation
        public void cancelAll() {
            this.scheduledJobs.clear();
        }

        @Override
        @Implementation
        public List<JobInfo> getAllPendingJobs() {
            return new ArrayList<JobInfo>(this.scheduledJobs.values());
        }

        @Override
        @Implementation(minSdk=24)
        public JobInfo getPendingJob(int jobId) {
            return this.scheduledJobs.get(jobId);
        }

        @Override
        @Implementation(minSdk=26)
        public int enqueue(JobInfo job, JobWorkItem work) {
            return this.schedule(job);
        }

        @Override
        public void failOnJob(int jobId) {
            this.jobsToFail.add(jobId);
        }

        @Override
        @TargetApi(value=31)
        public void failExpeditedJob(boolean enabled) {
            this.failExpeditedJobEnabled = enabled;
        }
    }
}

