/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.input.InputManager;
import android.os.Build;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VerifiedKeyEvent;
import android.view.VerifiedMotionEvent;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=InputManager.class, looseSignatures=true)
public class ShadowInputManager {
    @RealObject
    InputManager realInputManager;

    @Implementation
    protected boolean injectInputEvent(InputEvent event, int mode) {
        return true;
    }

    @Implementation
    protected boolean[] deviceHasKeys(int id2, int[] keyCodes) {
        return new boolean[keyCodes.length];
    }

    @Implementation
    protected int[] getInputDeviceIds() {
        if (!ReflectionHelpers.hasField(InputManager.class, (String)"mInputDevices")) {
            return new int[0];
        }
        SparseArray<InputDevice> inputDevices = this.getInputDevices();
        if (inputDevices == null) {
            return new int[0];
        }
        int[] ids = new int[inputDevices.size()];
        for (int i = 0; i < inputDevices.size(); ++i) {
            ids[i] = ((InputDevice)inputDevices.get(i)).getId();
        }
        return ids;
    }

    @Implementation(maxSdk=33)
    protected void populateInputDevicesLocked() throws ClassNotFoundException {
        if (ReflectionHelpers.getField((Object)this.realInputManager, (String)"mInputDevicesChangedListener") == null) {
            ReflectionHelpers.setField((Object)this.realInputManager, (String)"mInputDevicesChangedListener", (Object)ReflectionHelpers.callConstructor(Class.forName("android.hardware.input.InputManager$InputDevicesChangedListener"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        }
        if (this.getInputDevices() == null) {
            int[] ids = this.realInputManager.getInputDeviceIds();
            SparseArray inputDevices = new SparseArray();
            for (int i = 0; i < ids.length; ++i) {
                inputDevices.put(ids[i], null);
            }
            this.setInputDevices((SparseArray<InputDevice>)inputDevices);
        }
    }

    private SparseArray<InputDevice> getInputDevices() {
        return ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).getInputDevices();
    }

    private void setInputDevices(SparseArray<InputDevice> devices) {
        ((InputManagerReflector)Reflector.reflector(InputManagerReflector.class, (Object)this.realInputManager)).setInputDevices(devices);
    }

    @Implementation(minSdk=30)
    protected Object verifyInputEvent(Object inputEvent) {
        if (inputEvent instanceof MotionEvent) {
            MotionEvent motionEvent = (MotionEvent)inputEvent;
            return new VerifiedMotionEvent(motionEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getEventTime()), motionEvent.getSource(), motionEvent.getDisplayId(), motionEvent.getRawX(), motionEvent.getRawY(), motionEvent.getActionMasked(), TimeUnit.MILLISECONDS.toNanos(motionEvent.getDownTime()), motionEvent.getFlags(), motionEvent.getMetaState(), motionEvent.getButtonState());
        }
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            return new VerifiedKeyEvent(keyEvent.getDeviceId(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getEventTime()), keyEvent.getSource(), keyEvent.getDisplayId(), keyEvent.getAction(), TimeUnit.MILLISECONDS.toNanos(keyEvent.getDownTime()), keyEvent.getFlags(), keyEvent.getKeyCode(), keyEvent.getScanCode(), keyEvent.getMetaState(), keyEvent.getRepeatCount());
        }
        throw new IllegalArgumentException("unknown input event: " + inputEvent.getClass().getName());
    }

    @Resetter
    public static void reset() {
        if (Build.VERSION.SDK_INT < 34) {
            ReflectionHelpers.setStaticField(InputManager.class, (String)"sInstance", null);
        }
    }

    @ForType(value=InputManager.class)
    static interface InputManagerReflector {
        @Accessor(value="mInputDevices")
        public SparseArray<InputDevice> getInputDevices();

        @Accessor(value="mInputDevices")
        public void setInputDevices(SparseArray<InputDevice> var1);
    }
}

