/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiSsid;
import java.net.InetAddress;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;
import org.robolectric.util.reflector.WithType;

@Implements(value=WifiInfo.class)
public class ShadowWifiInfo {
    @RealObject
    WifiInfo realObject;

    public static WifiInfo newInstance() {
        return (WifiInfo)ReflectionHelpers.callConstructor(WifiInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    public void setInetAddress(InetAddress address) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setInetAddress(address);
    }

    @Implementation
    public void setMacAddress(String newMacAddress) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setMacAddress(newMacAddress);
    }

    @Implementation(maxSdk=16)
    public void setSSID(String ssid) {
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setSSID(ssid);
        } else {
            ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setSSID(ShadowWifiInfo.getWifiSsid(ssid));
        }
    }

    private static Object getWifiSsid(String ssid) {
        WifiSsid wifiSsid = ssid.startsWith("0x") ? ((WifiSsidReflector)Reflector.reflector(WifiSsidReflector.class)).createFromHex(ssid) : ((WifiSsidReflector)Reflector.reflector(WifiSsidReflector.class)).createFromAsciiEncoded(ssid);
        return wifiSsid;
    }

    @Implementation
    public void setBSSID(String bssid) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setBSSID(bssid);
    }

    @Implementation
    public void setSupplicantState(SupplicantState state) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setSupplicantState(state);
    }

    @Implementation
    public void setRssi(int rssi) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setRssi(rssi);
    }

    @Implementation
    public void setLinkSpeed(int linkSpeed) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setLinkSpeed(linkSpeed);
    }

    @Implementation(minSdk=21)
    public void setFrequency(int frequency) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setFrequency(frequency);
    }

    @Implementation
    public void setNetworkId(int id2) {
        ((WifiInfoReflector)Reflector.reflector(WifiInfoReflector.class, (Object)this.realObject)).setNetworkId(id2);
    }

    @ForType(value=WifiInfo.class)
    static interface WifiInfoReflector {
        @Direct
        public void setInetAddress(InetAddress var1);

        @Direct
        public void setMacAddress(String var1);

        @Direct
        public void setSSID(String var1);

        public void setSSID(@WithType(value="android.net.wifi.WifiSsid") Object var1);

        @Direct
        public void setBSSID(String var1);

        @Direct
        public void setSupplicantState(SupplicantState var1);

        @Direct
        public void setRssi(int var1);

        @Direct
        public void setLinkSpeed(int var1);

        @Direct
        public void setNetworkId(int var1);

        @Direct
        public void setFrequency(int var1);
    }

    @ForType(value=WifiSsid.class)
    static interface WifiSsidReflector {
        @Static
        public WifiSsid createFromHex(String var1);

        @Static
        public WifiSsid createFromAsciiEncoded(String var1);
    }
}

