/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.vcn.VcnConfig;
import android.net.vcn.VcnManager;
import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=VcnManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowVcnManager {
    private final Map<VcnManager.VcnStatusCallback, VcnStatusCallbackInfo> callbacks = new HashMap<VcnManager.VcnStatusCallback, VcnStatusCallbackInfo>();
    private final Map<ParcelUuid, VcnConfig> configs = new HashMap<ParcelUuid, VcnConfig>();
    private int currentVcnStatus = 0;

    @Implementation
    protected void registerVcnStatusCallback(ParcelUuid subGroup, Executor executor, VcnManager.VcnStatusCallback callback) {
        this.callbacks.put(callback, new VcnStatusCallbackInfo(executor, subGroup));
    }

    @Implementation
    protected void unregisterVcnStatusCallback(VcnManager.VcnStatusCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("VcnStatusCallback == null");
        }
        if (!this.callbacks.containsKey(callback)) {
            throw new IllegalArgumentException("VcnStatusCallback not registered");
        }
        this.callbacks.remove(callback);
    }

    @Implementation
    protected void setVcnConfig(ParcelUuid subGroup, VcnConfig config) {
        this.configs.put(subGroup, config);
    }

    @Implementation
    protected void clearVcnConfig(ParcelUuid subGroup) {
        if (subGroup == null) {
            throw new IllegalArgumentException("subGroup == null");
        }
        this.configs.remove(subGroup);
    }

    @Implementation
    protected List<ParcelUuid> getConfiguredSubscriptionGroups() {
        return new ArrayList<ParcelUuid>(this.configs.keySet());
    }

    public Set<VcnManager.VcnStatusCallback> getRegisteredVcnStatusCallbacks() {
        return Collections.unmodifiableSet(this.callbacks.keySet());
    }

    public void setStatus(int statusCode) {
        this.currentVcnStatus = statusCode;
        for (VcnManager.VcnStatusCallback callback : this.callbacks.keySet()) {
            this.callbacks.get(callback).executor.execute(() -> callback.onStatusChanged(this.currentVcnStatus));
        }
    }

    public void setGatewayConnectionError(String gatewayConnectionName, int errorCode, Throwable detail) {
        for (VcnManager.VcnStatusCallback callback : this.callbacks.keySet()) {
            this.callbacks.get(callback).executor.execute(() -> callback.onGatewayConnectionError(gatewayConnectionName, errorCode, detail));
        }
    }

    public ParcelUuid getRegisteredSubscriptionGroup(VcnManager.VcnStatusCallback callback) {
        return this.callbacks.get(callback).subGroup;
    }

    private static final class VcnStatusCallbackInfo {
        private final Executor executor;
        private final ParcelUuid subGroup;

        private VcnStatusCallbackInfo(Executor executor, ParcelUuid subGroup) {
            this.executor = executor;
            this.subGroup = subGroup;
        }
    }
}

