/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.MessageQueue;
import android.os.SystemClock;
import android.view.DisplayEventReceiver;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.time.Duration;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowChoreographer;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.shadows.ShadowSystemClock;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(className="android.view.DisplayEventReceiver", isInAndroidSdk=false, looseSignatures=true)
public class ShadowDisplayEventReceiver {
    private static NativeObjRegistry<NativeDisplayEventReceiver> nativeObjRegistry = new NativeObjRegistry(NativeDisplayEventReceiver.class);
    @RealObject
    protected DisplayEventReceiver realReceiver;
    @ReflectorObject
    private DisplayEventReceiverReflector displayEventReceiverReflector;

    @Implementation(minSdk=26, maxSdk=29)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=23, maxSdk=25)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=20, maxSdk=22)
    protected static long nativeInit(DisplayEventReceiver receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>(receiver)));
    }

    @Implementation(maxSdk=19)
    protected static int nativeInit(Object receiver, Object msgQueue) {
        return (int)nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>((DisplayEventReceiver)receiver)));
    }

    @Implementation(minSdk=30, maxSdk=33)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource, int configChanged) {
        return ShadowDisplayEventReceiver.nativeInit(receiver, msgQueue);
    }

    @Implementation(minSdk=34)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, WeakReference<Object> vsyncEventData, MessageQueue msgQueue, int vsyncSource, int eventRegistration, long layerHandle) {
        return ShadowDisplayEventReceiver.nativeInit(receiver, msgQueue);
    }

    @Implementation(minSdk=20, maxSdk=33)
    protected static void nativeDispose(long receiverPtr) {
        NativeDisplayEventReceiver receiver = (NativeDisplayEventReceiver)nativeObjRegistry.unregister(receiverPtr);
        if (receiver != null) {
            receiver.dispose();
        }
    }

    @Implementation(maxSdk=19)
    protected static void nativeDispose(int receiverPtr) {
        NativeDisplayEventReceiver receiver = (NativeDisplayEventReceiver)nativeObjRegistry.unregister((long)receiverPtr);
        if (receiver != null) {
            receiver.dispose();
        }
    }

    @Implementation(minSdk=20)
    protected static void nativeScheduleVsync(long receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(receiverPtr)).scheduleVsync();
    }

    @Implementation(maxSdk=19)
    protected static void nativeScheduleVsync(int receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject((long)receiverPtr)).scheduleVsync();
    }

    @Implementation(minSdk=17, maxSdk=30)
    protected void dispose(boolean finalized) {
        CloseGuard closeGuard = this.displayEventReceiverReflector.getCloseGuard();
        if (closeGuard != null) {
            closeGuard.close();
        }
        this.displayEventReceiverReflector.dispose(finalized);
    }

    protected void onVsync() {
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 1);
        } else if (RuntimeEnvironment.getApiLevel() < 29) {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0, 1);
        } else if (RuntimeEnvironment.getApiLevel() < 31) {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0L, 1);
        } else if (RuntimeEnvironment.getApiLevel() < 33) {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0L, 1, ShadowDisplayEventReceiver.newVsyncEventData());
        } else {
            this.displayEventReceiverReflector.onVsync(ShadowSystem.nanoTime(), 0L, 1, ShadowDisplayEventReceiver.newVsyncEventData());
        }
    }

    @Implementation(minSdk=33)
    protected Object getLatestVsyncEventData() {
        return ShadowDisplayEventReceiver.newVsyncEventData();
    }

    private static Object newVsyncEventData() {
        VsyncEventDataReflector vsyncEventDataReflector = (VsyncEventDataReflector)Reflector.reflector(VsyncEventDataReflector.class);
        if (RuntimeEnvironment.getApiLevel() < 33) {
            return vsyncEventDataReflector.newVsyncEventData(1L, 10L, 1L);
        }
        try {
            Class<?> frameTimelineClass = Class.forName("android.view.DisplayEventReceiver$VsyncEventData$FrameTimeline");
            int timelineArrayLength = RuntimeEnvironment.getApiLevel() == 33 ? 1 : 7;
            FrameTimelineReflector frameTimelineReflector = (FrameTimelineReflector)Reflector.reflector(FrameTimelineReflector.class);
            Object timelineArray = Array.newInstance(frameTimelineClass, timelineArrayLength);
            for (int i = 0; i < timelineArrayLength; ++i) {
                Array.set(timelineArray, i, frameTimelineReflector.newFrameTimeline(1L, 1L, 10L));
            }
            if (RuntimeEnvironment.getApiLevel() <= 33) {
                return vsyncEventDataReflector.newVsyncEventData(timelineArray, 0, 1L);
            }
            return vsyncEventDataReflector.newVsyncEventData(timelineArray, 0, timelineArrayLength, 1L);
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Unable to construct VsyncEventData", e);
        }
    }

    private static class NativeDisplayEventReceiver {
        private final WeakReference<DisplayEventReceiver> receiverRef;
        private final ShadowPausedSystemClock.Listener clockListener = this::onClockAdvanced;
        @GuardedBy(value="this")
        private long nextVsyncTime = 0L;

        public NativeDisplayEventReceiver(WeakReference<DisplayEventReceiver> receiverRef) {
            this.receiverRef = receiverRef;
            ShadowPausedSystemClock.addListener(this.clockListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onClockAdvanced() {
            NativeDisplayEventReceiver nativeDisplayEventReceiver = this;
            synchronized (nativeDisplayEventReceiver) {
                if (this.nextVsyncTime == 0L || ShadowPausedSystemClock.uptimeMillis() < this.nextVsyncTime) {
                    return;
                }
                this.nextVsyncTime = 0L;
            }
            this.doVsync();
        }

        void dispose() {
            ShadowPausedSystemClock.removeListener(this.clockListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleVsync() {
            Duration frameDelay = ShadowChoreographer.getFrameDelay();
            if (ShadowChoreographer.isPaused()) {
                NativeDisplayEventReceiver nativeDisplayEventReceiver = this;
                synchronized (nativeDisplayEventReceiver) {
                    this.nextVsyncTime = SystemClock.uptimeMillis() + frameDelay.toMillis();
                }
            } else {
                ShadowSystemClock.advanceBy(frameDelay);
                this.doVsync();
            }
        }

        private void doVsync() {
            DisplayEventReceiver receiver = (DisplayEventReceiver)this.receiverRef.get();
            if (receiver != null) {
                ShadowDisplayEventReceiver shadowReceiver = (ShadowDisplayEventReceiver)Shadow.extract((Object)receiver);
                shadowReceiver.onVsync();
            }
        }
    }

    @ForType(value=DisplayEventReceiver.class)
    protected static interface DisplayEventReceiverReflector {
        @Direct
        public void dispose(boolean var1);

        public void onVsync(long var1, int var3);

        public void onVsync(long var1, int var3, int var4);

        public void onVsync(long var1, long var3, int var5);

        public void onVsync(long var1, long var3, int var5, @WithType(value="android.view.DisplayEventReceiver$VsyncEventData") Object var6);

        @Accessor(value="mCloseGuard")
        public CloseGuard getCloseGuard();

        @Accessor(value="mReceiverPtr")
        public long getReceiverPtr();
    }

    @ForType(className="android.view.DisplayEventReceiver$VsyncEventData")
    static interface VsyncEventDataReflector {
        @Constructor
        public Object newVsyncEventData(long var1, long var3, long var5);

        @Constructor
        public Object newVsyncEventData(@WithType(value="[Landroid.view.DisplayEventReceiver$VsyncEventData$FrameTimeline;") Object var1, int var2, long var3);

        @Constructor
        public Object newVsyncEventData(@WithType(value="[Landroid.view.DisplayEventReceiver$VsyncEventData$FrameTimeline;") Object var1, int var2, int var3, long var4);
    }

    @ForType(className="android.view.DisplayEventReceiver$VsyncEventData$FrameTimeline")
    static interface FrameTimelineReflector {
        @Constructor
        public Object newFrameTimeline(long var1, long var3, long var5);
    }
}

