/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubManager;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.NanoAppInstanceInfo;
import android.hardware.location.NanoAppState;
import android.os.Build;
import androidx.annotation.Nullable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ContextHubManager.class, minSdk=24, isInAndroidSdk=false, looseSignatures=true)
public class ShadowContextHubManager {
    private static final List<ContextHubInfo> contextHubInfoList = new ArrayList<ContextHubInfo>();
    private static final List<ContextHubClient> contextHubClientWithPendingIntentList = new ArrayList<ContextHubClient>();
    private final Map<Integer, NanoAppInstanceInfo> nanoAppUidToInfo = new ConcurrentHashMap<Integer, NanoAppInstanceInfo>();
    private final Multimap<ContextHubInfo, Integer> contextHubToNanoappUid = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final HashMultimap<String, ContextHubClient> attributionTagToClientMap = HashMultimap.create();

    public void addNanoApp(ContextHubInfo info, int nanoAppUid, long nanoAppId, int nanoAppVersion) {
        this.contextHubToNanoappUid.put((Object)info, (Object)nanoAppUid);
        NanoAppInstanceInfo instanceInfo = this.createInstanceInfo(info, nanoAppUid, nanoAppId, nanoAppVersion);
        this.nanoAppUidToInfo.put(nanoAppUid, instanceInfo);
    }

    public NanoAppInstanceInfo createInstanceInfo(ContextHubInfo info, int nanoAppUid, long nanoAppId, int nanoAppVersion) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new NanoAppInstanceInfo(nanoAppUid, nanoAppId, nanoAppVersion, info.getId());
        }
        NanoAppInstanceInfo instanceInfo = new NanoAppInstanceInfo();
        ReflectorNanoAppInstanceInfo reflectedInfo = (ReflectorNanoAppInstanceInfo)Reflector.reflector(ReflectorNanoAppInstanceInfo.class, (Object)instanceInfo);
        reflectedInfo.setAppId(nanoAppId);
        reflectedInfo.setAppVersion(nanoAppVersion);
        return instanceInfo;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected List<ContextHubInfo> getContextHubs() {
        return contextHubInfoList;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object createClient(Object contextHubInfo, Object contextHubClientCallback) {
        return ReflectionHelpers.newInstance(ContextHubClient.class);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object createClient(Object contextHubInfo, Object contextHubClientCallback, Object executor) {
        return ReflectionHelpers.newInstance(ContextHubClient.class);
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected Object createClient(Object context, Object contextHubInfo, Object executor, Object contextHubClientCallback) {
        ContextHubClient client = (ContextHubClient)ReflectionHelpers.newInstance(ContextHubClient.class);
        if (context != null && ((Context)context).getAttributionTag() != null) {
            this.attributionTagToClientMap.put((Object)((Context)context).getAttributionTag(), (Object)client);
        }
        return client;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected Object createClient(Context context, ContextHubInfo hubInfo, PendingIntent pendingIntent, long nanoAppId) {
        ContextHubClient client = (ContextHubClient)Shadow.newInstance(ContextHubClient.class, (Class[])new Class[]{ContextHubInfo.class, Boolean.TYPE}, (Object[])new Object[]{hubInfo, false});
        contextHubClientWithPendingIntentList.add(client);
        return client;
    }

    @Nullable
    public List<ContextHubClient> getClientsWithAttributionTag(String attributionTag) {
        return ImmutableList.copyOf((Collection)this.attributionTagToClientMap.get((Object)attributionTag));
    }

    @Nullable
    public List<ContextHubClient> getContextHubClientWithPendingIntentList() {
        return ImmutableList.copyOf(contextHubClientWithPendingIntentList);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object queryNanoApps(ContextHubInfo hubInfo) {
        ContextHubTransaction transaction = (ContextHubTransaction)ReflectionHelpers.callConstructor(ContextHubTransaction.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)4)});
        Collection uids = this.contextHubToNanoappUid.get((Object)hubInfo);
        ArrayList<NanoAppState> nanoAppStates = new ArrayList<NanoAppState>();
        for (Integer uid : uids) {
            NanoAppInstanceInfo info = this.nanoAppUidToInfo.get(uid);
            if (info == null) continue;
            nanoAppStates.add(new NanoAppState(info.getAppId(), info.getAppVersion(), true));
        }
        ContextHubTransaction.Response response = (ContextHubTransaction.Response)ReflectionHelpers.newInstance(ContextHubTransaction.Response.class);
        ReflectorContextHubTransactionResponse reflectedResponse = (ReflectorContextHubTransactionResponse)Reflector.reflector(ReflectorContextHubTransactionResponse.class, (Object)response);
        reflectedResponse.setResult(0);
        reflectedResponse.setContents(nanoAppStates);
        ((ReflectorContextHubTransaction)Reflector.reflector(ReflectorContextHubTransaction.class, (Object)transaction)).setResponse((ContextHubTransaction.Response<List<NanoAppState>>)response);
        return transaction;
    }

    @Implementation
    @HiddenApi
    protected int[] getContextHubHandles() {
        int[] handles = new int[contextHubInfoList.size()];
        for (int i = 0; i < handles.length; ++i) {
            handles[i] = i;
        }
        return handles;
    }

    @Implementation
    @HiddenApi
    protected ContextHubInfo getContextHubInfo(int hubHandle) {
        if (hubHandle < 0 || hubHandle >= contextHubInfoList.size()) {
            return null;
        }
        return contextHubInfoList.get(hubHandle);
    }

    @Implementation
    @HiddenApi
    protected NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        return this.nanoAppUidToInfo.get(nanoAppHandle);
    }

    static {
        contextHubInfoList.add(new ContextHubInfo());
    }

    @ForType(value=NanoAppInstanceInfo.class)
    private static interface ReflectorNanoAppInstanceInfo {
        public void setAppId(long var1);

        public void setAppVersion(int var1);
    }

    @ForType(value=ContextHubTransaction.Response.class)
    private static interface ReflectorContextHubTransactionResponse {
        @Accessor(value="mResult")
        public void setResult(int var1);

        @Accessor(value="mContents")
        public void setContents(List<NanoAppState> var1);
    }

    @ForType(value=ContextHubTransaction.class)
    private static interface ReflectorContextHubTransaction {
        public void setResponse(ContextHubTransaction.Response<List<NanoAppState>> var1);
    }
}

