/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelUuid;
import android.os.Process;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBluetoothGatt;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=BluetoothDevice.class, looseSignatures=true)
public class ShadowBluetoothDevice {
    private static BluetoothSocket bluetoothSocket = null;
    @RealObject
    private BluetoothDevice realBluetoothDevice;
    private String name;
    private ParcelUuid[] uuids;
    private int bondState = 10;
    private boolean createdBond = false;
    private boolean fetchUuidsWithSdpResult = false;
    private int fetchUuidsWithSdpCount = 0;
    private int type = 0;
    private final List<BluetoothGatt> bluetoothGatts = new ArrayList<BluetoothGatt>();
    private Boolean pairingConfirmation = null;
    private byte[] pin = null;
    private String alias;
    private boolean shouldThrowOnGetAliasName = false;
    private BluetoothClass bluetoothClass = null;
    private boolean shouldThrowSecurityExceptions = false;
    private final Map<Integer, byte[]> metadataMap = new HashMap<Integer, byte[]>();
    private int batteryLevel = -100;
    private boolean isInSilenceMode = false;
    private boolean isConnected = false;

    @Deprecated
    public static BluetoothDevice newInstance(String address) {
        return (BluetoothDevice)ReflectionHelpers.callConstructor(BluetoothDevice.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)address)});
    }

    @Resetter
    public static void reset() {
        bluetoothSocket = null;
    }

    @Implementation
    protected static IBluetooth getService() {
        try {
            return ((BluetoothDeviceReflector)Reflector.reflector(BluetoothDeviceReflector.class)).getService();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Implementation
    public Object setAlias(Object alias) {
        this.alias = (String)alias;
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            return 0;
        }
        return true;
    }

    public void setThrowOnGetAliasName(boolean shouldThrow) {
        this.shouldThrowOnGetAliasName = shouldThrow;
    }

    public void setShouldThrowSecurityExceptions(boolean shouldThrow) {
        this.shouldThrowSecurityExceptions = shouldThrow;
    }

    @Implementation
    protected String getName() {
        this.checkForBluetoothConnectPermission();
        return this.name;
    }

    @Implementation
    protected String getAlias() {
        this.checkForBluetoothConnectPermission();
        return this.alias;
    }

    @Implementation(maxSdk=29)
    protected String getAliasName() throws ReflectiveOperationException {
        if (this.shouldThrowOnGetAliasName) {
            throw new ReflectiveOperationException("Exception on getAliasName");
        }
        String name = this.getAlias();
        return name != null ? name : this.getName();
    }

    public void setType(int type) {
        this.type = type;
    }

    @Implementation(minSdk=18)
    protected int getType() {
        this.checkForBluetoothConnectPermission();
        return this.type;
    }

    public void setUuids(ParcelUuid[] uuids) {
        this.uuids = uuids;
    }

    @Implementation
    protected ParcelUuid[] getUuids() {
        this.checkForBluetoothConnectPermission();
        return this.uuids;
    }

    public void setBondState(int bondState) {
        this.bondState = bondState;
    }

    @Implementation
    protected int getBondState() {
        this.checkForBluetoothConnectPermission();
        return this.bondState;
    }

    public void setCreatedBond(boolean createdBond) {
        this.createdBond = createdBond;
    }

    @Implementation
    protected boolean createBond() {
        this.checkForBluetoothConnectPermission();
        return this.createdBond;
    }

    @Implementation(minSdk=29)
    protected BluetoothSocket createInsecureL2capChannel(int psm) throws IOException {
        this.checkForBluetoothConnectPermission();
        return ((BluetoothDeviceReflector)Reflector.reflector(BluetoothDeviceReflector.class, (Object)this.realBluetoothDevice)).createInsecureL2capChannel(psm);
    }

    @Implementation(minSdk=29)
    protected BluetoothSocket createL2capChannel(int psm) throws IOException {
        this.checkForBluetoothConnectPermission();
        return ((BluetoothDeviceReflector)Reflector.reflector(BluetoothDeviceReflector.class, (Object)this.realBluetoothDevice)).createL2capChannel(psm);
    }

    @Implementation
    protected boolean removeBond() {
        this.checkForBluetoothConnectPermission();
        boolean result = this.createdBond;
        this.createdBond = false;
        return result;
    }

    @Implementation
    protected boolean setPin(byte[] pin) {
        this.checkForBluetoothConnectPermission();
        this.pin = pin;
        return true;
    }

    public byte[] getPin() {
        return this.pin;
    }

    @Implementation
    public boolean setPairingConfirmation(boolean confirm) {
        this.checkForBluetoothConnectPermission();
        this.pairingConfirmation = confirm;
        return true;
    }

    public Boolean getPairingConfirmation() {
        return this.pairingConfirmation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected BluetoothSocket createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        this.checkForBluetoothConnectPermission();
        Class<ShadowBluetoothDevice> clazz = ShadowBluetoothDevice.class;
        synchronized (ShadowBluetoothDevice.class) {
            if (bluetoothSocket == null) {
                bluetoothSocket = (BluetoothSocket)Shadow.newInstanceOf(BluetoothSocket.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bluetoothSocket;
        }
    }

    public void setFetchUuidsWithSdpResult(boolean fetchUuidsWithSdpResult) {
        this.fetchUuidsWithSdpResult = fetchUuidsWithSdpResult;
    }

    @Implementation
    protected boolean fetchUuidsWithSdp() {
        this.checkForBluetoothConnectPermission();
        ++this.fetchUuidsWithSdpCount;
        return this.fetchUuidsWithSdpResult;
    }

    public int getFetchUuidsWithSdpCount() {
        return this.fetchUuidsWithSdpCount;
    }

    @Implementation(minSdk=18)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        this.checkForBluetoothConnectPermission();
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=23)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        this.checkForBluetoothConnectPermission();
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=26)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        this.checkForBluetoothConnectPermission();
        return this.connectGatt(callback);
    }

    private BluetoothGatt connectGatt(BluetoothGattCallback callback) {
        BluetoothGatt bluetoothGatt = ShadowBluetoothGatt.newInstance(this.realBluetoothDevice);
        this.bluetoothGatts.add(bluetoothGatt);
        ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
        shadowBluetoothGatt.setGattCallback(callback);
        return bluetoothGatt;
    }

    public List<BluetoothGatt> getBluetoothGatts() {
        return this.bluetoothGatts;
    }

    public void simulateGattConnectionChange(int status, int newState) {
        for (BluetoothGatt bluetoothGatt : this.bluetoothGatts) {
            ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
            BluetoothGattCallback gattCallback = shadowBluetoothGatt.getGattCallback();
            gattCallback.onConnectionStateChange(bluetoothGatt, status, newState);
        }
    }

    @Implementation
    public BluetoothClass getBluetoothClass() {
        this.checkForBluetoothConnectPermission();
        return this.bluetoothClass;
    }

    public void setBluetoothClass(BluetoothClass bluetoothClass) {
        this.bluetoothClass = bluetoothClass;
    }

    @Implementation(minSdk=29)
    protected boolean setMetadata(int key, byte[] value) {
        this.checkForBluetoothConnectPermission();
        this.metadataMap.put(key, value);
        return true;
    }

    @Implementation(minSdk=29)
    protected byte[] getMetadata(int key) {
        this.checkForBluetoothConnectPermission();
        return this.metadataMap.get(key);
    }

    public void setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    @Implementation(minSdk=27)
    protected int getBatteryLevel() {
        this.checkForBluetoothConnectPermission();
        return this.batteryLevel;
    }

    @Implementation(minSdk=29)
    public boolean setSilenceMode(boolean isInSilenceMode) {
        this.checkForBluetoothConnectPermission();
        this.isInSilenceMode = isInSilenceMode;
        return true;
    }

    @Implementation(minSdk=20)
    protected boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    @Implementation(minSdk=29)
    protected boolean isInSilenceMode() {
        this.checkForBluetoothConnectPermission();
        return this.isInSilenceMode;
    }

    static ShadowInstrumentation getShadowInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
    }

    private void checkForBluetoothConnectPermission() {
        if (this.shouldThrowSecurityExceptions && Build.VERSION.SDK_INT >= 31 && !ShadowBluetoothDevice.checkPermission("android.permission.BLUETOOTH_CONNECT")) {
            throw new SecurityException("Bluetooth connect permission required.");
        }
    }

    static boolean checkPermission(String permission2) {
        return ShadowBluetoothDevice.getShadowInstrumentation().checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @ForType(value=BluetoothDevice.class)
    static interface BluetoothDeviceReflector {
        @Static
        @Direct
        public IBluetooth getService();

        @Direct
        public BluetoothSocket createInsecureL2capChannel(int var1);

        @Direct
        public BluetoothSocket createL2capChannel(int var1);
    }
}

