/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.app.IActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Process;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.SparseIntArray;
import androidx.annotation.RequiresApi;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplicationPackageManager;
import org.robolectric.shadows.ShadowUserManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ActivityManager.class, looseSignatures=true)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;
    private final List<ActivityManager.AppTask> appTasks = new CopyOnWriteArrayList<ActivityManager.AppTask>();
    private final List<ActivityManager.RunningTaskInfo> tasks = new CopyOnWriteArrayList<ActivityManager.RunningTaskInfo>();
    private final List<ActivityManager.RunningServiceInfo> services = new CopyOnWriteArrayList<ActivityManager.RunningServiceInfo>();
    private static final List<ActivityManager.RunningAppProcessInfo> processes = new CopyOnWriteArrayList<ActivityManager.RunningAppProcessInfo>();
    private final List<ImportanceListener> importanceListeners = new CopyOnWriteArrayList<ImportanceListener>();
    private final SparseIntArray uidImportances = new SparseIntArray();
    @RealObject
    private ActivityManager realObject;
    private Boolean isLowRamDeviceOverride = null;
    private int lockTaskModeState = 0;
    private boolean isBackgroundRestricted;
    private final Deque<Object> appExitInfoList = new ArrayDeque<Object>();
    private ConfigurationInfo configurationInfo;
    private Context context;

    @Implementation
    protected void __constructor__(Context context, Handler handler) {
        Shadow.invokeConstructor(ActivityManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler)});
        this.context = context;
        ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
        ShadowActivityManager.fillInProcessInfo(processInfo);
        processInfo.processName = context.getPackageName();
        processInfo.pkgList = new String[]{context.getPackageName()};
        processes.add(processInfo);
    }

    @Implementation
    protected int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    protected static boolean isUserAMonkey() {
        return false;
    }

    @Implementation(minSdk=17)
    @HiddenApi
    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    protected static int getCurrentUser() {
        return UserHandle.myUserId();
    }

    @Implementation
    protected List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation(minSdk=21)
    protected List<ActivityManager.AppTask> getAppTasks() {
        return this.appTasks;
    }

    @Implementation
    protected List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return this.services;
    }

    @Implementation
    protected List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        if (processes.isEmpty()) {
            return null;
        }
        return processes;
    }

    @Implementation
    protected static void getMyMemoryState(ActivityManager.RunningAppProcessInfo inState) {
        ShadowActivityManager.fillInProcessInfo(inState);
        for (ActivityManager.RunningAppProcessInfo info : processes) {
            if (info.pid != Process.myPid()) continue;
            inState.importance = info.importance;
            inState.lru = info.lru;
            inState.importanceReasonCode = info.importanceReasonCode;
            inState.importanceReasonPid = info.importanceReasonPid;
            inState.lastTrimLevel = info.lastTrimLevel;
            inState.pkgList = info.pkgList;
            inState.processName = info.processName;
        }
    }

    private static void fillInProcessInfo(ActivityManager.RunningAppProcessInfo processInfo) {
        processInfo.pid = Process.myPid();
        processInfo.uid = Process.myUid();
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected boolean switchUser(int userid) {
        ShadowUserManager shadowUserManager = (ShadowUserManager)Shadow.extract((Object)this.context.getSystemService("user"));
        shadowUserManager.switchUser(userid);
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean switchUser(UserHandle userHandle) {
        return this.switchUser(userHandle.getIdentifier());
    }

    @Implementation
    protected void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    protected void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.availMem = this.memoryInfo.availMem;
            outInfo.lowMemory = this.memoryInfo.lowMemory;
            outInfo.threshold = this.memoryInfo.threshold;
            outInfo.totalMem = this.memoryInfo.totalMem;
        }
    }

    @Implementation
    protected ConfigurationInfo getDeviceConfigurationInfo() {
        return this.configurationInfo == null ? new ConfigurationInfo() : this.configurationInfo;
    }

    public void setDeviceConfigurationInfo(ConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void setAppTasks(List<ActivityManager.AppTask> appTasks) {
        this.appTasks.clear();
        this.appTasks.addAll(appTasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        this.services.clear();
        this.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        ShadowActivityManager.processes.clear();
        ShadowActivityManager.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    @Implementation(minSdk=26)
    protected static IActivityManager getService() {
        return (IActivityManager)ReflectionHelpers.createNullProxy(IActivityManager.class);
    }

    @Implementation(minSdk=19)
    protected boolean isLowRamDevice() {
        if (this.isLowRamDeviceOverride != null) {
            return this.isLowRamDeviceOverride;
        }
        return ((ActivityManagerReflector)Reflector.reflector(ActivityManagerReflector.class, (Object)this.realObject)).isLowRamDevice();
    }

    public void setIsLowRamDevice(boolean isLowRamDevice) {
        this.isLowRamDeviceOverride = isLowRamDevice;
    }

    @Implementation(minSdk=26)
    protected void addOnUidImportanceListener(Object listener, Object importanceCutpoint) {
        this.importanceListeners.add(new ImportanceListener(listener, (Integer)importanceCutpoint));
    }

    @Implementation(minSdk=26)
    protected void removeOnUidImportanceListener(Object listener) {
        this.importanceListeners.remove(new ImportanceListener(listener));
    }

    @Implementation(minSdk=23)
    protected int getPackageImportance(String packageName) {
        try {
            return this.uidImportances.get(this.context.getPackageManager().getPackageUid(packageName, 0), 1000);
        }
        catch (PackageManager.NameNotFoundException e) {
            return 1000;
        }
    }

    @Implementation(minSdk=26)
    protected int getUidImportance(int uid) {
        return this.uidImportances.get(uid, 1000);
    }

    public void setUidImportance(int uid, int importance) {
        this.uidImportances.put(uid, importance);
        for (ImportanceListener listener : this.importanceListeners) {
            listener.onUidImportanceChanged(uid, importance);
        }
    }

    @Implementation(minSdk=23)
    protected int getLockTaskModeState() {
        return this.lockTaskModeState;
    }

    @Implementation(minSdk=21)
    protected boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    public void setLockTaskModeState(int lockTaskModeState) {
        this.lockTaskModeState = lockTaskModeState;
    }

    @Resetter
    public static void reset() {
        processes.clear();
    }

    @Implementation(minSdk=28)
    protected boolean isBackgroundRestricted() {
        return this.isBackgroundRestricted;
    }

    public void setBackgroundRestricted(boolean isBackgroundRestricted) {
        this.isBackgroundRestricted = isBackgroundRestricted;
    }

    @Implementation(minSdk=30)
    protected Object getHistoricalProcessExitReasons(Object packageName, Object pid, Object maxNum) {
        return this.appExitInfoList.stream().filter(appExitInfo -> (Integer)pid == 0 || ((ApplicationExitInfo)appExitInfo).getPid() == ((Integer)pid).intValue()).limit((Integer)maxNum == 0 ? (long)this.appExitInfoList.size() : (long)((Integer)maxNum).intValue()).collect(Collectors.toCollection(ArrayList::new));
    }

    @Deprecated
    @RequiresApi(api=30)
    public void addApplicationExitInfo(String processName, int pid, int reason, int status) {
        ApplicationExitInfo info = ApplicationExitInfoBuilder.newBuilder().setProcessName(processName).setPid(pid).setReason(reason).setStatus(status).build();
        this.addApplicationExitInfo(info);
    }

    @RequiresApi(api=30)
    public void addApplicationExitInfo(Object info) {
        Preconditions.checkArgument((boolean)(info instanceof ApplicationExitInfo));
        this.appExitInfoList.addFirst(info);
    }

    @Implementation
    protected boolean clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        this.context.getPackageManager().clearApplicationUserData(packageName, observer);
        return true;
    }

    public boolean isApplicationUserDataCleared() {
        PackageManager packageManager = RuntimeEnvironment.getApplication().getPackageManager();
        return ((ShadowApplicationPackageManager)Shadow.extract((Object)packageManager)).getClearedApplicationUserDataPackages().contains(RuntimeEnvironment.getApplication().getPackageName());
    }

    @ForType(value=ActivityManager.class)
    static interface ActivityManagerReflector {
        @Direct
        public boolean isLowRamDevice();
    }

    private static class ImportanceListener {
        private final ActivityManager.OnUidImportanceListener listener;
        private final int importanceCutpoint;
        private final ArrayMap<Integer, Boolean> lastAboveCuts = new ArrayMap();

        ImportanceListener(Object listener) {
            this(listener, 0);
        }

        ImportanceListener(Object listener, int importanceCutpoint) {
            this.listener = (ActivityManager.OnUidImportanceListener)listener;
            this.importanceCutpoint = importanceCutpoint;
        }

        void onUidImportanceChanged(int uid, int importance) {
            Boolean isAboveCut = importance > this.importanceCutpoint;
            if (!isAboveCut.equals(this.lastAboveCuts.get((Object)uid))) {
                this.lastAboveCuts.put((Object)uid, (Object)isAboveCut);
                this.listener.onUidImportance(uid, importance);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportanceListener)) {
                return false;
            }
            ImportanceListener that = (ImportanceListener)o;
            return this.listener.equals(that.listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    @RequiresApi(api=30)
    public static class ApplicationExitInfoBuilder {
        private final ApplicationExitInfo instance = new ApplicationExitInfo();

        public static ApplicationExitInfoBuilder newBuilder() {
            return new ApplicationExitInfoBuilder();
        }

        public ApplicationExitInfoBuilder setDefiningUid(int uid) {
            this.instance.setDefiningUid(uid);
            return this;
        }

        public ApplicationExitInfoBuilder setDescription(String description) {
            this.instance.setDescription(description);
            return this;
        }

        public ApplicationExitInfoBuilder setImportance(int importance) {
            this.instance.setImportance(importance);
            return this;
        }

        public ApplicationExitInfoBuilder setPackageUid(int packageUid) {
            this.instance.setPackageUid(packageUid);
            return this;
        }

        public ApplicationExitInfoBuilder setPid(int pid) {
            this.instance.setPid(pid);
            return this;
        }

        public ApplicationExitInfoBuilder setProcessName(String processName) {
            this.instance.setProcessName(processName);
            return this;
        }

        public ApplicationExitInfoBuilder setProcessStateSummary(byte[] processStateSummary) {
            this.instance.setProcessStateSummary(processStateSummary);
            return this;
        }

        public ApplicationExitInfoBuilder setPss(long pss) {
            this.instance.setPss(pss);
            return this;
        }

        public ApplicationExitInfoBuilder setRealUid(int realUid) {
            this.instance.setRealUid(realUid);
            return this;
        }

        public ApplicationExitInfoBuilder setReason(int reason) {
            this.instance.setReason(reason);
            return this;
        }

        public ApplicationExitInfoBuilder setRss(long rss) {
            this.instance.setRss(rss);
            return this;
        }

        public ApplicationExitInfoBuilder setStatus(int status) {
            this.instance.setStatus(status);
            return this;
        }

        public ApplicationExitInfoBuilder setTimestamp(long timestamp) {
            this.instance.setTimestamp(timestamp);
            return this;
        }

        public ApplicationExitInfo build() {
            return this.instance;
        }

        private ApplicationExitInfoBuilder() {
        }
    }
}

