/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.companion.AssociationInfo;
import android.net.MacAddress;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class AssociationInfoBuilder {
    private int id;
    private int userId;
    private String packageName;
    private String tag;
    private String deviceMacAddress;
    private CharSequence displayName;
    private String deviceProfile;
    private Object associatedDevice;
    private boolean selfManaged;
    private boolean notifyOnDeviceNearby;
    private long approvedMs;
    private boolean revoked;
    private long lastTimeConnectedMs;
    private int systemDataSyncFlags;

    private AssociationInfoBuilder() {
    }

    public static AssociationInfoBuilder newBuilder() {
        return new AssociationInfoBuilder();
    }

    public AssociationInfoBuilder setId(int id2) {
        this.id = id2;
        return this;
    }

    public AssociationInfoBuilder setUserId(int userId) {
        this.userId = userId;
        return this;
    }

    public AssociationInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public AssociationInfoBuilder setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public AssociationInfoBuilder setDeviceMacAddress(String deviceMacAddress) {
        this.deviceMacAddress = deviceMacAddress;
        return this;
    }

    public AssociationInfoBuilder setDisplayName(CharSequence displayName) {
        this.displayName = displayName;
        return this;
    }

    public AssociationInfoBuilder setDeviceProfile(String deviceProfile) {
        this.deviceProfile = deviceProfile;
        return this;
    }

    public AssociationInfoBuilder setAssociatedDevice(Object associatedDevice) {
        this.associatedDevice = associatedDevice;
        return this;
    }

    public AssociationInfoBuilder setSelfManaged(boolean selfManaged) {
        this.selfManaged = selfManaged;
        return this;
    }

    public AssociationInfoBuilder setNotifyOnDeviceNearby(boolean notifyOnDeviceNearby) {
        this.notifyOnDeviceNearby = notifyOnDeviceNearby;
        return this;
    }

    public AssociationInfoBuilder setApprovedMs(long approvedMs) {
        this.approvedMs = approvedMs;
        return this;
    }

    public AssociationInfoBuilder setRevoked(boolean revoked) {
        this.revoked = revoked;
        return this;
    }

    public AssociationInfoBuilder setLastTimeConnectedMs(long lastTimeConnectedMs) {
        this.lastTimeConnectedMs = lastTimeConnectedMs;
        return this;
    }

    public AssociationInfoBuilder setSystemDataSyncFlags(int systemDataSyncFlags) {
        this.systemDataSyncFlags = systemDataSyncFlags;
        return this;
    }

    public AssociationInfo build() {
        try {
            MacAddress macAddress;
            MacAddress macAddress2 = macAddress = this.deviceMacAddress == null ? null : MacAddress.fromString((String)this.deviceMacAddress);
            if (RuntimeEnvironment.getApiLevel() <= 33) {
                if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mRevoked")) {
                    return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.revoked), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs)});
                }
                return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs)});
            }
            if (RuntimeEnvironment.getApiLevel() <= 34) {
                if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mAssociatedDevice")) {
                    return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Class.forName("android.companion.AssociatedDevice"), (Object)this.associatedDevice), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.revoked), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.systemDataSyncFlags)});
                }
                return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.revoked), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs)});
            }
            return (AssociationInfo)ReflectionHelpers.callConstructor(AssociationInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.userId), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.tag), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)macAddress), ReflectionHelpers.ClassParameter.from(CharSequence.class, (Object)this.displayName), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.deviceProfile), ReflectionHelpers.ClassParameter.from(Class.forName("android.companion.AssociatedDevice"), (Object)this.associatedDevice), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.selfManaged), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.notifyOnDeviceNearby), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.revoked), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.approvedMs), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.lastTimeConnectedMs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.systemDataSyncFlags)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

