/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowUsbDeviceConnection;

@Implements(value=UsbRequest.class)
public class ShadowUsbRequest {
    @RealObject
    private UsbRequest realUsbRequest;
    private UsbDeviceConnection usbDeviceConnection;
    private PipedInputStream incomingDataPipedInputStream;
    private PipedOutputStream incomingDataPipedOutputStream;
    private final ShadowUsbDeviceConnection.DataListener dataListener = new ShadowUsbDeviceConnection.DataListener(){

        @Override
        public void onDataReceived(byte[] data) {
            try {
                ShadowUsbRequest.this.incomingDataPipedOutputStream.write(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public UsbRequest getUsbRequest() {
            return ShadowUsbRequest.this.realUsbRequest;
        }
    };

    @Implementation
    protected boolean initialize(UsbDeviceConnection connection, UsbEndpoint endpoint) {
        try {
            this.incomingDataPipedInputStream = new PipedInputStream();
            this.incomingDataPipedOutputStream = new PipedOutputStream(this.incomingDataPipedInputStream);
        }
        catch (IOException e) {
            return false;
        }
        Shadows.shadowOf(connection).registerDataListener(this.dataListener);
        this.usbDeviceConnection = connection;
        return true;
    }

    @Implementation
    protected void close() {
        if (this.usbDeviceConnection != null) {
            Shadows.shadowOf(this.usbDeviceConnection).unregisterDataListener();
            this.usbDeviceConnection = null;
            try {
                this.incomingDataPipedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.incomingDataPipedOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Implementation
    protected boolean queue(ByteBuffer buffer, int length) {
        if (Build.VERSION.SDK_INT < 28) {
            length = Math.min(length, 16384);
        }
        byte[] bytes = new byte[length];
        try {
            int bytesRead;
            for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                bytesRead = this.incomingDataPipedInputStream.read(bytes, totalBytesRead, length - totalBytesRead);
                if (bytesRead >= 0) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        buffer.put(bytes);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean queue(ByteBuffer buffer) {
        return this.queue(buffer, buffer.remaining());
    }
}

